/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nv;

import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUpdateCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPNameVerificationUpdateCmd
extends EPPUpdateCmd {
    private static Logger cat = LoggerFactory.getLogger(EPPNameVerificationUpdateCmd.class);
    public static final String ELM_LOCALNAME = "update";
    public static final String ELM_NAME = "nv:update";
    private static final String ELM_CODE = "code";
    private static final String ELM_CHG = "chg";
    private String code;
    private EPPAuthInfo authInfo;

    public EPPNameVerificationUpdateCmd() {
    }

    public EPPNameVerificationUpdateCmd(String aTransId) {
        super(aTransId);
    }

    public EPPNameVerificationUpdateCmd(String aTransId, String aCode, EPPAuthInfo aAuthInfo) {
        super(aTransId);
        this.code = aCode;
        this.setAuthInfo(aAuthInfo);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:nv-1.0";
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String aCode) {
        this.code = aCode;
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public void setAuthInfo(EPPAuthInfo aAuthInfo) {
        if (aAuthInfo != null) {
            this.authInfo = aAuthInfo;
            this.authInfo.setRootName("urn:ietf:params:xml:ns:nv-1.0", "nv:authInfo");
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.code == null) {
            throw new EPPEncodeException("Undefined code in EPPNameVerificationUpdateCmd");
        }
        if (this.authInfo == null) {
            throw new EPPEncodeException("Undefined authInfo in EPPNameVerificationUpdateCmd");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.code, "urn:ietf:params:xml:ns:nv-1.0", "nv:code");
        Element chg = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", "nv:chg");
        root.appendChild(chg);
        EPPUtil.encodeComp(aDocument, chg, this.authInfo);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.code = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_CODE);
        Element theChgElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_CHG);
        if (theChgElm == null) {
            throw new EPPDecodeException("EPPNameVerificationUpdateCmd.doDecode(): Couldn't find the chg element");
        }
        this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(theChgElm, "urn:ietf:params:xml:ns:nv-1.0", "nv:authInfo", EPPAuthInfo.class);
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPNameVerificationUpdateCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPNameVerificationUpdateCmd other = (EPPNameVerificationUpdateCmd)aObject;
        if (!EqualityUtil.equals(this.code, other.code)) {
            cat.error("EPPNameVerificationInfoCmd.equals(): code not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.authInfo, other.authInfo)) {
            cat.error("EPPNameVerificationUpdateCmd.equals(): authInfo not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPNameVerificationUpdateCmd clone = (EPPNameVerificationUpdateCmd)super.clone();
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }
}

