/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nv;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoInputResult;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoResult;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoSignedCodeResult;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPNameVerificationInfoResp
extends EPPResponse {
    private static Logger cat = LoggerFactory.getLogger(EPPNameVerificationInfoResp.class);
    public static final String ELM_LOCALNAME = "infData";
    public static final String ELM_NAME = "nv:infData";
    private EPPNameVerificationInfoResult result;

    public EPPNameVerificationInfoResp() {
    }

    public EPPNameVerificationInfoResp(EPPTransId aTransId) {
        super(aTransId);
    }

    public EPPNameVerificationInfoResp(EPPTransId aTransId, EPPNameVerificationInfoResult aResult) {
        super(aTransId);
        this.result = aResult;
    }

    public EPPNameVerificationInfoResult getCreateResult() {
        return this.result;
    }

    public void setCreateResult(EPPNameVerificationInfoResult aResult) {
        this.result = aResult;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.result);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.result = (EPPNameVerificationInfoResult)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:nv-1.0", "nv:signedCode", EPPNameVerificationInfoSignedCodeResult.class);
        if (this.result == null) {
            this.result = (EPPNameVerificationInfoResult)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:nv-1.0", "nv:input", EPPNameVerificationInfoInputResult.class);
        }
        if (this.result == null) {
            throw new EPPDecodeException("EPPNameVerificationInfoResp.doDecode(): Unable to decode one of the possible info results");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPNameVerificationInfoResp clone = (EPPNameVerificationInfoResp)super.clone();
        clone.result = (EPPNameVerificationInfoResult)this.result.clone();
        return clone;
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:nv-1.0";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPNameVerificationInfoResp)) {
            return false;
        }
        EPPNameVerificationInfoResp other = (EPPNameVerificationInfoResp)aObject;
        if (this.result instanceof EPPNameVerificationInfoSignedCodeResult) {
            if (!EqualityUtil.equals((EPPNameVerificationInfoSignedCodeResult)this.result, (EPPNameVerificationInfoSignedCodeResult)other.result)) {
                cat.error("EPPNameVerificationInfoResp.equals(): SignedCode result not equal");
                return false;
            }
        } else if (!EqualityUtil.equals((EPPNameVerificationInfoInputResult)this.result, (EPPNameVerificationInfoInputResult)other.result)) {
            cat.error("EPPNameVerificationInfoResp.equals(): Input result not equal");
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }
}

