/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nv;

import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.nv.EPPDomainNameVerification;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoResult;
import com.verisign.epp.codec.nv.EPPRealNameVerification;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPNameVerificationInfoInputResult
implements EPPNameVerificationInfoResult {
    private static Logger cat = LoggerFactory.getLogger(EPPNameVerificationInfoInputResult.class);
    public static final String ELM_LOCALNAME = "input";
    public static final String ELM_NAME = "nv:input";
    private EPPDomainNameVerification dnv;
    private EPPRealNameVerification rnv;
    private EPPAuthInfo authInfo;

    public EPPNameVerificationInfoInputResult() {
    }

    public EPPNameVerificationInfoInputResult(EPPDomainNameVerification aDnv) {
        this.dnv = aDnv;
    }

    public EPPNameVerificationInfoInputResult(EPPDomainNameVerification aDnv, EPPAuthInfo aAuthInfo) {
        this.dnv = aDnv;
        this.setAuthInfo(aAuthInfo);
    }

    public EPPNameVerificationInfoInputResult(EPPRealNameVerification aRnv) {
        this.rnv = aRnv;
    }

    public EPPNameVerificationInfoInputResult(EPPRealNameVerification aRnv, EPPAuthInfo aAuthInfo) {
        this.rnv = aRnv;
        this.setAuthInfo(aAuthInfo);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:nv-1.0";
    }

    public boolean hasDnv() {
        return this.dnv != null;
    }

    public EPPDomainNameVerification getDnv() {
        return this.dnv;
    }

    public void setDnv(EPPDomainNameVerification aDnv) {
        this.dnv = aDnv;
    }

    public boolean hasRnv() {
        return this.rnv != null;
    }

    public EPPRealNameVerification getRnv() {
        return this.rnv;
    }

    public void setRnv(EPPRealNameVerification aRnv) {
        this.rnv = aRnv;
    }

    public boolean hasAuthInfo() {
        return this.authInfo != null;
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public void setAuthInfo(EPPAuthInfo aAuthInfo) {
        if (aAuthInfo != null) {
            this.authInfo = aAuthInfo;
            this.authInfo.setRootName("urn:ietf:params:xml:ns:nv-1.0", "nv:authInfo");
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.dnv != null && this.rnv != null) {
            throw new EPPEncodeException("Both DNV and RNV cannot be set in EPPNameVerificationInfoInputResult");
        }
        if (this.dnv == null && this.rnv == null) {
            throw new EPPEncodeException("Either DNV and RNV must be set in EPPNameVerificationInfoInputResult");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", ELM_NAME);
        if (this.hasDnv()) {
            EPPUtil.encodeComp(aDocument, root, this.dnv);
        }
        if (this.hasRnv()) {
            EPPUtil.encodeComp(aDocument, root, this.rnv);
        }
        if (this.authInfo != null) {
            EPPUtil.encodeComp(aDocument, root, this.authInfo);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.dnv = (EPPDomainNameVerification)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:nv-1.0", "nv:dnv", EPPDomainNameVerification.class);
        this.rnv = (EPPRealNameVerification)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:nv-1.0", "nv:rnv", EPPRealNameVerification.class);
        this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:nv-1.0", "nv:authInfo", EPPAuthInfo.class);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPNameVerificationInfoInputResult)) {
            cat.error("EPPNameVerificationInfoInputResult.equals(): object " + aObject.getClass().getName() + "!= EPPNameVerificationInfoInputResult");
            return false;
        }
        EPPNameVerificationInfoInputResult other = (EPPNameVerificationInfoInputResult)aObject;
        if (!EqualityUtil.equals(this.dnv, other.dnv)) {
            cat.error("EPPNameVerificationInfoInputResult.equals(): dnv not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.rnv, other.rnv)) {
            cat.error("EPPNameVerificationInfoInputResult.equals(): rnv not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.authInfo, other.authInfo)) {
            cat.error("EPPNameVerificationInfoInputResult.equals(): authInfo not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPNameVerificationInfoInputResult clone = (EPPNameVerificationInfoInputResult)super.clone();
        if (this.dnv != null) {
            clone.dnv = (EPPDomainNameVerification)this.dnv.clone();
        }
        if (this.rnv != null) {
            clone.rnv = (EPPRealNameVerification)this.rnv.clone();
        }
        if (this.authInfo != null) {
            clone.authInfo = (EPPAuthInfo)this.authInfo.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

