/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nameWatch;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPRenewCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.nameWatch.EPPNameWatchPeriod;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPNameWatchRenewCmd
extends EPPRenewCmd {
    static final String ELM_NAME = "nameWatch:renew";
    private static final String ELM_ROID = "nameWatch:roid";
    private static final String ELM_CURRENT_EXPIRATION_DATE = "nameWatch:curExpDate";
    private String roid = null;
    private EPPNameWatchPeriod period = null;
    private Date curExpDate = null;

    public EPPNameWatchRenewCmd() {
        this.roid = null;
        this.curExpDate = null;
        this.period = new EPPNameWatchPeriod(1);
    }

    public EPPNameWatchRenewCmd(String aTransId, String aRoid, Date aCurExpDate) {
        super(aTransId);
        this.roid = aRoid;
        this.curExpDate = aCurExpDate;
        this.period = new EPPNameWatchPeriod(1);
    }

    public EPPNameWatchRenewCmd(String aTransId, String aRoid, Date aCurExpDate, EPPNameWatchPeriod aPeriod) {
        super(aTransId);
        this.roid = aRoid;
        this.curExpDate = aCurExpDate;
        this.period = aPeriod;
    }

    @Override
    public String getNamespace() {
        return "http://www.nic.name/epp/nameWatch-1.0";
    }

    @Override
    public String getKey() {
        return this.getRoid();
    }

    public String getRoid() {
        return this.roid;
    }

    public void setRoid(String aRoid) {
        this.roid = aRoid;
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPNameWatchRenewCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPNameWatchRenewCmd theMap = (EPPNameWatchRenewCmd)aObject;
        if (!(this.roid != null ? this.roid.equals(theMap.roid) : theMap.roid == null)) {
            return false;
        }
        if (!(this.curExpDate != null ? this.curExpDate.equals(theMap.curExpDate) : theMap.curExpDate == null)) {
            return false;
        }
        return this.period != null ? this.period.equals(theMap.period) : theMap.period == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPNameWatchRenewCmd clone = (EPPNameWatchRenewCmd)super.clone();
        if (this.period != null) {
            clone.period = (EPPNameWatchPeriod)this.period.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public Date getCurExpDate() {
        return this.curExpDate;
    }

    public EPPNameWatchPeriod getPeriod() {
        return this.period;
    }

    public void setCurExpDate(Date newCurExpDate) {
        this.curExpDate = newCurExpDate;
    }

    public void setPeriod(EPPNameWatchPeriod aPeriod) {
        this.period = aPeriod;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("EPPNameWatchRenewCmd invalid state: " + e);
        }
        Element root = aDocument.createElementNS("http://www.nic.name/epp/nameWatch-1.0", ELM_NAME);
        root.setAttribute("xmlns:nameWatch", "http://www.nic.name/epp/nameWatch-1.0");
        EPPUtil.encodeString(aDocument, root, this.roid, "http://www.nic.name/epp/nameWatch-1.0", ELM_ROID);
        EPPUtil.encodeDate(aDocument, root, this.curExpDate, "http://www.nic.name/epp/nameWatch-1.0", ELM_CURRENT_EXPIRATION_DATE);
        if (!this.period.isPeriodUnspec()) {
            EPPUtil.encodeComp(aDocument, root, this.period);
        }
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.roid = EPPUtil.decodeString(aElement, "http://www.nic.name/epp/nameWatch-1.0", ELM_ROID);
        this.curExpDate = EPPUtil.decodeDate(aElement, "http://www.nic.name/epp/nameWatch-1.0", ELM_CURRENT_EXPIRATION_DATE);
        this.period = (EPPNameWatchPeriod)EPPUtil.decodeComp(aElement, "http://www.nic.name/epp/nameWatch-1.0", "nameWatch:period", EPPNameWatchPeriod.class);
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPDecodeException("Invalid state on EPPNameWatchRenewCmd.decode: " + e);
        }
    }

    void validateState() throws EPPCodecException {
        if (this.roid == null) {
            throw new EPPCodecException("roid required attribute is not set");
        }
        if (this.curExpDate == null) {
            throw new EPPCodecException("curExpDate required attribute is not set");
        }
    }
}

