/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.maintenance.v1_0;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPMsgQueue;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceDescription;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceId;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceInfoCmd;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceInfoResp;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceIntervention;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceItem;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceListItem;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceSystem;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceType;
import com.verisign.epp.util.TestThread;
import java.util.GregorianCalendar;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPMaintenanceTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPMaintenanceTst(String name) {
        super(name);
    }

    public void testInfoCommandId() {
        EPPCodecTst.printStart("testInfoCommandId");
        EPPMaintenanceInfoCmd theCommand = new EPPMaintenanceInfoCmd("ABC-12345", "2e6df9b0-4092-4491-bcc8-9fb2166dcee6");
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testInfoCommandId");
    }

    public void testInfoCommandList() {
        EPPCodecTst.printStart("testInfoCommandList");
        EPPMaintenanceInfoCmd theCommand = new EPPMaintenanceInfoCmd("ABC-12345");
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testInfoCommandList");
    }

    public void testInfoResponseId() {
        EPPCodecTst.printStart("testInfoResponseId");
        EPPTransId theTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPMaintenanceItem theMaintenance = new EPPMaintenanceItem();
        theMaintenance.setMaintenanceId(new EPPMaintenanceId("2e6df9b0-4092-4491-bcc8-9fb2166dcee6"));
        theMaintenance.addSystem(new EPPMaintenanceSystem("EPP", "epp.registry.example", EPPMaintenanceSystem.Impact.full));
        theMaintenance.setEnvironment(EPPMaintenanceItem.Environment.production);
        theMaintenance.setStartDate(new GregorianCalendar(2021, 9, 30, 6, 0).getTime());
        theMaintenance.setEndDate(new GregorianCalendar(2021, 9, 30, 14, 25, 57).getTime());
        theMaintenance.setReason(EPPMaintenanceItem.Reason.planned);
        theMaintenance.setDetail("https://www.registry.example/notice?123");
        theMaintenance.addDescription(new EPPMaintenanceDescription("free text", EPPMaintenanceDescription.Type.plain, "en"));
        theMaintenance.addDescription(new EPPMaintenanceDescription("Freitext", EPPMaintenanceDescription.Type.plain, "de"));
        theMaintenance.addTld("example");
        theMaintenance.addTld("test");
        theMaintenance.setIntervention(new EPPMaintenanceIntervention(false, false));
        theMaintenance.setCreatedDate(new GregorianCalendar(2021, 3, 8, 22, 10).getTime());
        EPPMaintenanceInfoResp theResp = new EPPMaintenanceInfoResp(theTransId, theMaintenance);
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        theMaintenance = new EPPMaintenanceItem();
        theMaintenance.setMaintenanceId(new EPPMaintenanceId("2e6df9b0-4092-4491-bcc8-9fb2166dcee6", "test name", null));
        theMaintenance.addType(new EPPMaintenanceType("Routine Maintenance"));
        theMaintenance.addSystem(new EPPMaintenanceSystem("EPP", "all.registry.example", EPPMaintenanceSystem.Impact.partial));
        theMaintenance.setEnvironment(EPPMaintenanceItem.Environment.custom);
        theMaintenance.setCustomEnvironment("customEnv");
        theMaintenance.setStartDate(new GregorianCalendar(2021, 9, 30, 6, 0).getTime());
        theMaintenance.setEndDate(new GregorianCalendar(2021, 9, 30, 14, 25, 57).getTime());
        theMaintenance.setReason(EPPMaintenanceItem.Reason.planned);
        theMaintenance.setDetail("https://www.registry.example/notice?123");
        theMaintenance.addDescription(new EPPMaintenanceDescription("<!DOCTYPE html>\n<html>\n<body>\n\n<h1>My First Heading</h1>\n<p>My first paragraph.</p>\n\n</body>\n</html>", EPPMaintenanceDescription.Type.html, "en"));
        theMaintenance.addTld("example");
        theMaintenance.addTld("test");
        theMaintenance.setIntervention(new EPPMaintenanceIntervention(false, false));
        theMaintenance.setCreatedDate(new GregorianCalendar(2021, 3, 8, 22, 10).getTime());
        theMaintenance.setLastUpdatedDate(new GregorianCalendar(2021, 10, 5, 20, 50).getTime());
        theResp = new EPPMaintenanceInfoResp(theTransId, theMaintenance);
        theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        theMaintenance = new EPPMaintenanceItem();
        theMaintenance.setMaintenanceId(new EPPMaintenanceId("2e6df9b0-4092-4491-bcc8-9fb2166dcee6"));
        theMaintenance.addSystem(new EPPMaintenanceSystem("EPP", "min.registry.example", EPPMaintenanceSystem.Impact.partial));
        theMaintenance.setEnvironment(EPPMaintenanceItem.Environment.ote);
        theMaintenance.setStartDate(new GregorianCalendar(2021, 9, 30, 6, 0).getTime());
        theMaintenance.setEndDate(new GregorianCalendar(2021, 9, 30, 14, 25, 57).getTime());
        theMaintenance.setReason(EPPMaintenanceItem.Reason.planned);
        theMaintenance.addTld("example");
        theMaintenance.addTld("test");
        theMaintenance.setIntervention(new EPPMaintenanceIntervention(false, false));
        theMaintenance.setCreatedDate(new GregorianCalendar(2021, 3, 8, 22, 10).getTime());
        theResp = new EPPMaintenanceInfoResp(theTransId, theMaintenance);
        theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testInfoResponseId");
    }

    public void testPollResponse() {
        EPPCodecTst.printStart("testPollResponse");
        EPPTransId theTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPMaintenanceItem theMaintenance = new EPPMaintenanceItem();
        theMaintenance.setMaintenanceId(new EPPMaintenanceId("2e6df9b0-4092-4491-bcc8-9fb2166dcee6"));
        theMaintenance.setPollType(EPPMaintenanceItem.PollType.create);
        theMaintenance.addSystem(new EPPMaintenanceSystem("EPP", "epp.registry.example", EPPMaintenanceSystem.Impact.full));
        theMaintenance.setEnvironment(EPPMaintenanceItem.Environment.production);
        theMaintenance.setStartDate(new GregorianCalendar(2021, 9, 30, 6, 0).getTime());
        theMaintenance.setEndDate(new GregorianCalendar(2021, 9, 30, 14, 25, 57).getTime());
        theMaintenance.setReason(EPPMaintenanceItem.Reason.planned);
        theMaintenance.setDetail("https://www.registry.example/notice?123");
        theMaintenance.addDescription(new EPPMaintenanceDescription("free text", EPPMaintenanceDescription.Type.plain, "en"));
        theMaintenance.addDescription(new EPPMaintenanceDescription("Freitext", EPPMaintenanceDescription.Type.plain, "de"));
        theMaintenance.addTld("example");
        theMaintenance.addTld("test");
        theMaintenance.setIntervention(new EPPMaintenanceIntervention(false, false));
        theMaintenance.setCreatedDate(new GregorianCalendar(2021, 3, 8, 22, 10).getTime());
        EPPMaintenanceInfoResp theResp = new EPPMaintenanceInfoResp(theTransId, theMaintenance);
        theResp.setMsgQueue(new EPPMsgQueue((Long)1L, "12345", new GregorianCalendar(2021, 2, 8, 22, 10).getTime(), "Registry Maintenance Notification"));
        theResp.setResult(1301);
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testPollResponse");
    }

    public void testInfoResponseList() {
        EPPCodecTst.printStart("testInfoResponseList");
        EPPTransId theTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPMaintenanceInfoResp theResp = new EPPMaintenanceInfoResp(theTransId);
        EPPMaintenanceListItem theItem = new EPPMaintenanceListItem(new EPPMaintenanceId("2e6df9b0-4092-4491-bcc8-9fb2166dcee6"), new GregorianCalendar(2021, 2, 8, 22, 10).getTime(), new GregorianCalendar(2021, 4, 30, 6, 0).getTime(), new GregorianCalendar(2021, 4, 30, 7, 0).getTime(), null);
        theResp.addListItem(theItem);
        theItem = new EPPMaintenanceListItem(new EPPMaintenanceId("91e9dabf-c4e9-4c19-a56c-78e3e89c2e2f"), new GregorianCalendar(2021, 6, 15, 4, 30).getTime(), new GregorianCalendar(2021, 6, 15, 5, 30).getTime(), new GregorianCalendar(2021, 2, 8, 22, 10).getTime(), new GregorianCalendar(2021, 3, 8, 20, 11).getTime());
        theResp.addListItem(theItem);
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testInfoResponseList");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPMaintenanceTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceMapFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding factories to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPMaintenanceTst Thread " + i, EPPMaintenanceTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPMaintenanceTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

