/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.maintenance.v1_0;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPMaintenanceSystem
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPMaintenanceSystem.class);
    public static final String ELM_LOCALNAME = "system";
    public static final String ELM_NAME = "maint:system";
    private static final String ELM_SYSTEM_NAME = "name";
    private static final String ELM_HOST = "host";
    private static final String ELM_IMPACT = "impact";
    private String name;
    private String host;
    private Impact impact = Impact.none;

    public EPPMaintenanceSystem() {
    }

    public EPPMaintenanceSystem(String aName, String aHost, Impact aImpact) {
        this.name = aName;
        this.host = aHost;
        this.impact = aImpact;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String aHost) {
        this.host = aHost;
    }

    public Impact getImpact() {
        return this.impact;
    }

    public void setImpact(Impact impact) {
        this.impact = impact;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.name == null || this.impact == null) {
            throw new EPPEncodeException("required attribute is not set");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:epp:maintenance-1.0", "maint:name");
        EPPUtil.encodeString(aDocument, root, this.host, "urn:ietf:params:xml:ns:epp:maintenance-1.0", "maint:host");
        EPPUtil.encodeString(aDocument, root, this.impact.toString(), "urn:ietf:params:xml:ns:epp:maintenance-1.0", "maint:impact");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_SYSTEM_NAME);
        this.host = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_HOST);
        this.impact = Impact.valueOf(EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_IMPACT));
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPMaintenanceSystem)) {
            return false;
        }
        EPPMaintenanceSystem other = (EPPMaintenanceSystem)aObject;
        if (!EqualityUtil.equals(this.name, other.name)) {
            cat.error("EPPMaintenanceSystem.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.host, other.host)) {
            cat.error("EPPMaintenanceSystem.equals(): host not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.impact, (Object)other.impact)) {
            cat.error("EPPMaintenanceSystem.equals(): impact not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPMaintenanceSystem clone = null;
        clone = (EPPMaintenanceSystem)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:maintenance-1.0";
    }

    public static enum Impact {
        full,
        partial,
        none;

    }
}

