/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.launchpolicy.v01;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyPhase;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPLaunchPolicyInfoPhase
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPLaunchPolicyInfoPhase.class);
    public static final String ELM_LOCALNAME = "infoPhase";
    public static final String ELM_NAME = "lp:infoPhase";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_NAME = "name";
    private EPPLaunchPolicyPhase.Phase phase;
    private String name;

    public EPPLaunchPolicyInfoPhase() {
    }

    public EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase aPhase) {
        this.phase = aPhase;
    }

    public EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase aPhase, String aName) {
        this.phase = aPhase;
        this.name = aName;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.phase == null) {
            throw new EPPEncodeException("Undefined phase in EPPLaunchPolicyInfoPhase");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:launchPolicy-0.1", ELM_NAME);
        root.setAttribute(ATTR_TYPE, this.phase.toString());
        if (this.hasName()) {
            root.setAttribute(ATTR_NAME, this.name);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.phase = EPPLaunchPolicyPhase.Phase.valueOf(EPPUtil.decodeStringAttr(aElement, ATTR_TYPE));
        this.name = EPPUtil.decodeStringAttr(aElement, ATTR_NAME);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPLaunchPolicyInfoPhase clone = (EPPLaunchPolicyInfoPhase)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLaunchPolicyInfoPhase)) {
            return false;
        }
        EPPLaunchPolicyInfoPhase other = (EPPLaunchPolicyInfoPhase)aObject;
        if (!EqualityUtil.equals((Object)this.phase, (Object)other.phase)) {
            cat.error("EPPLaunchPolicyInfoPhase.equals(): phase not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.name, other.name)) {
            cat.error("EPPLaunchPolicyInfoPhase.equals(): name not equal");
            return false;
        }
        return true;
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public EPPLaunchPolicyPhase.Phase getPhase() {
        return this.phase;
    }

    public void setPhase(EPPLaunchPolicyPhase.Phase aPhase) {
        this.phase = aPhase;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:launchPolicy-0.1";
    }
}

