/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.launch;

import com.verisign.epp.codec.domain.EPPDomainAddRemove;
import com.verisign.epp.codec.domain.EPPDomainCheckCmd;
import com.verisign.epp.codec.domain.EPPDomainContact;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainDeleteCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.launch.EPPLaunchCheck;
import com.verisign.epp.codec.launch.EPPLaunchCheckResult;
import com.verisign.epp.codec.launch.EPPLaunchChkData;
import com.verisign.epp.codec.launch.EPPLaunchCodeMark;
import com.verisign.epp.codec.launch.EPPLaunchCreData;
import com.verisign.epp.codec.launch.EPPLaunchCreate;
import com.verisign.epp.codec.launch.EPPLaunchInfData;
import com.verisign.epp.codec.launch.EPPLaunchInfo;
import com.verisign.epp.codec.launch.EPPLaunchNotice;
import com.verisign.epp.codec.launch.EPPLaunchPhase;
import com.verisign.epp.codec.launch.EPPLaunchStatus;
import com.verisign.epp.codec.launch.EPPLaunchUpdate;
import com.verisign.epp.codec.mark.EPPCourt;
import com.verisign.epp.codec.mark.EPPMark;
import com.verisign.epp.codec.mark.EPPMarkAddress;
import com.verisign.epp.codec.mark.EPPMarkContact;
import com.verisign.epp.codec.mark.EPPProtection;
import com.verisign.epp.codec.mark.EPPTrademark;
import com.verisign.epp.codec.mark.EPPTreatyOrStatute;
import com.verisign.epp.codec.signedMark.EPPEncodedSignedMark;
import com.verisign.epp.codec.signedMark.EPPIssuer;
import com.verisign.epp.codec.signedMark.EPPSignedMark;
import com.verisign.epp.codec.signedMark.SMDRevocationList;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.util.TestThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.codec.binary.Base64;

public class EPPLaunchTst
extends TestCase {
    private static long numIterations = 1L;
    private static PrivateKey privateKey;
    private static PublicKey publicKey;
    private static PKIXParameters pkixParameters;
    private static SMDRevocationList smdRevocationList;
    private static Certificate[] certChain;
    private static final String KEYSTORE_FILENAME = "signedMark.jks";
    private static final String KEYSTORE_REVOKED_FILENAME = "signedMarkRevoked.jks";
    private static final String KEYSTORE_PASSWORD = "changeit";
    private static final String KEYSTORE_KEY_ALIAS = "signedMark";
    private static final String KEYSTORE_CERT_ALIAS = "signedMarkCert";
    private static final String TRUSTSTORE_FILENAME = "signedMarkTrust.jks";
    private static String smdsDir;

    public EPPLaunchTst(String name) {
        super(name);
    }

    public void testSignedMark() {
        EPPCodecTst.printStart("testSignedMark");
        EPPMarkContact holder = new EPPMarkContact();
        holder.setEntitlement("owner");
        holder.setOrg("Example Inc.");
        holder.setEmail("holder@example.tld");
        EPPMarkAddress holderAddress = new EPPMarkAddress();
        holderAddress.addStreet("123 Example Dr.");
        holderAddress.addStreet("Suite 100");
        holderAddress.setCity("Reston");
        holderAddress.setSp("VA");
        holderAddress.setPc("20190");
        holderAddress.setCc("US");
        holder.setAddress(holderAddress);
        EPPMarkContact contact = new EPPMarkContact();
        contact.setType("owner");
        contact.setName("John Doe");
        contact.setOrg("Example Inc.");
        EPPMarkAddress contactAddress = new EPPMarkAddress();
        contactAddress.addStreet("123 Example Dr.");
        contactAddress.addStreet("Suite 100");
        contactAddress.setCity("Reston");
        contactAddress.setSp("VA");
        contactAddress.setPc("20166-6503");
        contactAddress.setCc("US");
        contact.setAddress(contactAddress);
        contact.setVoice("+1.7035555555");
        contact.setVoiceExt("1234");
        contact.setFax("+1.7035555556");
        contact.setEmail("jdoe@example.tld");
        EPPTrademark trademark = new EPPTrademark();
        trademark.setId("1234-2");
        trademark.setName("Example One");
        trademark.addHolder(holder);
        trademark.addContact(contact);
        trademark.setJurisdiction("US");
        trademark.addClass("35");
        trademark.addClass("36");
        trademark.addLabel("example-one");
        trademark.addLabel("exampleone");
        trademark.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
        trademark.setRegNum("234235");
        trademark.setRegDate(new GregorianCalendar(2009, 8, 16).getTime());
        trademark.setExDate(new GregorianCalendar(2015, 8, 16).getTime());
        EPPTreatyOrStatute treatyOrStatute = new EPPTreatyOrStatute();
        treatyOrStatute.setId("1234-2");
        treatyOrStatute.setName("Example One");
        treatyOrStatute.addHolder(holder);
        treatyOrStatute.addContact(contact);
        treatyOrStatute.addProtection(new EPPProtection("US", "Reston", "US"));
        treatyOrStatute.addLabel("example-one");
        treatyOrStatute.addLabel("exampleone");
        treatyOrStatute.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
        treatyOrStatute.setRefNum("234235");
        treatyOrStatute.setProDate(new GregorianCalendar(2009, 8, 16).getTime());
        treatyOrStatute.setTitle("Example Title");
        treatyOrStatute.setExecDate(new GregorianCalendar(2015, 8, 16).getTime());
        EPPCourt court = new EPPCourt();
        court.setId("1234-2");
        court.setName("Example One");
        court.addHolder(holder);
        court.addContact(contact);
        court.addLabel("example-one");
        court.addLabel("exampleone");
        court.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
        court.setRefNum("234235");
        court.setProDate(new GregorianCalendar(2009, 8, 16).getTime());
        court.setCc("US");
        court.addRegions("Reston");
        court.setCourtName("Test Court");
        EPPMark mark = new EPPMark();
        mark.addTrademark(trademark);
        mark.addTreatyOrStatute(treatyOrStatute);
        mark.addCourt(court);
        EPPIssuer issuer = new EPPIssuer("2", "Example Inc.", "support@example.tld");
        issuer.setUrl("http://www.example.tld");
        issuer.setVoice("+1.7035555555");
        issuer.setVoiceExt("1234");
        EPPSignedMark signedMark = null;
        try {
            signedMark = new EPPSignedMark("1-2", issuer, new GregorianCalendar(2009, 8, 16).getTime(), new GregorianCalendar(2010, 8, 16).getTime(), mark);
            signedMark.sign(privateKey);
        }
        catch (EPPException ex) {
            Assert.fail((String)("testSignedMark(): [1] Error signing the signed mark with private key: " + ex));
        }
        if (!signedMark.validate(publicKey)) {
            Assert.fail((String)"testSignedMark(): [1] Error validating the signed mark using public key");
        }
        System.out.println("testSignedMark(): [1] Success");
        try {
            signedMark = new EPPSignedMark("2-2", issuer, new GregorianCalendar(2009, 8, 16).getTime(), new GregorianCalendar(2010, 8, 16).getTime(), mark);
            signedMark.sign(privateKey, certChain);
        }
        catch (EPPException ex) {
            Assert.fail((String)("testSignedMark(): [2] Error signing the signed mark with private key and certificates: " + ex));
        }
        try {
            byte[] smdXml = signedMark.encode();
            byte[] smdBase64 = Base64.encodeBase64((byte[])smdXml, (boolean)true);
            FileOutputStream outStream = new FileOutputStream("vrsnSignedMark.smd");
            outStream.write("-----BEGIN ENCODED SMD-----\n".getBytes());
            outStream.write(smdBase64);
            outStream.write("-----END ENCODED SMD-----\n".getBytes());
            outStream.close();
        }
        catch (Exception ex) {
            Assert.fail((String)("testSignedMark(): [2] Error creating vrsnSignedMark.smd SMD file for signed mark: " + ex));
        }
        try {
            FileOutputStream outStream = new FileOutputStream("vrsnSignedMark.xml");
            outStream.write(signedMark.toString().getBytes());
            outStream.close();
        }
        catch (Exception ex) {
            Assert.fail((String)("testSignedMark(): [2] Error creating vrsnSignedMark.xml file for signed mark: " + ex));
        }
        if (!signedMark.validate(pkixParameters)) {
            Assert.fail((String)"testSignedMark(): [2] Error validating with CA certificate");
        }
        System.out.println("testSignedMark(): [2] Success");
        EPPSignedMark signedMark2 = null;
        byte[] signedMarkXml = new byte[]{};
        try {
            signedMarkXml = signedMark.encode();
            System.out.println("testSignedMark(): [3] Signed Mark XML 1 = [" + new String(signedMarkXml) + "]");
            signedMark2 = new EPPSignedMark(signedMarkXml);
        }
        catch (EPPException ex) {
            Assert.fail((String)("testSignedMark(): [3] Error encoding and decoding from XML: " + ex));
        }
        byte[] signedMarkXml2 = new byte[]{};
        try {
            signedMarkXml2 = signedMark2.encode();
            System.out.println("testSignedMark(): [3] Signed Mark XML 2 = [" + new String(signedMarkXml2) + "]");
            if (!signedMark2.validate(publicKey)) {
                Assert.fail((String)"testSignedMark(): [3] Signed mark validation using public key error with encode/decode");
            }
            if (!signedMark2.validate(pkixParameters)) {
                Assert.fail((String)"testSignedMark(): [3] Signed mark validation using PKIXParameters (trust store) error with encode/decode");
            }
        }
        catch (EPPException ex) {
            Assert.fail((String)("testSignedMark(): [3] Error validating the signed mark after encode / decode of XML: " + ex));
        }
        System.out.println("testSignedMark(): [3] Success");
        EPPSignedMark signedMark3 = null;
        byte[] signedMarkXml3 = new byte[]{};
        try {
            signedMark3 = new EPPSignedMark(signedMarkXml);
        }
        catch (EPPException e) {
            Assert.fail((String)("testSignedMark(): [3.1] Error creating decoding signed mark: " + e));
        }
        if (!signedMark3.validate(publicKey)) {
            Assert.fail((String)"testSignedMark(): [3.1] Signed mark validation using public key error with encode/decode");
        }
        if (!signedMark2.validate(pkixParameters)) {
            Assert.fail((String)"testSignedMark(): [3.1] Signed mark validation using PKIXParameters (trust store) error with encode/decode");
        }
        EPPEncodedSignedMark encodedSignedMark = null;
        try {
            encodedSignedMark = new EPPEncodedSignedMark(signedMark);
            System.out.println("testSignedMark(): [4] Signed Encoded Mark XML 1 = [" + new String(signedMarkXml) + "]");
            signedMark2 = new EPPSignedMark(signedMarkXml);
        }
        catch (EPPException ex) {
            Assert.fail((String)("testSignedMark(): [4] Error encoding and decoding from XML: " + ex));
        }
        try {
            signedMarkXml2 = signedMark2.encode();
            System.out.println("testSignedMark(): [4] Signed Encoded Mark XML 2 = [" + new String(signedMarkXml2) + "]");
            if (!signedMark2.validate(publicKey)) {
                Assert.fail((String)"testSignedMark(): [4] Encoded signed mark validation using public key error with encode/decode");
            }
            if (!signedMark2.validate(pkixParameters)) {
                Assert.fail((String)"testSignedMark(): [4] Signed mark validation using PKIXParameters (trust store) error with encode/decode");
            }
        }
        catch (EPPException ex) {
            Assert.fail((String)("testSignedMark(): [4] Error validating the signed mark after encode / decode of XML: " + ex));
        }
        System.out.println("testSignedMark(): [4] Success");
        PrivateKey revokedPrivateKey = null;
        Certificate[] revokedCertChain = null;
        try {
            KeyStore.PrivateKeyEntry keyEntry = EPPLaunchTst.loadPrivateKeyEntry(KEYSTORE_REVOKED_FILENAME, KEYSTORE_KEY_ALIAS, KEYSTORE_PASSWORD);
            revokedPrivateKey = keyEntry.getPrivateKey();
            revokedCertChain = keyEntry.getCertificateChain();
        }
        catch (Exception ex) {
            Assert.fail((String)("testSignedMark(): [5] Error loading removed private key and certificate chain: " + ex));
        }
        try {
            signedMark = new EPPSignedMark("5-2", issuer, new GregorianCalendar(2012, 8, 16).getTime(), new GregorianCalendar(2013, 8, 16).getTime(), mark);
            signedMark.sign(revokedPrivateKey);
        }
        catch (EPPException ex) {
            Assert.fail((String)("testSignedMark(): [5] Error signing the signed mark with private key: " + ex));
        }
        if (signedMark.validate(pkixParameters)) {
            Assert.fail((String)"testSignedMark(): [5] Validating signature with revoked certificate should have failed");
        }
        System.out.println("testSignedMark(): [5] Success");
        EPPCodecTst.printEnd("testSignedMark");
    }

    public void testTrademarkHolderEnglishActive() {
        EPPCodecTst.printStart("testTrademarkHolderEnglishActive");
        EPPMarkContact holder = new EPPMarkContact();
        holder.setEntitlement("owner");
        holder.setName("Frank White");
        holder.setOrg("Test Organization");
        holder.setEmail("info@example.example");
        holder.setVoice("+1.3014556600");
        holder.setVoice("+1.3014556601");
        EPPMarkAddress holderAddress = new EPPMarkAddress();
        holderAddress.addStreet("101 West Arques Avenue");
        holderAddress.setCity("Sunnyvale");
        holderAddress.setSp("CA");
        holderAddress.setPc("10023-3241");
        holderAddress.setCc("US");
        holder.setAddress(holderAddress);
        EPPTrademark trademark = new EPPTrademark();
        trademark.setId("00051913734666981373466698-1");
        trademark.setName("Test & Validate");
        trademark.addHolder(holder);
        trademark.setJurisdiction("US");
        trademark.addClass("15");
        trademark.addLabel("test---validate");
        trademark.addLabel("test--validate");
        trademark.addLabel("test-et-validate");
        trademark.addLabel("test-etvalidate");
        trademark.addLabel("test-validate");
        trademark.addLabel("testand-validate");
        trademark.addLabel("testandvalidate");
        trademark.addLabel("testet-validate");
        trademark.addLabel("testetvalidate");
        trademark.addLabel("testvalidate");
        trademark.setGoodsAndServices("guitar");
        trademark.setRegNum("1234");
        trademark.setRegDate(EPPUtil.decodeTimeInstant("2012-12-31T23:00:00.000Z"));
        trademark.setExDate(EPPUtil.decodeTimeInstant("2014-12-31T23:00:00.000Z"));
        EPPMark mark = new EPPMark();
        mark.addTrademark(trademark);
        EPPIssuer issuer = new EPPIssuer("65535", "ICANN TMCH TESTING TMV", "notavailable@example.com");
        issuer.setUrl("http://www.example.tld");
        issuer.setVoice("+32.000000");
        EPPSignedMark signedMark = null;
        try {
            signedMark = new EPPSignedMark("0000001701373633628125-65535", issuer, EPPUtil.decodeTimeInstant("2013-07-12T12:53:48.125Z"), EPPUtil.decodeTimeInstant("2017-07-09T22:00:00.000Z"), mark);
            signedMark.sign(privateKey, certChain);
        }
        catch (EPPException ex) {
            Assert.fail((String)("testTrademarkHolderEnglishActive(): Error signing the signed mark with private key and certificates: " + ex));
        }
        if (!signedMark.validate(pkixParameters)) {
            Assert.fail((String)"testTrademarkHolderEnglishActive(): Error validating with CA certificate");
        }
        byte[] smdXml = null;
        try {
            smdXml = signedMark.encode();
            byte[] smdBase64 = Base64.encodeBase64((byte[])smdXml, (boolean)true);
            FileOutputStream outStream = new FileOutputStream("VRSN-Trademark-Holder-English-Active.smd");
            outStream.write("-----BEGIN ENCODED SMD-----\n".getBytes());
            outStream.write(smdBase64);
            outStream.write("-----END ENCODED SMD-----\n".getBytes());
            outStream.close();
        }
        catch (Exception ex) {
            Assert.fail((String)("testTrademarkHolderEnglishActive(): Error creating Trademark-Holder-English-Active.smd SMD file for signed mark: " + ex));
        }
        try {
            FileOutputStream outStream = new FileOutputStream("VRSN-Trademark-Holder-English-Active.xml");
            outStream.write(signedMark.toString().getBytes());
            outStream.close();
        }
        catch (Exception ex) {
            Assert.fail((String)("testTrademarkHolderEnglishActive(): Error creating Trademark-Holder-English-Active.smd file for signed mark: " + ex));
        }
        EPPSignedMark signedMark2 = null;
        try {
            signedMark2 = new EPPSignedMark(signedMark.encode());
        }
        catch (EPPException ex) {
            Assert.fail((String)("testTrademarkHolderEnglishActive(): Error creating signed mark 2 from signed mark: " + ex));
        }
        if (!signedMark2.validate(pkixParameters)) {
            Assert.fail((String)"testTrademarkHolderEnglishActive(): Error validating signed mark 2");
        }
        System.out.println("testTrademarkHolderEnglishActive(): Success");
        EPPCodecTst.printEnd("testTrademarkHolderEnglishActive");
    }

    public void testLaunchInfo() {
        EPPCodecTst.printStart("testLaunchInfo");
        EPPDomainInfoCmd theCommand = new EPPDomainInfoCmd("ABC-12345", "example.tld");
        theCommand.addExtension(new EPPLaunchInfo(new EPPLaunchPhase("sunrise"), "abc123"));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainInfoCmd("ABC-12345", "example.tld");
        theCommand.addExtension(new EPPLaunchInfo(new EPPLaunchPhase("sunrise")));
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        theCommand = new EPPDomainInfoCmd("ABC-12345", "example.tld");
        EPPLaunchInfo theExt = new EPPLaunchInfo(new EPPLaunchPhase("sunrise"));
        theExt.setIncludeMark(true);
        theCommand.addExtension(theExt);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        EPPCodecTst.printEnd("testLaunchInfo");
    }

    public void testLaunchInfData() {
        EPPCodecTst.printStart("testLaunchInfData");
        EPPDomainInfoResp theResponse = new EPPDomainInfoResp();
        theResponse.setName("example.tld");
        theResponse.setTransId(new EPPTransId("ABC-12345", "54322-XYZ"));
        theResponse.setRoid("EXAMPLE1-REP");
        theResponse.setCreatedDate(new Date());
        theResponse.setCreatedBy("ClientY");
        theResponse.setClientId("ClientX");
        EPPLaunchInfData launchInfData = new EPPLaunchInfData(new EPPLaunchPhase("sunrise"), "abc123", new EPPLaunchStatus("pendingValidation"));
        EPPMarkContact holder = new EPPMarkContact();
        holder.setEntitlement("owner");
        holder.setOrg("Example Inc.");
        holder.setEmail("holder@example.tld");
        EPPMarkAddress holderAddress = new EPPMarkAddress();
        holderAddress.addStreet("123 Example Dr.");
        holderAddress.addStreet("Suite 100");
        holderAddress.setCity("Reston");
        holderAddress.setSp("VA");
        holderAddress.setPc("20190");
        holderAddress.setCc("US");
        holder.setAddress(holderAddress);
        EPPMarkContact contact = new EPPMarkContact();
        contact.setType("owner");
        contact.setName("John Doe");
        contact.setOrg("Example Inc.");
        EPPMarkAddress contactAddress = new EPPMarkAddress();
        contactAddress.addStreet("123 Example Dr.");
        contactAddress.addStreet("Suite 100");
        contactAddress.setCity("Reston");
        contactAddress.setSp("VA");
        contactAddress.setPc("20166-6503");
        contactAddress.setCc("US");
        contact.setAddress(contactAddress);
        contact.setVoice("+1.7035555555");
        contact.setVoiceExt("1234");
        contact.setFax("+1.7035555556");
        contact.setEmail("jdoe@example.tld");
        EPPTrademark trademark = new EPPTrademark();
        trademark.setId("1234-2");
        trademark.setName("Example One");
        trademark.addHolder(holder);
        trademark.addContact(contact);
        trademark.setJurisdiction("US");
        trademark.addClass("35");
        trademark.addClass("36");
        trademark.addLabel("example-one");
        trademark.addLabel("exampleone");
        trademark.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
        trademark.setRegNum("234235");
        trademark.setRegDate(new GregorianCalendar(2009, 8, 16).getTime());
        trademark.setExDate(new GregorianCalendar(2015, 8, 16).getTime());
        EPPTreatyOrStatute treatyOrStatute = new EPPTreatyOrStatute();
        treatyOrStatute.setId("1234-2");
        treatyOrStatute.setName("Example One");
        treatyOrStatute.addHolder(holder);
        treatyOrStatute.addContact(contact);
        treatyOrStatute.addProtection(new EPPProtection("US", "Reston", "US"));
        treatyOrStatute.addLabel("example-one");
        treatyOrStatute.addLabel("exampleone");
        treatyOrStatute.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
        treatyOrStatute.setRefNum("234235");
        treatyOrStatute.setProDate(new GregorianCalendar(2009, 8, 16).getTime());
        treatyOrStatute.setTitle("Example Title");
        treatyOrStatute.setExecDate(new GregorianCalendar(2015, 8, 16).getTime());
        EPPCourt court = new EPPCourt();
        court.setId("1234-2");
        court.setName("Example One");
        court.addHolder(holder);
        court.addContact(contact);
        court.addLabel("example-one");
        court.addLabel("exampleone");
        court.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
        court.setRefNum("234235");
        court.setProDate(new GregorianCalendar(2009, 8, 16).getTime());
        court.setCc("US");
        court.addRegions("Reston");
        court.setCourtName("Test Court");
        EPPMark mark = new EPPMark();
        mark.addTrademark(trademark);
        mark.addTreatyOrStatute(treatyOrStatute);
        mark.addCourt(court);
        launchInfData.addMark(mark);
        theResponse.addExtension(launchInfData);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(commandStats);
        theResponse = new EPPDomainInfoResp();
        theResponse.setName("example.tld");
        theResponse.setTransId(new EPPTransId("ABC-12345", "54322-XYZ"));
        theResponse.setRoid("EXAMPLE1-REP");
        theResponse.setCreatedDate(new Date());
        theResponse.setCreatedBy("ClientY");
        theResponse.setClientId("ClientX");
        launchInfData = new EPPLaunchInfData(new EPPLaunchPhase("sunrise"), null, null, mark);
        theResponse.addExtension(launchInfData);
        commandStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testLaunchInfData");
    }

    public void testLaunchUpdate() {
        EPPCodecTst.printStart("testLaunchUpdate");
        Vector<String> addServers = new Vector<String>();
        addServers.addElement("ns2.example.com");
        Vector<String> removeServers = new Vector<String>();
        removeServers.addElement("ns1.example.com");
        EPPDomainAddRemove addItems = new EPPDomainAddRemove(addServers, null, null);
        EPPDomainAddRemove removeItems = new EPPDomainAddRemove(removeServers, null, null);
        EPPDomainUpdateCmd theCommand = new EPPDomainUpdateCmd("ABC-12345", "example.tkd", addItems, removeItems, null);
        theCommand.addExtension(new EPPLaunchUpdate(new EPPLaunchPhase("sunrise"), "abc123"));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testLaunchUpdate");
    }

    public void testLaunchDelete() {
        EPPCodecTst.printStart("testLaunchDelete");
        EPPDomainDeleteCmd theCommand = new EPPDomainDeleteCmd("ABC-12345", "example.tld");
        theCommand.addExtension(new EPPLaunchUpdate(new EPPLaunchPhase("sunrise"), "abc123"));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testLaunchDelete");
    }

    public void testLaunchClaimsCheckForm() {
        EPPCodecTst.printStart("testLaunchClaimsCheckForm");
        Vector<String> domains = new Vector<String>();
        domains.addElement("example1.tld");
        domains.addElement("example2.tld");
        EPPDomainCheckCmd theCommand = new EPPDomainCheckCmd("ABC-12345", domains);
        theCommand.addExtension(new EPPLaunchCheck(new EPPLaunchPhase("claims"), "claims"));
        EPPEncodeDecodeStats stats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(stats);
        theCommand = new EPPDomainCheckCmd("ABC-12345", domains);
        theCommand.addExtension(new EPPLaunchCheck(new EPPLaunchPhase("open"), "claims"));
        stats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(stats);
        EPPTransId respTransId = new EPPTransId("ABC-12345", "54322-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        EPPLaunchChkData theExt = new EPPLaunchChkData(new EPPLaunchPhase("claims"));
        theExt.addCheckResult(new EPPLaunchCheckResult("example1.tld", false));
        theExt.addCheckResult(new EPPLaunchCheckResult("example2.tld", true, "2013041500/2/6/9/rJ1NrDO92vDsAzf7EQzgjX4R0000000001"));
        EPPLaunchCheckResult launchCheckResult = new EPPLaunchCheckResult("example3.tld", true);
        launchCheckResult.addClaimKey("2013041500/2/6/9/rJ1NrDO92vDsAzf7EQzgjX4R0000000001", "tmch");
        launchCheckResult.addClaimKey("20140423200/1/2/3/rJ1Nr2vDsAzasdff7EasdfgjX4R000000002", "custom-tmch");
        theExt.addCheckResult(launchCheckResult);
        theResponse.addExtension(theExt);
        stats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(stats);
        EPPCodecTst.printEnd("testLaunchClaimsCheckForm");
    }

    public void testLaunchAvailabilityCheckForm() {
        EPPCodecTst.printStart("testLaunchAvailabilityCheckForm");
        Vector<String> domains = new Vector<String>();
        domains.addElement("example1.tld");
        domains.addElement("example2.tld");
        EPPDomainCheckCmd theCommand = new EPPDomainCheckCmd("ABC-12345", domains);
        theCommand.addExtension(new EPPLaunchCheck(new EPPLaunchPhase("custom", "idn-release"), "avail"));
        EPPEncodeDecodeStats stats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(stats);
        EPPCodecTst.printEnd("testLaunchAvailabilityCheckForm");
    }

    public void testLaunchTrademarkCheckForm() {
        EPPCodecTst.printStart("testLaunchTrademarkCheckForm");
        Vector<String> domains = new Vector<String>();
        domains.addElement("example1.tld");
        domains.addElement("example2.tld");
        EPPDomainCheckCmd theCommand = new EPPDomainCheckCmd("ABC-12345", domains);
        theCommand.addExtension(new EPPLaunchCheck("trademark"));
        EPPEncodeDecodeStats stats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(stats);
        EPPTransId respTransId = new EPPTransId("ABC-12345", "54322-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        EPPLaunchChkData theExt = new EPPLaunchChkData();
        theExt.addCheckResult(new EPPLaunchCheckResult("example1.tld", false));
        theExt.addCheckResult(new EPPLaunchCheckResult("example2.tld", true, "2013041500/2/6/9/rJ1NrDO92vDsAzf7EQzgjX4R0000000001"));
        EPPLaunchCheckResult launchCheckResult = new EPPLaunchCheckResult("example3.tld", true);
        launchCheckResult.addClaimKey("2013041500/2/6/9/rJ1NrDO92vDsAzf7EQzgjX4R0000000001", "tmch");
        launchCheckResult.addClaimKey("20140423200/1/2/3/rJ1Nr2vDsAzasdff7EasdfgjX4R000000002", "custom-tmch");
        theExt.addCheckResult(launchCheckResult);
        theResponse.addExtension(theExt);
        stats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(stats);
        EPPCodecTst.printEnd("testLaunchTrademarkCheckForm");
    }

    public void testLaunchCreateCodeMark() {
        EPPCodecTst.printStart("testLaunchCreateCodeMark");
        EPPDomainCreateCmd theCommand = new EPPDomainCreateCmd("ABC-12345", "example.tld", new EPPAuthInfo("2fooBAR"));
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            theCommand.setRegistrant("jd1234");
            Vector<EPPDomainContact> contacts = new Vector<EPPDomainContact>();
            contacts.addElement(new EPPDomainContact("sh8013", "admin"));
            contacts.addElement(new EPPDomainContact("sh8013", "tech"));
            theCommand.setContacts(contacts);
        }
        theCommand.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("sunrise"), new EPPLaunchCodeMark("49FD46E6C4B45C55D4AC"), "registration"));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPLaunchCreate createExt = new EPPLaunchCreate(new EPPLaunchPhase("sunrise"));
        createExt.addCodeMark(new EPPLaunchCodeMark("49FD46E6C4B45C55D4AC", "sample1"));
        createExt.addCodeMark(new EPPLaunchCodeMark("49FD46E6C4B45C55D4AD"));
        createExt.addCodeMark(new EPPLaunchCodeMark("49FD46E6C4B45C55D4AE", "sample2"));
        theCommand.setExtensions(null);
        theCommand.addExtension(createExt);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPMarkContact holder = new EPPMarkContact();
        holder.setEntitlement("owner");
        holder.setOrg("Example Inc.");
        holder.setEmail("holder@example.tld");
        EPPMarkAddress holderAddress = new EPPMarkAddress();
        holderAddress.addStreet("123 Example Dr.");
        holderAddress.addStreet("Suite 100");
        holderAddress.setCity("Reston");
        holderAddress.setSp("VA");
        holderAddress.setPc("20190");
        holderAddress.setCc("US");
        holder.setAddress(holderAddress);
        EPPMarkContact contact = new EPPMarkContact();
        contact.setType("owner");
        contact.setName("John Doe");
        contact.setOrg("Example Inc.");
        EPPMarkAddress contactAddress = new EPPMarkAddress();
        contactAddress.addStreet("123 Example Dr.");
        contactAddress.addStreet("Suite 100");
        contactAddress.setCity("Reston");
        contactAddress.setSp("VA");
        contactAddress.setPc("20166-6503");
        contactAddress.setCc("US");
        contact.setAddress(contactAddress);
        contact.setVoice("+1.7035555555");
        contact.setVoiceExt("1234");
        contact.setFax("+1.7035555556");
        contact.setEmail("jdoe@example.tld");
        EPPTrademark trademark = new EPPTrademark();
        trademark.setId("1234-2");
        trademark.setName("Example One");
        trademark.addHolder(holder);
        trademark.addContact(contact);
        trademark.setJurisdiction("US");
        trademark.addClass("35");
        trademark.addClass("36");
        trademark.addLabel("example-one");
        trademark.addLabel("exampleone");
        trademark.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
        trademark.setRegNum("234235");
        trademark.setRegDate(new GregorianCalendar(2009, 8, 16).getTime());
        trademark.setExDate(new GregorianCalendar(2015, 8, 16).getTime());
        EPPTreatyOrStatute treatyOrStatute = new EPPTreatyOrStatute();
        treatyOrStatute.setId("1234-2");
        treatyOrStatute.setName("Example One");
        treatyOrStatute.addHolder(holder);
        treatyOrStatute.addContact(contact);
        treatyOrStatute.addProtection(new EPPProtection("US", "Reston", "US"));
        treatyOrStatute.addLabel("example-one");
        treatyOrStatute.addLabel("exampleone");
        treatyOrStatute.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
        treatyOrStatute.setRefNum("234235");
        treatyOrStatute.setProDate(new GregorianCalendar(2009, 8, 16).getTime());
        treatyOrStatute.setTitle("Example Title");
        treatyOrStatute.setExecDate(new GregorianCalendar(2015, 8, 16).getTime());
        EPPCourt court = new EPPCourt();
        court.setId("1234-2");
        court.setName("Example One");
        court.addHolder(holder);
        court.addContact(contact);
        court.addLabel("example-one");
        court.addLabel("exampleone");
        court.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
        court.setRefNum("234235");
        court.setProDate(new GregorianCalendar(2009, 8, 16).getTime());
        court.setCc("US");
        court.addRegions("Reston");
        court.setCourtName("Test Court");
        EPPMark mark = new EPPMark();
        mark.addTrademark(trademark);
        mark.addTreatyOrStatute(treatyOrStatute);
        mark.addCourt(court);
        theCommand.setExtensions(null);
        theCommand.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("sunrise"), new EPPLaunchCodeMark(mark), "application"));
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand.setExtensions(null);
        theCommand.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("sunrise"), new EPPLaunchCodeMark("49FD46E6C4B45C55D4AC", "sample", mark)));
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand.setExtensions(null);
        createExt = new EPPLaunchCreate(new EPPLaunchPhase("sunrise"));
        createExt.addCodeMark(new EPPLaunchCodeMark("49FD46E6C4B45C55D4AC", "sample1", mark));
        createExt.addCodeMark(new EPPLaunchCodeMark("49FD46E6C4B45C55D4AD", "sample2", mark));
        theCommand.setExtensions(null);
        theCommand.addExtension(createExt);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand.setExtensions(null);
        createExt = new EPPLaunchCreate(new EPPLaunchPhase("custom", "non-tmch-sunrise"), "application");
        createExt.addCodeMark(new EPPLaunchCodeMark(mark));
        createExt.setNotice(new EPPLaunchNotice("49FD46E6C4B45C55D4AC", new Date(), new Date()));
        theCommand.setExtensions(null);
        theCommand.addExtension(createExt);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand.setExtensions(null);
        createExt = new EPPLaunchCreate(new EPPLaunchPhase("custom", "non-tmch-sunrise"), "application");
        createExt.addCodeMark(new EPPLaunchCodeMark(mark));
        createExt.setNotice(new EPPLaunchNotice("49FD46E6C4B45C55D4AC", new Date(), new Date(), "custom"));
        theCommand.setExtensions(null);
        theCommand.addExtension(createExt);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testLaunchCreateCodeMark");
    }

    public void testLaunchCreateGeneric() {
        EPPCodecTst.printStart("testLaunchCreateGeneric");
        EPPDomainCreateCmd theCommand = new EPPDomainCreateCmd("ABC-12345", "example.tld", new EPPAuthInfo("2fooBAR"));
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            theCommand.setRegistrant("jd1234");
            Vector<EPPDomainContact> contacts = new Vector<EPPDomainContact>();
            contacts.addElement(new EPPDomainContact("sh8013", "admin"));
            contacts.addElement(new EPPDomainContact("sh8013", "tech"));
            theCommand.setContacts(contacts);
        }
        theCommand.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("landrush")));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand.setExtensions(null);
        theCommand.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("landrush"), "application"));
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand.setExtensions(null);
        theCommand.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("landrush"), "registration"));
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testLaunchCreateGeneric");
    }

    public void testLaunchCreateSignedMark() {
        EPPCodecTst.printStart("testLaunchCreateSignedMark");
        EPPDomainCreateCmd theCommand = new EPPDomainCreateCmd("ABC-12345", "example.tld", new EPPAuthInfo("2fooBAR"));
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            theCommand.setRegistrant("jd1234");
            Vector<EPPDomainContact> contacts = new Vector<EPPDomainContact>();
            contacts.addElement(new EPPDomainContact("sh8013", "admin"));
            contacts.addElement(new EPPDomainContact("sh8013", "tech"));
            theCommand.setContacts(contacts);
        }
        EPPMarkContact holder = new EPPMarkContact();
        holder.setEntitlement("owner");
        holder.setOrg("Example Inc.");
        holder.setEmail("holder@example.tld");
        EPPMarkAddress holderAddress = new EPPMarkAddress();
        holderAddress.addStreet("123 Example Dr.");
        holderAddress.addStreet("Suite 100");
        holderAddress.setCity("Reston");
        holderAddress.setSp("VA");
        holderAddress.setPc("20190");
        holderAddress.setCc("US");
        holder.setAddress(holderAddress);
        EPPMarkContact contact = new EPPMarkContact();
        contact.setType("owner");
        contact.setName("John Doe");
        contact.setOrg("Example Inc.");
        EPPMarkAddress contactAddress = new EPPMarkAddress();
        contactAddress.addStreet("123 Example Dr.");
        contactAddress.addStreet("Suite 100");
        contactAddress.setCity("Reston");
        contactAddress.setSp("VA");
        contactAddress.setPc("20166-6503");
        contactAddress.setCc("US");
        contact.setAddress(contactAddress);
        contact.setVoice("+1.7035555555");
        contact.setVoiceExt("1234");
        contact.setFax("+1.7035555556");
        contact.setEmail("jdoe@example.tld");
        EPPTrademark trademark = new EPPTrademark();
        trademark.setId("1234-2");
        trademark.setName("Example One");
        trademark.addHolder(holder);
        trademark.addContact(contact);
        trademark.setJurisdiction("US");
        trademark.addClass("35");
        trademark.addClass("36");
        trademark.addLabel("example-one");
        trademark.addLabel("exampleone");
        trademark.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
        trademark.setRegNum("234235");
        trademark.setRegDate(new GregorianCalendar(2009, 8, 16).getTime());
        trademark.setExDate(new GregorianCalendar(2015, 8, 16).getTime());
        EPPTreatyOrStatute treatyOrStatute = new EPPTreatyOrStatute();
        treatyOrStatute.setId("1234-2");
        treatyOrStatute.setName("Example One");
        treatyOrStatute.addHolder(holder);
        treatyOrStatute.addContact(contact);
        treatyOrStatute.addProtection(new EPPProtection("US", "Reston", "US"));
        treatyOrStatute.addLabel("example-one");
        treatyOrStatute.addLabel("exampleone");
        treatyOrStatute.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
        treatyOrStatute.setRefNum("234235");
        treatyOrStatute.setProDate(new GregorianCalendar(2009, 8, 16).getTime());
        treatyOrStatute.setTitle("Example Title");
        treatyOrStatute.setExecDate(new GregorianCalendar(2015, 8, 16).getTime());
        EPPCourt court = new EPPCourt();
        court.setId("1234-2");
        court.setName("Example One");
        court.addHolder(holder);
        court.addContact(contact);
        court.addLabel("example-one");
        court.addLabel("exampleone");
        court.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
        court.setRefNum("234235");
        court.setProDate(new GregorianCalendar(2009, 8, 16).getTime());
        court.setCc("US");
        court.addRegions("Reston");
        court.setCourtName("Test Court");
        EPPMark mark = new EPPMark();
        mark.addTrademark(trademark);
        mark.addTreatyOrStatute(treatyOrStatute);
        mark.addCourt(court);
        EPPIssuer issuer = new EPPIssuer("2", "Example Inc.", "support@example.tld");
        issuer.setUrl("http://www.example.tld");
        issuer.setVoice("+1.7035555555");
        issuer.setVoiceExt("1234");
        EPPSignedMark signedMark = null;
        try {
            signedMark = new EPPSignedMark("1-123456", issuer, new GregorianCalendar(2012, 8, 16).getTime(), new GregorianCalendar(2013, 8, 16).getTime(), mark);
            signedMark.sign(privateKey, certChain);
        }
        catch (EPPException ex) {
            Assert.fail((String)("Error signing the signed mark: " + ex));
        }
        if (!signedMark.validate(publicKey)) {
            Assert.fail((String)"Signed mark validation error without encode/decode");
        }
        theCommand.setExtensions(null);
        theCommand.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("sunrise"), signedMark));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        if (!signedMark.validate(pkixParameters)) {
            Assert.fail((String)"testLaunchCreateSignedMark(): XML signed mark signature is NOT valid after command encode/decode");
        }
        EPPEncodedSignedMark encodedSignedMark = null;
        try {
            encodedSignedMark = new EPPEncodedSignedMark(signedMark);
        }
        catch (EPPEncodeException e1) {
            Assert.fail((String)"testLaunchCreateSignedMark(): Error creating EPPEncodedSignedMark from signed mark");
        }
        catch (EPPDecodeException e) {
            Assert.fail((String)"testLaunchCreateSignedMark(): Error creating EPPEncodedSignedMark from signed mark");
        }
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        if (!signedMark.validate(pkixParameters)) {
            Assert.fail((String)"testLaunchCreateSignedMark(): encoded signed mark signature is NOT valid after command encode/decode");
        }
        EPPCodecTst.printEnd("testLaunchCreateSignedMark");
    }

    public void testLaunchCreateNotice() {
        EPPCodecTst.printStart("testLaunchCreateNotice");
        EPPDomainCreateCmd theCommand = new EPPDomainCreateCmd("ABC-12345", "example.tld", new EPPAuthInfo("2fooBAR"));
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            theCommand.setRegistrant("jd1234");
            Vector<EPPDomainContact> contacts = new Vector<EPPDomainContact>();
            contacts.addElement(new EPPDomainContact("sh8013", "admin"));
            contacts.addElement(new EPPDomainContact("sh8013", "tech"));
            theCommand.setContacts(contacts);
        }
        theCommand.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("claims"), new EPPLaunchNotice("49FD46E6C4B45C55D4AC", new Date(), new Date()), "application"));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand.setExtensions(null);
        EPPLaunchCreate launchCreate = new EPPLaunchCreate(new EPPLaunchPhase("claims"));
        launchCreate.setType("registration");
        launchCreate.addNotice(new EPPLaunchNotice("370d0b7c9223372036854775807", new Date(), new Date(), "tmch"));
        launchCreate.addNotice(new EPPLaunchNotice("470d0b7c9223654313275808", new Date(), new Date(), "custom-tmch"));
        theCommand.addExtension(launchCreate);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testLaunchCreateNotice");
    }

    public void testLaunchCreData() {
        EPPCodecTst.printStart("testLaunchCreData");
        EPPTransId respTransId = new EPPTransId("example:epp:239332", "server-8551292e23b");
        EPPDomainCreateResp theResponse = new EPPDomainCreateResp(respTransId, "example.tld", new GregorianCalendar(2010, 8, 10).getTime(), new GregorianCalendar(2012, 8, 10).getTime());
        theResponse.setResult(1001);
        EPPLaunchCreData launchCreData = new EPPLaunchCreData(new EPPLaunchPhase("sunrise"), "2393-9323-E08C-03B1");
        theResponse.addExtension(launchCreData);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testLaunchCreData");
    }

    public void testMark() {
        EPPCodecTst.printStart("testMark");
        EPPMarkContact holder = new EPPMarkContact();
        holder.setEntitlement("owner");
        holder.setOrg("Example Inc.");
        holder.setEmail("holder@example.tld");
        EPPMarkAddress holderAddress = new EPPMarkAddress();
        holderAddress.addStreet("123 Example Dr.");
        holderAddress.addStreet("Suite 100");
        holderAddress.setCity("Reston");
        holderAddress.setSp("VA");
        holderAddress.setPc("20190");
        holderAddress.setCc("US");
        holder.setAddress(holderAddress);
        EPPMarkContact contact = new EPPMarkContact();
        contact.setType("owner");
        contact.setName("John Doe");
        contact.setOrg("Example Inc.");
        EPPMarkAddress contactAddress = new EPPMarkAddress();
        contactAddress.addStreet("123 Example Dr.");
        contactAddress.addStreet("Suite 100");
        contactAddress.setCity("Reston");
        contactAddress.setSp("VA");
        contactAddress.setPc("20166-6503");
        contactAddress.setCc("US");
        contact.setAddress(contactAddress);
        contact.setVoice("+1.7035555555");
        contact.setVoiceExt("1234");
        contact.setFax("+1.7035555556");
        contact.setEmail("jdoe@example.tld");
        EPPTrademark trademark = new EPPTrademark();
        trademark.setId("1234-2");
        trademark.setName("Example One");
        trademark.addHolder(holder);
        trademark.addContact(contact);
        trademark.setJurisdiction("US");
        trademark.addClass("35");
        trademark.addClass("36");
        trademark.addLabel("example-one");
        trademark.addLabel("exampleone");
        trademark.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
        trademark.setRegNum("234235");
        trademark.setRegDate(new GregorianCalendar(2009, 8, 16).getTime());
        trademark.setExDate(new GregorianCalendar(2015, 8, 16).getTime());
        EPPTreatyOrStatute treatyOrStatute = new EPPTreatyOrStatute();
        treatyOrStatute.setId("1234-2");
        treatyOrStatute.setName("Example One");
        treatyOrStatute.addHolder(holder);
        treatyOrStatute.addContact(contact);
        treatyOrStatute.addProtection(new EPPProtection("US", "Reston", "US"));
        treatyOrStatute.addLabel("example-one");
        treatyOrStatute.addLabel("exampleone");
        treatyOrStatute.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
        treatyOrStatute.setRefNum("234235");
        treatyOrStatute.setProDate(new GregorianCalendar(2009, 8, 16).getTime());
        treatyOrStatute.setTitle("Example Title");
        treatyOrStatute.setExecDate(new GregorianCalendar(2015, 8, 16).getTime());
        EPPCourt court = new EPPCourt();
        court.setId("1234-2");
        court.setName("Example One");
        court.addHolder(holder);
        court.addContact(contact);
        court.addLabel("example-one");
        court.addLabel("exampleone");
        court.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
        court.setRefNum("234235");
        court.setProDate(new GregorianCalendar(2009, 8, 16).getTime());
        court.setCc("US");
        court.addRegions("Reston");
        court.setCourtName("Test Court");
        EPPMark mark = new EPPMark();
        mark.addTrademark(trademark);
        mark.addTreatyOrStatute(treatyOrStatute);
        mark.addCourt(court);
        EPPMark mark2 = new EPPMark();
        byte[] markXml = new byte[]{};
        try {
            markXml = mark.encode();
            System.out.println("Mark XML 1 = [" + new String(markXml) + "]");
            mark2.decode(markXml);
        }
        catch (EPPException ex) {
            Assert.fail((String)("Error encoding and decoding from XML: " + ex));
        }
        byte[] markXml2 = new byte[]{};
        try {
            markXml2 = mark2.encode();
            System.out.println("Mark XML 2 = [" + new String(markXml2) + "]");
            int compareVal = new String(markXml).compareTo(new String(markXml2));
            if (compareVal != 0) {
                Assert.fail((String)("The mark XML is not equal, with compare value = " + compareVal));
            }
        }
        catch (EPPException ex) {
            Assert.fail((String)("Error validating encode / decode of mark XML: " + ex));
        }
        EPPCodecTst.printEnd("testMark");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        try {
            KeyStore.PrivateKeyEntry keyEntry = EPPLaunchTst.loadPrivateKeyEntry(KEYSTORE_FILENAME, KEYSTORE_KEY_ALIAS, KEYSTORE_PASSWORD);
            privateKey = keyEntry.getPrivateKey();
            certChain = keyEntry.getCertificateChain();
            publicKey = EPPLaunchTst.loadPublicKey(KEYSTORE_FILENAME, KEYSTORE_CERT_ALIAS);
        }
        catch (Exception ex) {
            Assert.fail((String)("Error loading keys for signing and validating: " + ex));
        }
        try {
            ArrayList<String> crls = new ArrayList<String>();
            crls.add("eppsdk.crl");
            crls.add("tmch-pilot.crl");
            pkixParameters = EPPLaunchTst.loadPKIXParameters(TRUSTSTORE_FILENAME, crls);
        }
        catch (Exception ex) {
            Assert.fail((String)("Error loading trust store: " + ex));
        }
        File smdRevocationListFile = new File("smd-test-revocation.csv");
        if (smdRevocationListFile.exists()) {
            try {
                FileInputStream smdRevocationListStream = new FileInputStream(smdRevocationListFile);
                smdRevocationList.decode(smdRevocationListStream);
                System.out.println("SMD Revocation List = [\n" + smdRevocationList + "]");
            }
            catch (FileNotFoundException e) {
                Assert.fail((String)("Error opening SMD Revocation List File: " + e));
            }
            catch (EPPDecodeException e) {
                Assert.fail((String)("Error decoding SMD Revocation List File: " + e));
            }
        }
        TestSuite suite = new TestSuite(EPPLaunchTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.host.EPPHostMapFactory");
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.launch.EPPLaunchExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPDomainMapFactory or EPPLaunchExtFactory to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPLaunchTst Thread " + i, EPPLaunchTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPLaunchTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PKIXParameters loadPKIXParameters(String aTrustStoreName, List<String> aCrls) throws Exception {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream trustStoreFile = new FileInputStream(aTrustStoreName);
        trustStore.load(trustStoreFile, null);
        PKIXParameters pkixParameters = new PKIXParameters(trustStore);
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        ArrayList<CRL> crlContentsList = new ArrayList<CRL>();
        for (String currCrl : aCrls) {
            File crlFile = new File(currCrl);
            if (crlFile.exists()) {
                FileInputStream inStream = null;
                try {
                    inStream = new FileInputStream(currCrl);
                    crlContentsList.add(certFactory.generateCRL(inStream));
                    continue;
                }
                finally {
                    if (inStream != null) {
                        ((InputStream)inStream).close();
                    }
                    continue;
                }
            }
            System.err.println("CRL file \"" + currCrl + "\" NOT found.");
        }
        if (crlContentsList.size() != 0) {
            ArrayList<CertStore> certStores = new ArrayList<CertStore>();
            certStores.add(CertStore.getInstance("Collection", new CollectionCertStoreParameters(crlContentsList)));
            pkixParameters.setCertStores(certStores);
            pkixParameters.setRevocationEnabled(true);
            System.out.println("Revocation enabled");
        } else {
            pkixParameters.setRevocationEnabled(false);
            System.out.println("Revocation disabled.");
        }
        return pkixParameters;
    }

    private static KeyStore.PrivateKeyEntry loadPrivateKeyEntry(String aKeyStoreName, String aKeyAliasName, String aPassword) throws Exception {
        System.out.println("Loading private key from keystore " + aKeyStoreName + " and alias " + aKeyAliasName);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream keyStoreFile = new FileInputStream(aKeyStoreName);
        keyStore.load(keyStoreFile, aPassword.toCharArray());
        assert (keyStore.isKeyEntry(aKeyAliasName));
        KeyStore.PrivateKeyEntry keyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(aKeyAliasName, new KeyStore.PasswordProtection(aPassword.toCharArray()));
        return keyEntry;
    }

    public static PublicKey loadPublicKey(String aKeyStoreName, String aPublicKeyAlias) throws Exception {
        System.out.println("Loading public key from keystore " + aKeyStoreName + " and alias " + aPublicKeyAlias);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream keyStoreFile = new FileInputStream(aKeyStoreName);
        keyStore.load(keyStoreFile, null);
        assert (keyStore.isCertificateEntry(aPublicKeyAlias));
        KeyStore.TrustedCertificateEntry certEntry = (KeyStore.TrustedCertificateEntry)keyStore.getEntry(aPublicKeyAlias, null);
        return certEntry.getTrustedCertificate().getPublicKey();
    }

    static {
        smdRevocationList = new SMDRevocationList();
    }

    private static class SMDFilenameFilter
    implements FilenameFilter {
        private SMDFilenameFilter() {
        }

        @Override
        public boolean accept(File aDir, String aName) {
            return aName.endsWith(".smd");
        }
    }
}

