/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPComponentNotFoundException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPDuplicateExtensionException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPExtValue;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.codec.gen.EPPMsgQueue;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPResponse
implements EPPMessage {
    public static final String TRANSFER_CLIENT_APPROVED = "clientApproved";
    public static final String TRANSFER_CLIENT_CANCELLED = "clientCancelled";
    public static final String TRANSFER_CLIENT_REJECTED = "clientRejected";
    public static final String TRANSFER_PENDING = "pending";
    public static final String TRANSFER_SERVER_APPROVED = "serverApproved";
    public static final String TRANSFER_SERVER_CANCELLED = "serverCancelled";
    public static final String ELM_NAME = "response";
    public static final String ELM_MESSAGE_QUEUE = "msgQ";
    public static final String ELM_RESPONSE_DATA = "resData";
    public static final String ELM_MESSAGE_QUEUE_QDATE = "qDate";
    public static final String ELM_EXTENSION = "extension";
    protected Vector<EPPCodecComponent> extensions = null;
    private Vector<EPPResult> results;
    private EPPMsgQueue msgQueue = null;
    private EPPTransId transId;

    public EPPResponse() {
        this.transId = null;
        this.extensions = null;
        this.msgQueue = null;
        this.setResult(1000);
    }

    public EPPResponse(EPPTransId aTransId) {
        this.transId = aTransId;
        this.extensions = null;
        this.msgQueue = null;
        this.setResult(1000);
    }

    public EPPResponse(EPPTransId aTransId, EPPResult aResult) {
        this.transId = aTransId;
        this.extensions = null;
        this.msgQueue = null;
        this.results = new Vector();
        this.results.addElement(aResult);
    }

    public String getType() {
        return null;
    }

    public EPPTransId getTransId() {
        return this.transId;
    }

    public void setTransId(EPPTransId aTransId) {
        this.transId = aTransId;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp-1.0";
    }

    public Vector<EPPResult> getResults() {
        return this.results;
    }

    public EPPResult getResult() {
        if (this.results.size() == 0) {
            return null;
        }
        return this.results.elementAt(0);
    }

    public boolean isSuccess() {
        if (this.results.size() != 1) {
            return false;
        }
        return this.results.elementAt(0).isSuccess();
    }

    public boolean hasResultCode(int aCode) {
        Iterator<EPPResult> theIter = this.results.iterator();
        while (theIter.hasNext()) {
            if (theIter.next().getCode() != aCode) continue;
            return true;
        }
        return false;
    }

    public void setResult(int aCode) {
        this.results = new Vector();
        this.results.addElement(new EPPResult(aCode));
    }

    public void setResult(int aCode, String aText) {
        this.results = new Vector();
        this.results.addElement(new EPPResult(aCode, aText));
    }

    public void setResult(int aCode, String aText, Vector<EPPExtValue> aValues) {
        this.results = new Vector();
        this.results.addElement(new EPPResult(aCode, aText, aValues));
    }

    public void setResult(EPPResult aResult) {
        this.results = new Vector();
        this.results.addElement(aResult);
    }

    public void setResults(Vector<EPPResult> aResults) {
        this.results = aResults;
    }

    public boolean hasExtension(Class aExtensionClass) {
        return this.getExtension(aExtensionClass) != null;
    }

    public EPPCodecComponent getExtension(Class aExtensionClass) {
        if (this.extensions == null) {
            return null;
        }
        for (EPPCodecComponent theExtension : this.extensions) {
            if (!aExtensionClass.isInstance(theExtension)) continue;
            return theExtension;
        }
        return null;
    }

    public EPPCodecComponent getExtension(Class aExtensionClass, boolean aFailOnDuplicate) throws EPPDuplicateExtensionException {
        EPPCodecComponent theExtension = null;
        if (this.extensions == null) {
            return null;
        }
        for (EPPCodecComponent currExtension : this.extensions) {
            if (!aExtensionClass.isInstance(currExtension)) continue;
            if (theExtension != null && aFailOnDuplicate) {
                throw new EPPDuplicateExtensionException(currExtension);
            }
            theExtension = currExtension;
            if (aFailOnDuplicate) continue;
            return theExtension;
        }
        return theExtension;
    }

    @Deprecated
    public void setExtension(EPPCodecComponent aExtension) {
        this.addExtension(aExtension);
    }

    public void addExtension(EPPCodecComponent aExtension) {
        if (this.extensions == null) {
            this.extensions = new Vector();
        }
        this.extensions.addElement(aExtension);
    }

    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    public Vector<EPPCodecComponent> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Vector<EPPCodecComponent> aExtensions) {
        this.extensions = aExtensions;
    }

    public Set<String> findDuplicateExtNamespaces() {
        return EPPUtil.findDuplicateExtNamespaces(this.extensions);
    }

    public Set<String> findUnsupportedExtNamespaces(List<String> aSupportedExtNamespaces) {
        return EPPUtil.findUnsupportedExtNamespaces(aSupportedExtNamespaces, this.extensions);
    }

    public Set<String> findUnsupportedExtNamespaceSuffixes(List<String> aSupportedExtNamespaceSuffixes) {
        return EPPUtil.findUnsupportedExtNamespaceSuffixes(aSupportedExtNamespaceSuffixes, this.extensions);
    }

    public Set<String> findExtNamespaces(List<String> aFilterExtNamespaces) {
        return EPPUtil.findExtNamespaces(this.extensions, aFilterExtNamespaces);
    }

    public Set<String> findExtNamespaceSuffixes(List<String> aFilterExtNamespaceSuffixes) {
        return EPPUtil.findExtNamespaceSuffixes(this.extensions, aFilterExtNamespaceSuffixes);
    }

    @Deprecated
    public boolean hasMessageQueue() {
        return this.msgQueue != null && this.msgQueue.getCount() != null;
    }

    @Deprecated
    public Long getMessageQueue() {
        if (this.msgQueue != null) {
            return this.msgQueue.getCount();
        }
        return null;
    }

    @Deprecated
    public Date getQDate() {
        if (this.msgQueue != null) {
            return this.msgQueue.getQDate();
        }
        return null;
    }

    public boolean hasMsgQueue() {
        return this.msgQueue != null;
    }

    public void setMsgQueue(EPPMsgQueue aMsgQueue) {
        this.msgQueue = aMsgQueue;
    }

    public EPPMsgQueue getMsgQueue() {
        if (this.msgQueue != null) {
            return this.msgQueue;
        }
        return null;
    }

    public Long getMsgQueueCount() {
        if (this.msgQueue != null) {
            return this.msgQueue.getCount();
        }
        return null;
    }

    public Date getMsgQueueDate() {
        if (this.msgQueue != null) {
            return this.msgQueue.getQDate();
        }
        return null;
    }

    public String getMsgQueueMsg() {
        if (this.msgQueue != null) {
            return this.msgQueue.getMsg();
        }
        return null;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_NAME);
        EPPUtil.encodeCompVector(aDocument, root, this.results);
        EPPUtil.encodeComp(aDocument, root, this.msgQueue);
        Element mapping = this.doEncode(aDocument);
        if (mapping != null) {
            Element elementData = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_RESPONSE_DATA);
            elementData.appendChild(mapping);
            root.appendChild(elementData);
        }
        if (this.hasExtensions()) {
            Element extensionElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_EXTENSION);
            root.appendChild(extensionElm);
            EPPUtil.encodeCompVector(aDocument, extensionElm, this.extensions);
        }
        EPPUtil.encodeComp(aDocument, root, this.transId);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException, EPPComponentNotFoundException {
        Element extensionElm;
        this.results = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:epp-1.0", "result", EPPResult.class);
        this.msgQueue = (EPPMsgQueue)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_MESSAGE_QUEUE, EPPMsgQueue.class);
        Element resDataElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_RESPONSE_DATA);
        if (resDataElm != null) {
            Element responseMap = EPPUtil.getFirstElementChild(resDataElm);
            if (responseMap == null) {
                throw new EPPDecodeException("No child element found for resData");
            }
            this.doDecode(responseMap);
        }
        if ((extensionElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_EXTENSION)) != null) {
            Element currExtension = EPPUtil.getFirstElementChild(extensionElm);
            while (currExtension != null) {
                EPPCodecComponent theExtension = null;
                try {
                    theExtension = EPPFactory.getInstance().createExtension(currExtension);
                }
                catch (EPPCodecException e) {
                    throw new EPPComponentNotFoundException(3, "EPPResponse.decode unable to create extension object: " + e);
                }
                theExtension.decode(currExtension);
                this.addExtension(theExtension);
                currExtension = EPPUtil.getNextElementSibling(currExtension);
            }
        }
        this.transId = (EPPTransId)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp-1.0", "trID", EPPTransId.class);
    }

    public boolean equals(Object aObject) {
        EPPResponse theResponse = (EPPResponse)aObject;
        if (!EPPUtil.equalVectors(this.results, theResponse.results)) {
            return false;
        }
        if (!(this.msgQueue != null ? this.msgQueue.equals(theResponse.msgQueue) : theResponse.msgQueue == null)) {
            return false;
        }
        if (!EPPUtil.equalVectors(this.extensions, theResponse.extensions)) {
            return false;
        }
        return this.transId != null ? this.transId.equals(theResponse.transId) : theResponse.transId == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        int i;
        EPPResponse clone = null;
        clone = (EPPResponse)super.clone();
        clone.results = (Vector)this.results.clone();
        for (i = 0; i < this.results.size(); ++i) {
            clone.results.setElementAt((EPPResult)this.results.elementAt(i).clone(), i);
        }
        if (this.msgQueue != null) {
            clone.msgQueue = (EPPMsgQueue)this.msgQueue.clone();
        }
        if (this.extensions != null) {
            clone.extensions = (Vector)this.extensions.clone();
            for (i = 0; i < this.extensions.size(); ++i) {
                clone.extensions.setElementAt((EPPCodecComponent)this.extensions.elementAt(i).clone(), i);
            }
        }
        if (this.transId != null) {
            clone.transId = (EPPTransId)this.transId.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        return null;
    }

    protected void doDecode(Element aElement) throws EPPDecodeException {
    }
}

