/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPGreeting;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPServiceMenu;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Enumeration;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EPPLoginCmd
extends EPPCommand {
    static final String ELM_NAME = "login";
    private static final String ELM_CLIENT_ID = "clID";
    private static final String ELM_PASSWORD = "pw";
    private static final String ELM_NEW_PASSWORD = "newPW";
    private static final String ELM_OPTIONS = "options";
    private static final String ELM_SERVICES = "svcs";
    private static final String ELM_EXT_SERVICES = "svcExtension";
    private static final String ELM_EXT_URI = "extURI";
    private static Logger cat = LoggerFactory.getLogger(EPPLoginCmd.class);
    private String clientId = null;
    private String password = null;
    private String newPassword = null;
    private String version = "1.0";
    private String lang = "en";
    private Vector<EPPService> services = EPPFactory.getInstance().getServices();
    private Vector<EPPService> extservices = EPPFactory.getInstance().getExtensions();
    private final String ELM_VERSION = "version";
    private final String ELM_LANG = "lang";

    public EPPLoginCmd() {
    }

    public EPPLoginCmd(String aTransId, String aClientId, String aPassword) {
        super(aTransId);
        this.clientId = aClientId;
        this.password = aPassword;
    }

    public EPPLoginCmd(String aTransId, String aClientId, String aPassword, String aNewPassword) {
        super(aTransId);
        this.clientId = aClientId;
        this.password = aPassword;
        this.newPassword = aNewPassword;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp-1.0";
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String aClientId) {
        this.clientId = aClientId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String aPassword) {
        this.password = aPassword;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String aNewPassword) {
        this.newPassword = aNewPassword;
    }

    public boolean hasNewPassword() {
        return this.newPassword != null;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String aVersion) {
        this.version = aVersion;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String aLang) {
        this.lang = aLang;
    }

    public Vector<EPPService> getServices() {
        return this.services;
    }

    public void setServices(Vector<EPPService> aServices) {
        this.services = aServices;
    }

    public boolean hasService(String aNamespaceURI) {
        boolean found = false;
        if (this.services != null) {
            Enumeration<EPPService> theSvcEnum = this.services.elements();
            while (!found && theSvcEnum.hasMoreElements()) {
                EPPService theExtService = theSvcEnum.nextElement();
                if (!theExtService.getNamespaceURI().equals(aNamespaceURI)) continue;
                found = true;
            }
        }
        return found;
    }

    public boolean hasExtensionService(String aNamespaceURI) {
        boolean found = false;
        if (this.extservices != null) {
            Enumeration<EPPService> theExtSvcEnum = this.extservices.elements();
            while (!found && theExtSvcEnum.hasMoreElements()) {
                EPPService theExtService = theExtSvcEnum.nextElement();
                if (!theExtService.getNamespaceURI().equals(aNamespaceURI)) continue;
                found = true;
            }
        }
        return found;
    }

    public Vector<EPPService> getExtensionServices() {
        return this.extservices;
    }

    public void setExtensionServices(Vector<EPPService> aExtServices) {
        this.extservices = aExtServices;
    }

    @Override
    protected Element doGenEncode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.clientId, "urn:ietf:params:xml:ns:epp-1.0", ELM_CLIENT_ID);
        EPPUtil.encodeString(aDocument, root, this.password, "urn:ietf:params:xml:ns:epp-1.0", ELM_PASSWORD);
        EPPUtil.encodeString(aDocument, root, this.newPassword, "urn:ietf:params:xml:ns:epp-1.0", ELM_NEW_PASSWORD);
        Element optionsElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_OPTIONS);
        root.appendChild(optionsElm);
        EPPUtil.encodeString(aDocument, optionsElm, this.version, "urn:ietf:params:xml:ns:epp-1.0", "version");
        EPPUtil.encodeString(aDocument, optionsElm, this.lang, "urn:ietf:params:xml:ns:epp-1.0", "lang");
        Element servicesElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_SERVICES);
        root.appendChild(servicesElm);
        EPPUtil.encodeCompVector(aDocument, servicesElm, this.services);
        if (this.extservices != null && this.extservices.elements().hasMoreElements()) {
            Element svcExtension = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_EXT_SERVICES);
            EPPUtil.encodeCompVector(aDocument, svcExtension, this.extservices);
            servicesElm.appendChild(svcExtension);
        }
        root.appendChild(servicesElm);
        return root;
    }

    @Override
    protected void doGenDecode(Element aElement) throws EPPDecodeException {
        this.clientId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_CLIENT_ID);
        this.password = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_PASSWORD);
        this.newPassword = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_NEW_PASSWORD);
        NodeList elms = aElement.getElementsByTagNameNS("urn:ietf:params:xml:ns:epp-1.0", ELM_OPTIONS);
        if (elms.getLength() == 1) {
            Element optionsElm = (Element)elms.item(0);
            this.version = EPPUtil.decodeString(optionsElm, "urn:ietf:params:xml:ns:epp-1.0", "version");
            this.lang = EPPUtil.decodeString(optionsElm, "urn:ietf:params:xml:ns:epp-1.0", "lang");
        } else {
            this.version = null;
            this.lang = null;
        }
        this.services = new Vector();
        this.extservices = new Vector();
        Element servicesElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_SERVICES);
        if (servicesElm == null) {
            throw new EPPDecodeException("EPPLoginCmd.doGenDecode did not find a svcs element");
        }
        NodeList serviceElms = servicesElm.getElementsByTagNameNS("urn:ietf:params:xml:ns:epp-1.0", EPPUtil.getLocalName("objURI"));
        for (int i = 0; i < serviceElms.getLength(); ++i) {
            EPPService currService = new EPPService();
            currService.setServiceType(0);
            currService.decode((Element)serviceElms.item(i));
            this.services.addElement(currService);
        }
        NodeList svcExtensionNodeList = aElement.getElementsByTagNameNS("urn:ietf:params:xml:ns:epp-1.0", EPPUtil.getLocalName(ELM_EXT_SERVICES));
        if (svcExtensionNodeList.getLength() != 0) {
            Element svcExtension = null;
            for (int i = 0; i < svcExtensionNodeList.getLength(); ++i) {
                svcExtension = (Element)svcExtensionNodeList.item(i);
                NodeList extensionElms = svcExtension.getElementsByTagNameNS("urn:ietf:params:xml:ns:epp-1.0", EPPUtil.getLocalName(ELM_EXT_URI));
                for (int k = 0; k < extensionElms.getLength(); ++k) {
                    EPPService extService = new EPPService();
                    extService.setServiceType(1);
                    extService.decode((Element)extensionElms.item(k));
                    this.extservices.addElement(extService);
                }
            }
        }
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLoginCmd)) {
            return false;
        }
        EPPLoginCmd theLogin = (EPPLoginCmd)aObject;
        if (!super.equals(aObject)) {
            return false;
        }
        if (!(this.clientId != null ? this.clientId.equals(theLogin.clientId) : theLogin.clientId == null)) {
            return false;
        }
        if (!(this.password != null ? this.password.equals(theLogin.password) : theLogin.password == null)) {
            return false;
        }
        if (!(this.newPassword != null ? this.newPassword.equals(theLogin.newPassword) : theLogin.newPassword == null)) {
            return false;
        }
        if (!(this.version != null ? this.version.equals(theLogin.version) : theLogin.version == null)) {
            return false;
        }
        if (!(this.lang != null ? this.lang.equals(theLogin.lang) : theLogin.lang == null)) {
            return false;
        }
        return EPPUtil.equalVectors(this.services, theLogin.services);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPLoginCmd clone = null;
        clone = (EPPLoginCmd)super.clone();
        clone.services = (Vector)this.services.clone();
        for (int i = 0; i < this.services.size(); ++i) {
            clone.services.setElementAt((EPPService)this.services.elementAt(i).clone(), i);
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean isValidServices(EPPGreeting aGreeting) {
        cat.debug("isValidServices(): enter");
        EPPServiceMenu greetingServices = aGreeting.getServiceMenu();
        if (this.lang == null || !greetingServices.getLangs().contains(this.lang)) {
            cat.error("lang mismatch " + this.lang + " not in " + greetingServices.getLangs());
            return false;
        }
        if (this.version == null || !greetingServices.getVersions().contains(this.version)) {
            cat.error("version mismatch " + this.version + " not in " + greetingServices.getVersions());
            return false;
        }
        if (!EPPUtil.vectorSubset(this.services, greetingServices.getObjectServices())) {
            cat.debug("services mismatch " + this.services + " not in " + greetingServices.getObjectServices());
            return false;
        }
        cat.debug("isValidServices(): exit (true)");
        return true;
    }

    public void mergeServicesAndExtensionServices(EPPGreeting aGreeting) {
        this.services.retainAll(aGreeting.getServiceMenu().getObjectServices());
        this.extservices.retainAll(aGreeting.getServiceMenu().getExtensionServices());
    }
}

