/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPExtFactory;
import com.verisign.epp.codec.gen.EPPLoginCmd;
import com.verisign.epp.codec.gen.EPPLogoutCmd;
import com.verisign.epp.codec.gen.EPPMapFactory;
import com.verisign.epp.codec.gen.EPPPollCmd;
import com.verisign.epp.codec.gen.EPPProtocolExtension;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class EPPFactory {
    private static EPPFactory instance = new EPPFactory();
    private static Logger cat = LoggerFactory.getLogger(EPPFactory.class);
    private Hashtable<String, EPPMapFactory> factories = new Hashtable();
    private Hashtable<String, EPPExtFactory> extFactories = new Hashtable();
    private Set<EPPMapFactory> factoriesSet = new LinkedHashSet<EPPMapFactory>();
    private Set<EPPExtFactory> extFactoriesSet = new LinkedHashSet<EPPExtFactory>();

    protected EPPFactory() {
    }

    public static EPPFactory getInstance() {
        return instance;
    }

    public EPPCommand createCommand(String aCommandType, String aOp) throws EPPCodecException {
        String commandTypeLocalName = EPPUtil.getLocalName(aCommandType);
        if (commandTypeLocalName.equals(EPPUtil.getLocalName("login"))) {
            return new EPPLoginCmd();
        }
        if (commandTypeLocalName.equals(EPPUtil.getLocalName("logout"))) {
            return new EPPLogoutCmd();
        }
        if (commandTypeLocalName.equals(EPPUtil.getLocalName("poll"))) {
            return new EPPPollCmd();
        }
        throw new EPPCodecException("Invalid command type " + commandTypeLocalName + " in EPPFactory.createCommand");
    }

    public EPPCommand createCommand(Element aMapElement) throws EPPCodecException {
        String nsUri = aMapElement.getNamespaceURI();
        EPPMapFactory target = this.factories.get(nsUri);
        if (target == null) {
            throw new EPPCodecException("Unable to find factory for namespace " + aMapElement.getNamespaceURI());
        }
        return target.createCommand(aMapElement);
    }

    public EPPResponse createResponse(Element aMapElement) throws EPPCodecException {
        EPPMapFactory target = this.factories.get(aMapElement.getNamespaceURI());
        if (target == null) {
            throw new EPPCodecException("Unable to find factory for namespace " + aMapElement.getNamespaceURI());
        }
        return target.createResponse(aMapElement);
    }

    public EPPCodecComponent createExtension(Element aExtensionElm) throws EPPCodecException {
        String nsUri = aExtensionElm.getNamespaceURI();
        EPPExtFactory target = this.extFactories.get(nsUri);
        if (target == null) {
            throw new EPPCodecException("Unable to find extension factory for namespace " + aExtensionElm.getNamespaceURI());
        }
        return target.createExtension(aExtensionElm);
    }

    public EPPProtocolExtension createProtocolExtension(Element aExtensionElm) throws EPPCodecException {
        String nsUri = aExtensionElm.getNamespaceURI();
        EPPExtFactory target = this.extFactories.get(nsUri);
        if (target == null) {
            throw new EPPCodecException("Unable to find extension factory for namespace " + aExtensionElm.getNamespaceURI());
        }
        return target.createProtocolExtension(aExtensionElm);
    }

    public Vector<EPPService> getServices() {
        Vector<EPPService> retServices = new Vector<EPPService>();
        Enumeration<EPPMapFactory> factoryElms = this.factories.elements();
        while (factoryElms.hasMoreElements()) {
            EPPMapFactory currFactory = factoryElms.nextElement();
            retServices.addElement(currFactory.getService());
        }
        return retServices;
    }

    public Vector<EPPService> getExtensions() {
        Vector<EPPService> retServices = new Vector<EPPService>();
        Enumeration<EPPExtFactory> factoryElms = this.extFactories.elements();
        while (factoryElms.hasMoreElements()) {
            EPPExtFactory currFactory = factoryElms.nextElement();
            retServices.addElement(currFactory.getService());
        }
        return retServices;
    }

    public boolean hasService(String aNamespace) {
        return this.factories.containsKey(aNamespace);
    }

    public boolean hasExtension(String aNamespace) {
        return this.extFactories.containsKey(aNamespace);
    }

    public void init(Vector<String> aMapFactories) throws EPPCodecException {
        cat.debug("init(Vector): enter");
        Object currService = null;
        Object currFactory = null;
        String currFactoryName = null;
        this.factories = new Hashtable();
        for (int i = 0; i < aMapFactories.size(); ++i) {
            currFactoryName = aMapFactories.elementAt(i);
            cat.debug("init(Vector): Add Map Factory <" + currFactoryName + ">");
            this.addMapFactory(currFactoryName);
        }
        this.extFactories = new Hashtable();
        cat.debug("init(Vector): exit");
    }

    public void init(Vector<String> aMapFactories, Vector<String> aExtFactories) throws EPPCodecException {
        cat.debug("init(Vector, Vector): enter");
        this.init(aMapFactories);
        Object currService = null;
        Object currFactory = null;
        String currFactoryName = null;
        for (int i = 0; i < aExtFactories.size(); ++i) {
            currFactoryName = aExtFactories.elementAt(i);
            cat.debug("init(Vector, Vector): Add Ext Factory <" + currFactoryName + ">");
            this.addExtFactory(currFactoryName);
        }
        cat.debug("init(Vector, Vector): exit");
    }

    public void addMapFactory(String aMapFactory) throws EPPCodecException {
        cat.debug("addMapFactory(String): enter");
        try {
            if (!this.mapFactoryExists(aMapFactory)) {
                cat.info("addMapFactory(String): Loading <" + aMapFactory + ">");
                Class<?> factoryClass = Class.forName(aMapFactory);
                if (!EPPMapFactory.class.isAssignableFrom(factoryClass)) {
                    throw new EPPCodecException(aMapFactory + " is not a subclass of EPPMapFactory");
                }
                EPPMapFactory theFactory = (EPPMapFactory)factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                EPPService theService = theFactory.getService();
                if (theService == null) {
                    throw new EPPCodecException(aMapFactory + " returned null on call to getService");
                }
                cat.info("addMapFactory(String): Adding <" + aMapFactory + "> with Namespace <" + theService.getNamespaceURI() + ">");
                this.factories.put(theService.getNamespaceURI(), theFactory);
                this.factoriesSet.add(theFactory);
            }
        }
        catch (Exception e) {
            throw new EPPCodecException(aMapFactory + " " + e.getClass().getName() + ": " + e);
        }
        cat.debug("addMapFactory(String): exit");
    }

    public void addExtFactory(String aExtFactory) throws EPPCodecException {
        cat.debug("addExtFactory(String): enter");
        try {
            if (!this.extFactoryExists(aExtFactory)) {
                cat.info("addExtFactory(String): Loading <" + aExtFactory + ">");
                Class<?> factoryClass = Class.forName(aExtFactory);
                if (!EPPExtFactory.class.isAssignableFrom(factoryClass)) {
                    throw new EPPCodecException(aExtFactory + " is not a subclass of EPPExtFactory");
                }
                EPPExtFactory theFactory = (EPPExtFactory)factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                EPPService theService = theFactory.getService();
                if (theService == null) {
                    throw new EPPCodecException(aExtFactory + " returned null on call to getService");
                }
                cat.info("addExtFactory(String): Adding <" + aExtFactory + "> with Namespace <" + theService.getNamespaceURI() + ">");
                this.extFactories.put(theService.getNamespaceURI(), theFactory);
                this.extFactoriesSet.add(theFactory);
            }
        }
        catch (Exception e) {
            throw new EPPCodecException(aExtFactory + " " + e.getClass().getName() + ": " + e);
        }
        cat.debug("addExtFactory(String): exit");
    }

    public Set getXmlSchemas() {
        cat.debug("getXmlSchemas(): enter");
        LinkedHashSet<String> theSchemas = new LinkedHashSet<String>();
        cat.debug("getXmlSchemas(): Loading required EPP XML schemas");
        theSchemas.add("eppcom-1.0.xsd");
        theSchemas.add("epp-1.0.xsd");
        for (EPPMapFactory currFactory : this.factoriesSet) {
            cat.debug("getXmlSchemas(): Loading EPP XML schemas from " + currFactory.getClass().getName());
            if (currFactory.getXmlSchemas() == null) continue;
            theSchemas.addAll(currFactory.getXmlSchemas());
        }
        for (EPPExtFactory currFactory : this.extFactoriesSet) {
            cat.debug("getXmlSchemas(): Loading EPP XML schemas from " + currFactory.getClass().getName());
            if (currFactory.getXmlSchemas() == null) continue;
            theSchemas.addAll(currFactory.getXmlSchemas());
        }
        if (cat.isDebugEnabled()) {
            cat.debug("getXmlSchemas(): XML Schemas = " + theSchemas);
        }
        cat.debug("getXmlSchemas(): exit");
        return theSchemas;
    }

    boolean mapFactoryExists(String aMapFactory) {
        Enumeration<EPPMapFactory> enumeration = this.factories.elements();
        while (enumeration.hasMoreElements()) {
            if (!enumeration.nextElement().getClass().getName().equals(aMapFactory)) continue;
            return true;
        }
        return false;
    }

    boolean extFactoryExists(String aExtFactory) {
        Enumeration<EPPExtFactory> enumeration = this.extFactories.elements();
        while (enumeration.hasMoreElements()) {
            if (!enumeration.nextElement().getClass().getName().equals(aExtFactory)) continue;
            return true;
        }
        return false;
    }
}

