/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.emailFwd;

import com.verisign.epp.codec.emailFwd.EPPEmailFwdAddRemove;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCheckCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCheckResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCheckResult;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdContact;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCreateCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCreateResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdDeleteCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdInfoCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdInfoResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdPeriod;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdRenewCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdRenewResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdStatus;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdTransferCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdTransferResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EPPEmailFwdTst {
    private static long numIterations = 1L;
    private static boolean _initLogging = true;

    @Test
    public void testEmailFwdInfo() {
        EPPCodecTst.printStart("testEmailFwdInfo");
        EPPEmailFwdInfoCmd theCommand = new EPPEmailFwdInfoCmd("ABC-12349", "john@example.name");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        Vector<EPPEmailFwdStatus> statuses = new Vector<EPPEmailFwdStatus>();
        statuses.addElement(new EPPEmailFwdStatus("ok"));
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPEmailFwdInfoResp theResponse = new EPPEmailFwdInfoResp(respTransId, "EXAMPLE1-VRSN", "john@smith.name", "john@example.name", "ClientX", statuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theResponse.setRegistrant("JD1234-VRSN");
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            Vector<EPPEmailFwdContact> contacts = new Vector<EPPEmailFwdContact>();
            contacts.addElement(new EPPEmailFwdContact("SH8013-VRSN", "admin"));
            contacts.addElement(new EPPEmailFwdContact("SH8013-VRSN", "tech"));
            theResponse.setContacts(contacts);
        }
        theResponse.setLastUpdatedBy("ClientX");
        theResponse.setLastUpdatedDate(new Date());
        theResponse.setLastTransferDate(new Date());
        respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        theResponse.setTransId(respTransId);
        theResponse.setRoid("EXAMPLE1-VRSN");
        theResponse.setResult(1000);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theResponse = new EPPEmailFwdInfoResp();
        theResponse.setName("john@doe.name");
        theResponse.setRoid("EXAMPLE1-VRSN");
        theResponse.setClientId("ClientX");
        respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        theResponse.setTransId(respTransId);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testEmailFwdInfo");
    }

    @Test
    public void testEmailFwdCreate() {
        EPPCodecTst.printStart("testEmailFwdCreate");
        EPPEmailFwdCreateCmd theCommand = new EPPEmailFwdCreateCmd("ABC-12345", "john@example.name", "john@yahoo.com", new EPPAuthInfo("2fooBAR"));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        Vector<EPPEmailFwdContact> contacts = null;
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            contacts = new Vector<EPPEmailFwdContact>();
            contacts.addElement(new EPPEmailFwdContact("SH8013-VRSN", "admin"));
            contacts.addElement(new EPPEmailFwdContact("SH8013-VRSN", "tech"));
        }
        theCommand = new EPPEmailFwdCreateCmd("ABC-12345", "john@example.name", "john@yahoo.com", contacts, new EPPEmailFwdPeriod(2), new EPPAuthInfo("2fooBAR"));
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPEmailFwdCreateResp theResponse = new EPPEmailFwdCreateResp(respTransId, "john@yahoo.com", new GregorianCalendar(2001, 5, 5).getTime(), new Date());
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testEmailFwdCreate");
    }

    @Test
    public void testEmailFwdDelete() {
        EPPCodecTst.printStart("testEmailFwdDelete");
        EPPEmailFwdDeleteCmd theCommand = new EPPEmailFwdDeleteCmd("ABC-12345", "john@example.name");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testEmailFwdDelete");
    }

    @Test
    public void testEmailFwdRenew() {
        EPPCodecTst.printStart("testEmailFwdRenew");
        Calendar theCal = Calendar.getInstance();
        theCal.setTimeZone(TimeZone.getTimeZone("UTC"));
        theCal.set(2000, 6, 22, 0, 0, 0);
        theCal.set(14, 0);
        Date theDate = theCal.getTime();
        EPPEmailFwdRenewCmd theCommand = new EPPEmailFwdRenewCmd("ABC-12345", "john@exampleZ.com", theDate, new EPPEmailFwdPeriod(5));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPEmailFwdRenewResp theResponse = new EPPEmailFwdRenewResp(respTransId, "john@exampleX.com", new Date());
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testEmailFwdRenew");
    }

    @Test
    public void testEmailFwdUpate() {
        EPPCodecTst.printStart("testEmailFwdUpate");
        Vector<EPPEmailFwdStatus> addStatuses = new Vector<EPPEmailFwdStatus>();
        addStatuses.addElement(new EPPEmailFwdStatus("clientHold", "en"));
        Vector<EPPEmailFwdContact> addContacts = null;
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            addContacts = new Vector<EPPEmailFwdContact>();
            addContacts.addElement(new EPPEmailFwdContact("MAK21-VRSN", "tech"));
        }
        Vector<EPPEmailFwdStatus> removeStatuses = new Vector<EPPEmailFwdStatus>();
        removeStatuses.addElement(new EPPEmailFwdStatus("clientHold"));
        Vector<EPPEmailFwdContact> removeContacts = null;
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            removeContacts = new Vector<EPPEmailFwdContact>();
            removeContacts.addElement(new EPPEmailFwdContact("SH8013-VRSN", "tech"));
        }
        EPPEmailFwdAddRemove addItems = new EPPEmailFwdAddRemove(addContacts, addStatuses);
        EPPEmailFwdAddRemove removeItems = new EPPEmailFwdAddRemove(removeContacts, removeStatuses);
        EPPEmailFwdAddRemove changeItems = new EPPEmailFwdAddRemove("SH8013-VRSN", "asampath@verisign.com", new EPPAuthInfo("2fooBAR"));
        EPPEmailFwdUpdateCmd theCommand = new EPPEmailFwdUpdateCmd("ABC-12345-XYZ", "john@example.name", addItems, removeItems, changeItems);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testEmailFwdUpate");
    }

    @Test
    public void testEmailFwdTransfer() {
        EPPCodecTst.printStart("testEmailFwdTransfer");
        EPPEmailFwdTransferCmd theCommand = new EPPEmailFwdTransferCmd("ABC-12345", "request", "john@example.name", new EPPAuthInfo("2fooBAR"), new EPPEmailFwdPeriod(1));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPEmailFwdTransferResp theResponse = new EPPEmailFwdTransferResp(respTransId, "john@example.name");
        theResponse.setResult(1000);
        theResponse.setRequestClient("ClientX");
        theResponse.setActionClient("ClientY");
        theResponse.setTransferStatus("pending");
        theResponse.setRequestDate(new Date());
        theResponse.setActionDate(new Date());
        theResponse.setExpirationDate(new Date());
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theCommand = new EPPEmailFwdTransferCmd("ABC-12345", "cancel", "john@example.name");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPEmailFwdTransferCmd("ABC-12345", "query", "john@example.name");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPEmailFwdTransferCmd("ABC-12345", "reject", "john@example.name");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPEmailFwdTransferCmd("ABC-12345", "approve", "john@example.name");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testEmailFwdTransfer");
    }

    @BeforeClass
    public static void setup() {
        EPPCodecTst.initEnvironment();
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.emailFwd.EPPEmailFwdMapFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPEmailFwdMapFactory to EPPCodec: " + e));
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }

    @Test
    public void testEmailFwdCheck() {
        EPPCodecTst.printStart("testEmailFwdCheck");
        EPPEmailFwdCheckCmd theCommand = new EPPEmailFwdCheckCmd("ABC-12345", "as@example1.com");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        Vector<String> emailFwds = new Vector<String>();
        emailFwds.addElement("as@example1.com");
        emailFwds.addElement("as@example2.com");
        emailFwds.addElement("as@example3.com");
        theCommand = new EPPEmailFwdCheckCmd("ABC-12345-XYZ", emailFwds);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPEmailFwdCheckResp theResponse = new EPPEmailFwdCheckResp(respTransId, new EPPEmailFwdCheckResult("as@example1.com", true));
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        Vector<EPPEmailFwdCheckResult> emailFwdResults = new Vector<EPPEmailFwdCheckResult>();
        emailFwdResults.addElement(new EPPEmailFwdCheckResult("john@example1.com", true));
        EPPEmailFwdCheckResult emailFwdResult = new EPPEmailFwdCheckResult("john@example2.com", false);
        emailFwdResult.setEmailFwdReason("In use");
        emailFwdResult.setLanguage("fr");
        emailFwdResults.addElement(emailFwdResult);
        emailFwdResults.addElement(new EPPEmailFwdCheckResult("john@example3.com", true));
        theResponse = new EPPEmailFwdCheckResp(respTransId, emailFwdResults);
        theResponse.setResult(1000);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testEmailFwdCheck");
    }
}

