/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.emailFwd;

import com.verisign.epp.codec.emailFwd.EPPEmailFwdPeriod;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPTransferCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPEmailFwdTransferCmd
extends EPPTransferCmd {
    static final String ELM_NAME = "emailFwd:transfer";
    private static final String ELM_EMAILFWD_NAME = "emailFwd:name";
    private String name = null;
    private EPPEmailFwdPeriod period = null;
    private EPPAuthInfo authInfo = null;

    public EPPEmailFwdTransferCmd() {
        this.name = null;
        this.period = null;
        this.authInfo = null;
    }

    public EPPEmailFwdTransferCmd(String aTransId, String aOp, String aName) {
        super(aTransId, aOp);
        this.name = aName;
    }

    public EPPEmailFwdTransferCmd(String aTransId, String aOp, String aName, EPPAuthInfo aAuthInfo, EPPEmailFwdPeriod aPeriod) {
        super(aTransId, aOp);
        this.name = aName;
        this.period = aPeriod;
        this.setAuthInfo(aAuthInfo);
    }

    @Override
    public String getNamespace() {
        return "http://www.nic.name/epp/emailFwd-1.0";
    }

    @Override
    public String getKey() {
        return this.getName();
    }

    void validateState() throws EPPCodecException {
        if (super.getOp() == null) {
            throw new EPPCodecException("op required attribute is not set");
        }
        if (this.name == null) {
            throw new EPPCodecException("name required attribute is not set");
        }
        if (super.getOp().equals("request") && this.authInfo == null) {
            throw new EPPCodecException("authInfo required attribute is not set");
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("EPPEmailFwdTransferCmd invalid state: " + e);
        }
        Element root = aDocument.createElementNS("http://www.nic.name/epp/emailFwd-1.0", ELM_NAME);
        root.setAttribute("xmlns:emailFwd", "http://www.nic.name/epp/emailFwd-1.0");
        EPPUtil.encodeString(aDocument, root, this.name, "http://www.nic.name/epp/emailFwd-1.0", ELM_EMAILFWD_NAME);
        if (this.period != null && !this.period.isPeriodUnspec()) {
            EPPUtil.encodeComp(aDocument, root, this.period);
        }
        EPPUtil.encodeComp(aDocument, root, this.authInfo);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "http://www.nic.name/epp/emailFwd-1.0", ELM_EMAILFWD_NAME);
        this.period = (EPPEmailFwdPeriod)EPPUtil.decodeComp(aElement, "http://www.nic.name/epp/emailFwd-1.0", "emailFwd:period", EPPEmailFwdPeriod.class);
        this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "http://www.nic.name/epp/emailFwd-1.0", "emailFwd:authInfo", EPPAuthInfo.class);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPEmailFwdTransferCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPEmailFwdTransferCmd theMap = (EPPEmailFwdTransferCmd)aObject;
        if (!(this.name != null ? this.name.equals(theMap.name) : theMap.name == null)) {
            return false;
        }
        if (!(this.period != null ? this.period.equals(theMap.period) : theMap.period == null)) {
            return false;
        }
        return this.authInfo != null ? this.authInfo.equals(theMap.authInfo) : theMap.authInfo == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPEmailFwdTransferCmd clone = (EPPEmailFwdTransferCmd)super.clone();
        if (this.authInfo != null) {
            clone.authInfo = (EPPAuthInfo)this.authInfo.clone();
        }
        if (this.period != null) {
            clone.period = (EPPEmailFwdPeriod)this.period.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public EPPEmailFwdPeriod getPeriod() {
        return this.period;
    }

    public void setAuthInfo(EPPAuthInfo newAuthInfo) {
        if (newAuthInfo != null) {
            this.authInfo = newAuthInfo;
            this.authInfo.setRootName("http://www.nic.name/epp/emailFwd-1.0", "emailFwd:authInfo");
        }
    }

    public void setPeriod(EPPEmailFwdPeriod aPeriod) {
        this.period = aPeriod;
    }
}

