/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.emailFwd;

import com.verisign.epp.codec.emailFwd.EPPEmailFwdPeriod;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPRenewCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPEmailFwdRenewCmd
extends EPPRenewCmd {
    static final String ELM_NAME = "emailFwd:renew";
    private static final String ELM_EMAILFWD_NAME = "emailFwd:name";
    private static final String ELM_CURRENT_EXPIRATION_DATE = "emailFwd:curExpDate";
    private String name = null;
    private EPPEmailFwdPeriod period = null;
    private Date curExpDate = null;

    public EPPEmailFwdRenewCmd() {
        this.name = null;
        this.period = new EPPEmailFwdPeriod(1);
        this.curExpDate = null;
    }

    public EPPEmailFwdRenewCmd(String aTransId, String aName, Date aCurExpDate) {
        super(aTransId);
        this.name = aName;
        this.curExpDate = aCurExpDate;
        this.period = new EPPEmailFwdPeriod(1);
    }

    public EPPEmailFwdRenewCmd(String aTransId, String aName, Date aCurExpDate, EPPEmailFwdPeriod aPeriod) {
        super(aTransId);
        this.name = aName;
        this.curExpDate = aCurExpDate;
        this.period = aPeriod;
    }

    @Override
    public String getNamespace() {
        return "http://www.nic.name/epp/emailFwd-1.0";
    }

    @Override
    public String getKey() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPEmailFwdRenewCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPEmailFwdRenewCmd theMap = (EPPEmailFwdRenewCmd)aObject;
        if (!(this.name != null ? this.name.equals(theMap.name) : theMap.name == null)) {
            return false;
        }
        if (!(this.curExpDate != null ? this.curExpDate.equals(theMap.curExpDate) : theMap.curExpDate == null)) {
            return false;
        }
        return this.period != null ? this.period.equals(theMap.period) : theMap.period == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPEmailFwdRenewCmd clone = (EPPEmailFwdRenewCmd)super.clone();
        if (this.period != null) {
            clone.period = (EPPEmailFwdPeriod)this.period.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public Date getCurExpDate() {
        return this.curExpDate;
    }

    public EPPEmailFwdPeriod getPeriod() {
        return this.period;
    }

    public void setCurExpDate(Date newCurExpDate) {
        this.curExpDate = newCurExpDate;
    }

    public void setPeriod(EPPEmailFwdPeriod aPeriod) {
        this.period = aPeriod;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("EPPEmailFwdRenewCmd invalid state: " + e);
        }
        Element root = aDocument.createElementNS("http://www.nic.name/epp/emailFwd-1.0", ELM_NAME);
        root.setAttribute("xmlns:emailFwd", "http://www.nic.name/epp/emailFwd-1.0");
        EPPUtil.encodeString(aDocument, root, this.name, "http://www.nic.name/epp/emailFwd-1.0", ELM_EMAILFWD_NAME);
        EPPUtil.encodeDate(aDocument, root, this.curExpDate, "http://www.nic.name/epp/emailFwd-1.0", ELM_CURRENT_EXPIRATION_DATE);
        if (!this.period.isPeriodUnspec()) {
            EPPUtil.encodeComp(aDocument, root, this.period);
        }
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "http://www.nic.name/epp/emailFwd-1.0", ELM_EMAILFWD_NAME);
        this.curExpDate = EPPUtil.decodeDate(aElement, "http://www.nic.name/epp/emailFwd-1.0", ELM_CURRENT_EXPIRATION_DATE);
        this.period = (EPPEmailFwdPeriod)EPPUtil.decodeComp(aElement, "http://www.nic.name/epp/emailFwd-1.0", "emailFwd:period", EPPEmailFwdPeriod.class);
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            throw new EPPCodecException("name required attribute is not set");
        }
        if (this.curExpDate == null) {
            throw new EPPCodecException("currentExpirationYear required attribute is not set");
        }
    }
}

