/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.emailFwd;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPEmailFwdPendActionMsg
extends EPPResponse {
    static final String ELM_NAME = "emailFwd:panData";
    private static final String ELM_DOMAIN_NAME = "emailFwd:name";
    private static final String ELM_PATRID = "emailFwd:paTRID";
    private static final String ELM_PENDING_DATE = "emailFwd:paDate";
    private static final String ATTR_RESULT = "paResult";
    private static Logger cat = LoggerFactory.getLogger(EPPEmailFwdPendActionMsg.class);
    private String name = null;
    private boolean success = false;
    EPPTransId pendingTransId = null;
    private Date pendingDate = null;

    public EPPEmailFwdPendActionMsg() {
    }

    public EPPEmailFwdPendActionMsg(EPPTransId aTransId, String aName, boolean aSuccess, EPPTransId aPendingTransId, Date aPendingDate) {
        super(aTransId);
        this.name = aName;
        this.success = aSuccess;
        this.setPendingTransId(aPendingTransId);
        this.pendingTransId = aPendingTransId;
        this.pendingDate = aPendingDate;
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "http://www.nic.name/epp/emailFwd-1.0";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public Date getPendingDate() {
        return this.pendingDate;
    }

    public void setPendingDate(Date pendingDate) {
        this.pendingDate = pendingDate;
    }

    public EPPTransId getPendingTransId() {
        return this.pendingTransId;
    }

    public void setPendingTransId(EPPTransId pendingTransId) {
        this.pendingTransId = pendingTransId;
        this.pendingTransId.setRootName("http://www.nic.name/epp/emailFwd-1.0", ELM_PATRID);
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPEmailFwdPendActionMsg)) {
            cat.error("EPPEmailFwdPendActionMsg.equals(): " + aObject.getClass().getName() + " not EPPEmailFwdPendActionMsg instance");
            return false;
        }
        if (!super.equals(aObject)) {
            cat.error("EPPEmailFwdPendActionMsg.equals(): super class not equal");
            return false;
        }
        EPPEmailFwdPendActionMsg theComp = (EPPEmailFwdPendActionMsg)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            cat.error("EPPEmailFwdPendActionMsg.equals(): name not equal");
            return false;
        }
        if (this.success != theComp.success) {
            cat.error("EPPEmailFwdPendActionMsg.equals(): success not equal");
            return false;
        }
        if (!(this.pendingTransId != null ? this.pendingTransId.equals(theComp.pendingTransId) : theComp.pendingTransId == null)) {
            cat.error("EPPEmailFwdPendActionMsg.equals(): pendingTransId not equal");
            return false;
        }
        if (!(this.pendingDate != null ? this.pendingDate.equals(theComp.pendingDate) : theComp.pendingDate == null)) {
            cat.error("EPPEmailFwdPendActionMsg.equals(): pendingDate not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPEmailFwdPendActionMsg clone = (EPPEmailFwdPendActionMsg)super.clone();
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            cat.error("EPPEmailFwdPendActionMsg.validateState(): required attribute name is not set");
            throw new EPPCodecException("required attribute name is not set");
        }
        if (this.pendingTransId == null) {
            cat.error("EPPEmailFwdPendActionMsg.validateState(): required attribute pendingTransId is not set");
            throw new EPPCodecException("required attribute pendingTransId is not set");
        }
        if (this.pendingDate == null) {
            cat.error("EPPEmailFwdPendActionMsg.validateState(): required attribute pendingDate is not set");
            throw new EPPCodecException("required attribute pendingDate is not set");
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPEmailFwdPendActionMsg.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.nic.name/epp/emailFwd-1.0", ELM_NAME);
        root.setAttribute("xmlns:emailFwd", "http://www.nic.name/epp/emailFwd-1.0");
        Element nameElm = aDocument.createElementNS("http://www.nic.name/epp/emailFwd-1.0", ELM_DOMAIN_NAME);
        root.appendChild(nameElm);
        if (this.success) {
            nameElm.setAttribute(ATTR_RESULT, "1");
        } else {
            nameElm.setAttribute(ATTR_RESULT, "0");
        }
        Text textNode = aDocument.createTextNode(this.name);
        nameElm.appendChild(textNode);
        EPPUtil.encodeComp(aDocument, root, this.pendingTransId);
        EPPUtil.encodeTimeInstant(aDocument, root, this.pendingDate, "http://www.nic.name/epp/emailFwd-1.0", ELM_PENDING_DATE);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        Element theNameElm = EPPUtil.getElementByTagNameNS(aElement, "http://www.nic.name/epp/emailFwd-1.0", ELM_DOMAIN_NAME);
        this.name = theNameElm.getFirstChild().getNodeValue();
        String resultStr = theNameElm.getAttribute(ATTR_RESULT);
        this.success = resultStr.equals("1");
        this.pendingTransId = (EPPTransId)EPPUtil.decodeComp(aElement, "http://www.nic.name/epp/emailFwd-1.0", ELM_PATRID, EPPTransId.class);
        this.pendingDate = EPPUtil.decodeTimeInstant(aElement, "http://www.nic.name/epp/emailFwd-1.0", ELM_PENDING_DATE);
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPDecodeException("Invalid state on EPPEmailFwdPendActionMsg.decode: " + e);
        }
    }
}

