/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.domain;

import com.verisign.epp.codec.domain.EPPDomainContact;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPHostAttr;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Date;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPDomainInfoResp
extends EPPResponse {
    public static final String ELM_LOCALNAME = "infData";
    public static final String ELM_NAME = "domain:infData";
    public static final String CONTACT_TYPE_ADMIN = "admin";
    public static final String CONTACT_TYPE_TECH = "tech";
    public static final String CONTACT_TYPE_BILLING = "billing";
    private static final String ELM_DOMAIN_NAME = "name";
    private static final String ELM_STATUS = "status";
    private static final String ELM_CONTACT = "contact";
    private static final String ELM_CLID = "clID";
    private static final String ELM_CRDATE = "crDate";
    private static final String ELM_CRID = "crID";
    private static final String ELM_EXDATE = "exDate";
    private static final String ELM_HOST = "host";
    private static final String ELM_NS = "ns";
    private static final String ELM_HOST_OBJ = "hostObj";
    private static final String ELM_HOST_ATTR = "domain:hostAttr";
    private static final String ELM_REGISTRANT = "registrant";
    private static final String ELM_ROID = "roid";
    private static final String ELM_TRDATE = "trDate";
    private static final String ELM_UPDATE = "upDate";
    private static final String ELM_UPID = "upID";
    private static Logger cat = LoggerFactory.getLogger(EPPDomainInfoResp.class);
    private String name = null;
    private String clientId = null;
    private Vector<EPPDomainContact> contacts = new Vector();
    private String createdBy = null;
    private Date createdDate = null;
    private Date expirationDate = null;
    private String lastUpdatedBy = null;
    private Date lastUpdatedDate = null;
    private Date lastTransferDate = null;
    private EPPAuthInfo authInfo = null;
    private String registrant = null;
    private Vector<String> hosts = new Vector();
    private Vector<String> nses = new Vector();
    private Vector<EPPHostAttr> nsAttrs = new Vector();
    private Vector<EPPDomainStatus> statuses = new Vector();
    private String roid = null;

    public EPPDomainInfoResp() {
    }

    public EPPDomainInfoResp(EPPTransId aTransId, String aRoid, String aName, String aClientId, Vector<EPPDomainStatus> aStatuses, String aCreatedBy, Date aCreatedDate, EPPAuthInfo aAuthInfo) {
        super(aTransId);
        this.name = aName;
        this.roid = aRoid;
        this.clientId = aClientId;
        this.setStatuses(aStatuses);
        this.createdBy = aCreatedBy;
        this.createdDate = aCreatedDate;
        this.authInfo = aAuthInfo;
        if (this.authInfo != null) {
            this.authInfo.setRootName("urn:ietf:params:xml:ns:domain-1.0", "domain:authInfo");
        }
    }

    public boolean hasHosts() {
        return !this.hosts.isEmpty();
    }

    public Vector<String> getHosts() {
        return this.hosts;
    }

    public void setHosts(Vector<String> aHosts) {
        this.hosts = aHosts == null ? new Vector() : aHosts;
    }

    public void addHost(String aHost) {
        if (aHost != null) {
            this.hosts.add(aHost);
        }
    }

    public boolean hasNses() {
        return !this.nses.isEmpty();
    }

    public Vector<String> getNses() {
        return this.nses;
    }

    public void setNses(Vector<String> aServers) {
        this.nses = aServers == null ? new Vector() : aServers;
    }

    public void addNs(String aNs) {
        if (aNs != null) {
            this.nses.add(aNs);
        }
    }

    public boolean hasNsAttrs() {
        return !this.nsAttrs.isEmpty();
    }

    public Vector<EPPHostAttr> getNsAttrs() {
        return this.nsAttrs;
    }

    public void setNsAttrs(Vector<EPPHostAttr> aServers) {
        this.nsAttrs = aServers == null ? new Vector() : aServers;
    }

    public void addNsAttr(EPPHostAttr aNsAttr) {
        if (aNsAttr != null) {
            this.nsAttrs.add(aNsAttr);
        }
    }

    public boolean hasStatuses() {
        return !this.statuses.isEmpty();
    }

    public Vector<EPPDomainStatus> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(Vector<EPPDomainStatus> aStatuses) {
        this.statuses = aStatuses == null ? new Vector() : aStatuses;
    }

    public void addStatus(EPPDomainStatus aStatus) {
        if (aStatus != null) {
            this.statuses.add(aStatus);
        }
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:domain-1.0";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPDomainInfoResp)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPDomainInfoResp theInfoData = (EPPDomainInfoResp)aObject;
        if (!(this.name != null ? this.name.equals(theInfoData.name) : theInfoData.name == null)) {
            return false;
        }
        if (!(this.roid != null ? this.roid.equals(theInfoData.roid) : theInfoData.roid == null)) {
            return false;
        }
        if (!(this.clientId != null ? this.clientId.equals(theInfoData.clientId) : theInfoData.clientId == null)) {
            return false;
        }
        if (!EPPUtil.equalVectors(this.statuses, theInfoData.statuses)) {
            return false;
        }
        if (!(this.registrant != null ? this.registrant.equals(theInfoData.registrant) : theInfoData.registrant == null)) {
            return false;
        }
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0") && !EPPUtil.equalVectors(this.contacts, theInfoData.contacts)) {
            return false;
        }
        if (!EPPUtil.equalVectors(this.nses, theInfoData.nses)) {
            return false;
        }
        if (!EPPUtil.equalVectors(this.nsAttrs, theInfoData.nsAttrs)) {
            return false;
        }
        if (!EPPUtil.equalVectors(this.hosts, theInfoData.hosts)) {
            return false;
        }
        if (!(this.createdBy != null ? this.createdBy.equals(theInfoData.createdBy) : theInfoData.createdBy == null)) {
            return false;
        }
        if (!(this.createdDate != null ? this.createdDate.equals(theInfoData.createdDate) : theInfoData.createdDate == null)) {
            return false;
        }
        if (!(this.expirationDate != null ? this.expirationDate.equals(theInfoData.expirationDate) : theInfoData.expirationDate == null)) {
            return false;
        }
        if (!(this.lastUpdatedBy != null ? this.lastUpdatedBy.equals(theInfoData.lastUpdatedBy) : theInfoData.lastUpdatedBy == null)) {
            return false;
        }
        if (!(this.lastUpdatedDate != null ? this.lastUpdatedDate.equals(theInfoData.lastUpdatedDate) : theInfoData.lastUpdatedDate == null)) {
            return false;
        }
        if (!(this.lastTransferDate != null ? this.lastTransferDate.equals(theInfoData.lastTransferDate) : theInfoData.lastTransferDate == null)) {
            return false;
        }
        return this.authInfo != null ? this.authInfo.equals(theInfoData.authInfo) : theInfoData.authInfo == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPDomainInfoResp clone = (EPPDomainInfoResp)super.clone();
        clone.statuses = (Vector)this.statuses.clone();
        if (this.contacts != null) {
            clone.contacts = (Vector)this.contacts.clone();
        }
        if (this.nses != null) {
            clone.nses = (Vector)this.nses.clone();
        }
        if (this.nsAttrs != null) {
            clone.nsAttrs = (Vector)this.nsAttrs.clone();
        }
        if (this.hosts != null) {
            clone.hosts = (Vector)this.hosts.clone();
        }
        if (this.authInfo != null) {
            clone.authInfo = (EPPAuthInfo)this.authInfo.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String aClientId) {
        this.clientId = aClientId;
    }

    public boolean hasContacts() {
        return !this.contacts.isEmpty();
    }

    public Vector<EPPDomainContact> getContacts() {
        if (this.contacts.isEmpty()) {
            return null;
        }
        return this.contacts;
    }

    public EPPDomainContact getContactByType(String aType) {
        if (this.contacts != null) {
            for (EPPDomainContact contact : this.contacts) {
                if (contact == null || !contact.getType().equals(aType)) continue;
                return contact;
            }
        }
        return null;
    }

    public boolean hasAdminContact() {
        return this.getAdminContact() != null;
    }

    public EPPDomainContact getAdminContact() {
        return this.getContactByType(CONTACT_TYPE_ADMIN);
    }

    public boolean hasTechContact() {
        return this.getTechContact() != null;
    }

    public EPPDomainContact getTechContact() {
        return this.getContactByType(CONTACT_TYPE_TECH);
    }

    public boolean hasBillingContact() {
        return this.getBillingContact() != null;
    }

    public EPPDomainContact getBillingContact() {
        return this.getContactByType(CONTACT_TYPE_BILLING);
    }

    public void setContacts(Vector<EPPDomainContact> aContacts) {
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            this.contacts = aContacts == null ? new Vector() : aContacts;
        }
    }

    public void addContact(EPPDomainContact aContact) {
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0") && aContact != null) {
            this.contacts.add(aContact);
        }
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String aCreatedBy) {
        this.createdBy = aCreatedBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date aDate) {
        this.createdDate = aDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date aExpirationDate) {
        this.expirationDate = aExpirationDate;
    }

    public boolean hasLastUpdatedBy() {
        return this.lastUpdatedBy != null;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public void setLastUpdatedBy(String aLastUpdatedBy) {
        this.lastUpdatedBy = aLastUpdatedBy;
    }

    public boolean hasLastUpdatedDate() {
        return this.lastUpdatedDate != null;
    }

    public Date getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public void setLastUpdatedDate(Date aLastUpdatedDate) {
        this.lastUpdatedDate = aLastUpdatedDate;
    }

    public boolean hasLastTransferDate() {
        return this.lastTransferDate != null;
    }

    public Date getLastTransferDate() {
        return this.lastTransferDate;
    }

    public void setLastTransferDate(Date aLastTransferDate) {
        this.lastTransferDate = aLastTransferDate;
    }

    public boolean hasAuthInfo() {
        return this.authInfo != null;
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public void setAuthInfo(EPPAuthInfo aAuthInfo) {
        this.authInfo = aAuthInfo;
        if (aAuthInfo != null) {
            this.authInfo.setRootName("urn:ietf:params:xml:ns:domain-1.0", "domain:authInfo");
        }
    }

    public boolean hasRegistrant() {
        return this.registrant != null;
    }

    public String getRegistrant() {
        return this.registrant;
    }

    public void setRegistrant(String newRegistrant) {
        this.registrant = newRegistrant;
    }

    public boolean hasRoid() {
        return this.roid != null;
    }

    public String getRoid() {
        return this.roid;
    }

    public void setRoid(String aRoid) {
        this.roid = aRoid;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error("EPPDomainInfoResp.doEncode(): Invalid state on encode: " + e);
            throw new EPPEncodeException("Invalid state on EPPDomainInfoResp.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:domain-1.0", "domain:name");
        EPPUtil.encodeString(aDocument, root, this.roid, "urn:ietf:params:xml:ns:domain-1.0", "domain:roid");
        EPPUtil.encodeCompVector(aDocument, root, this.statuses);
        if (this.registrant != null) {
            EPPUtil.encodeString(aDocument, root, this.registrant, "urn:ietf:params:xml:ns:domain-1.0", "domain:registrant");
        }
        if (this.hasContacts()) {
            if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                EPPUtil.encodeCompVector(aDocument, root, this.contacts);
            } else {
                throw new EPPEncodeException("Contacts specified when the Contact Mapping is not supported");
            }
        }
        if (this.hasNses() || this.hasNsAttrs()) {
            Element theServersElm = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", "domain:ns");
            root.appendChild(theServersElm);
            if (this.hasNses()) {
                EPPUtil.encodeVector(aDocument, theServersElm, this.nses, "urn:ietf:params:xml:ns:domain-1.0", "domain:hostObj");
            } else {
                EPPUtil.encodeCompVector(aDocument, theServersElm, this.nsAttrs);
            }
        }
        if (this.hosts != null) {
            EPPUtil.encodeVector(aDocument, root, this.hosts, "urn:ietf:params:xml:ns:domain-1.0", "domain:host");
        }
        EPPUtil.encodeString(aDocument, root, this.clientId, "urn:ietf:params:xml:ns:domain-1.0", "domain:clID");
        EPPUtil.encodeString(aDocument, root, this.createdBy, "urn:ietf:params:xml:ns:domain-1.0", "domain:crID");
        EPPUtil.encodeTimeInstant(aDocument, root, this.createdDate, "urn:ietf:params:xml:ns:domain-1.0", "domain:crDate");
        if (this.lastUpdatedBy != null) {
            EPPUtil.encodeString(aDocument, root, this.lastUpdatedBy, "urn:ietf:params:xml:ns:domain-1.0", "domain:upID");
        }
        if (this.lastUpdatedDate != null) {
            EPPUtil.encodeTimeInstant(aDocument, root, this.lastUpdatedDate, "urn:ietf:params:xml:ns:domain-1.0", "domain:upDate");
        }
        if (this.expirationDate != null) {
            EPPUtil.encodeTimeInstant(aDocument, root, this.expirationDate, "urn:ietf:params:xml:ns:domain-1.0", "domain:exDate");
        }
        if (this.lastTransferDate != null) {
            EPPUtil.encodeTimeInstant(aDocument, root, this.lastTransferDate, "urn:ietf:params:xml:ns:domain-1.0", "domain:trDate");
        }
        if (this.authInfo != null) {
            EPPUtil.encodeComp(aDocument, root, this.authInfo);
        }
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        Element theServerElm;
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_DOMAIN_NAME);
        this.roid = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_ROID);
        this.statuses = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_STATUS, EPPDomainStatus.class);
        this.registrant = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_REGISTRANT);
        this.contacts = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_CONTACT, EPPDomainContact.class);
        Element theServersElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_NS);
        if (theServersElm != null && (theServerElm = EPPUtil.getFirstElementChild(theServersElm)) != null) {
            if (theServerElm.getLocalName().equals(EPPUtil.getLocalName(ELM_HOST_OBJ))) {
                this.nses = EPPUtil.decodeVector(theServersElm, "urn:ietf:params:xml:ns:domain-1.0", ELM_HOST_OBJ);
            } else if (theServerElm.getLocalName().equals(EPPUtil.getLocalName(ELM_HOST_ATTR))) {
                this.nsAttrs = EPPUtil.decodeCompVector(theServersElm, "urn:ietf:params:xml:ns:domain-1.0", ELM_HOST_ATTR, EPPHostAttr.class);
            } else {
                throw new EPPDecodeException("EPPDomainCreateCmd.doDecode: Invalid host child element " + theServersElm.getLocalName());
            }
        }
        this.hosts = EPPUtil.decodeVector(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_HOST);
        this.clientId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_CLID);
        this.createdBy = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_CRID);
        this.createdDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_CRDATE);
        this.expirationDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_EXDATE);
        this.lastUpdatedBy = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_UPID);
        this.lastUpdatedDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_UPDATE);
        this.lastTransferDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_TRDATE);
        this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:domain-1.0", "domain:authInfo", EPPAuthInfo.class);
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            throw new EPPCodecException("name required attribute is not set");
        }
        if (this.roid == null) {
            throw new EPPCodecException("roid required attribute is not set");
        }
        if (this.clientId == null) {
            throw new EPPCodecException("clientId required attribute is not set");
        }
        if (this.hasNses() && this.hasNsAttrs()) {
            throw new EPPCodecException("both name server objects and attributes are defined");
        }
    }
}

