/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.contact;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPContactTransferResp
extends EPPResponse {
    static final String ELM_NAME = "contact:trnData";
    private static final String ELM_REQUEST_CLIENT = "contact:reID";
    private static final String ELM_ACTION_CLIENT = "contact:acID";
    private static final String ELM_TRANSFER_STATUS = "contact:trStatus";
    private static final String ELM_REQUEST_DATE = "contact:reDate";
    private static final String ELM_ACTION_DATE = "contact:acDate";
    private static final String ELM_CONTACT_ID = "contact:id";
    private String id = null;
    private String requestClient = null;
    private String actionClient = null;
    private Date requestDate = null;
    private Date actionDate = null;
    private String trStatus = null;

    public EPPContactTransferResp() {
    }

    public EPPContactTransferResp(EPPTransId aTransId, String aId) {
        super(aTransId);
        this.id = aId;
    }

    public EPPContactTransferResp(EPPTransId aTransId, String aId, String aStatus) {
        super(aTransId);
        this.id = aId;
        this.trStatus = aStatus;
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:contact-1.0";
    }

    void validateState() throws EPPCodecException {
        if (this.id == null) {
            throw new EPPCodecException("id required attribute is not set");
        }
        if (this.requestClient == null) {
            throw new EPPCodecException("requestClient required attribute is not set");
        }
        if (this.actionClient == null) {
            throw new EPPCodecException("actionClient required attribute is not set");
        }
        if (this.trStatus == null) {
            throw new EPPCodecException("trStatus required attribute is not set");
        }
        if (this.requestDate == null) {
            throw new EPPCodecException("requestDate required attribute is not set");
        }
        if (this.actionDate == null) {
            throw new EPPCodecException("actionDate required attribute is not set");
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPContactTransferResp.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_NAME);
        root.setAttribute("xmlns:contact", "urn:ietf:params:xml:ns:contact-1.0");
        EPPUtil.encodeString(aDocument, root, this.id, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_ID);
        EPPUtil.encodeString(aDocument, root, this.trStatus, "urn:ietf:params:xml:ns:contact-1.0", ELM_TRANSFER_STATUS);
        EPPUtil.encodeString(aDocument, root, this.requestClient, "urn:ietf:params:xml:ns:contact-1.0", ELM_REQUEST_CLIENT);
        EPPUtil.encodeTimeInstant(aDocument, root, this.requestDate, "urn:ietf:params:xml:ns:contact-1.0", ELM_REQUEST_DATE);
        EPPUtil.encodeString(aDocument, root, this.actionClient, "urn:ietf:params:xml:ns:contact-1.0", ELM_ACTION_CLIENT);
        EPPUtil.encodeTimeInstant(aDocument, root, this.actionDate, "urn:ietf:params:xml:ns:contact-1.0", ELM_ACTION_DATE);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.id = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_ID);
        this.trStatus = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_TRANSFER_STATUS);
        this.requestClient = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_REQUEST_CLIENT);
        this.requestDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_REQUEST_DATE);
        this.actionClient = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_ACTION_CLIENT);
        this.actionDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_ACTION_DATE);
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPContactTransferResp)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPContactTransferResp theComp = (EPPContactTransferResp)aObject;
        if (!(this.id != null ? this.id.equals(theComp.id) : theComp.id == null)) {
            return false;
        }
        if (!(this.trStatus != null ? this.trStatus.equals(theComp.trStatus) : theComp.trStatus == null)) {
            return false;
        }
        if (!(this.requestClient != null ? this.requestClient.equals(theComp.requestClient) : theComp.requestClient == null)) {
            return false;
        }
        if (!(this.requestDate != null ? this.requestDate.equals(theComp.requestDate) : theComp.requestDate == null)) {
            return false;
        }
        if (!(this.actionClient != null ? this.actionClient.equals(theComp.actionClient) : theComp.actionClient == null)) {
            return false;
        }
        return this.actionDate != null ? this.actionDate.equals(theComp.actionDate) : theComp.actionDate == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPContactTransferResp clone = (EPPContactTransferResp)super.clone();
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String aId) {
        this.id = aId;
    }

    public String getRequestClient() {
        return this.requestClient;
    }

    public void setRequestClient(String aRequestClient) {
        this.requestClient = aRequestClient;
    }

    public String getActionClient() {
        return this.actionClient;
    }

    public void setActionClient(String aActionClient) {
        this.actionClient = aActionClient;
    }

    public Date getRequestDate() {
        return this.requestDate;
    }

    public void setRequestDate(Date aRequestDate) {
        this.requestDate = aRequestDate;
    }

    public Date getActionDate() {
        return this.actionDate;
    }

    public void setActionDate(Date aActionDate) {
        this.actionDate = aActionDate;
    }

    public String getTransferStatus() {
        return this.trStatus;
    }

    public void setTransferStatus(String newTrStatus) {
        this.trStatus = newTrStatus;
    }
}

