/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.contact;

import com.verisign.epp.codec.contact.EPPContactDisclose;
import com.verisign.epp.codec.contact.EPPContactPostalDefinition;
import com.verisign.epp.codec.contact.EPPContactStatus;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPContactAddChange
implements EPPCodecComponent {
    static final short MODE_NONE = 0;
    static final short MODE_ADD = 1;
    static final short MODE_REMOVE = 2;
    static final String ELM_ADD = "contact:add";
    static final String ELM_REMOVE = "contact:rem";
    static final String ELM_CHANGE = "contact:chg";
    static final short MODE_CHANGE = 3;
    private static final String ELM_CONTACT_POSTAL_INFO = "contact:postalInfo";
    private static final String ELM_CONTACT_AUTHINFO = "contact:authInfo";
    private static final String ELM_CONTACT_DISCLOSE = "contact:disclose";
    private static final String ELM_CONTACT_EMAIL = "contact:email";
    private static final String ELM_CONTACT_FAX = "contact:fax";
    private static final String ELM_CONTACT_VOICE = "contact:voice";
    private static final String ATTR_EXT = "x";
    private static Logger cat = LoggerFactory.getLogger(EPPContactAddChange.class);
    private Vector postalContacts = new Vector();
    private EPPAuthInfo authInfo = null;
    private EPPContactDisclose disclose = null;
    private String email = null;
    private String fax = null;
    private String faxExt = null;
    private Vector statuses = null;
    private String voice = null;
    private String voiceExt = null;
    private short mode = 0;

    public EPPContactAddChange() {
    }

    public EPPContactAddChange(Vector newStatuses) {
        this.statuses = newStatuses;
    }

    public EPPContactAddChange(EPPContactPostalDefinition aPostalInfo, String aVoice, EPPAuthInfo aAuthInfo) {
        this.voice = aVoice;
        this.fax = null;
        this.email = null;
        this.addPostalInfo(aPostalInfo);
        this.setAuthInfo(aAuthInfo);
    }

    public EPPContactAddChange(EPPContactPostalDefinition aPostalInfo, String aVoice, String aFax, String aEmail, EPPAuthInfo aAuthInfo) {
        this.voice = aVoice;
        this.fax = aFax;
        this.email = aEmail;
        this.addPostalInfo(aPostalInfo);
        this.setAuthInfo(aAuthInfo);
    }

    public EPPContactAddChange(Vector aPostalInfo, String aVoice, String aFax, String aEmail, EPPAuthInfo aAuthInfo) {
        this.voice = aVoice;
        this.fax = aFax;
        this.email = aEmail;
        this.setPostalInfo(aPostalInfo);
        this.setAuthInfo(aAuthInfo);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root;
        Element currElm = null;
        Text currVal = null;
        if (this.mode == 1) {
            root = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_ADD);
        } else if (this.mode == 2) {
            root = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_REMOVE);
        } else if (this.mode == 3) {
            root = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_CHANGE);
        } else {
            throw new EPPEncodeException("Invalid EPPContactAddRemove mode of " + this.mode);
        }
        if (this.mode == 3) {
            EPPUtil.encodeCompVector(aDocument, root, this.postalContacts);
            if (this.voice != null) {
                currElm = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_VOICE);
                currVal = aDocument.createTextNode(this.voice);
                if (this.voiceExt != null) {
                    currElm.setAttribute(ATTR_EXT, this.voiceExt);
                }
                currElm.appendChild(currVal);
                root.appendChild(currElm);
            }
            if (this.fax != null) {
                currElm = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_FAX);
                currVal = aDocument.createTextNode(this.fax);
                if (this.faxExt != null) {
                    currElm.setAttribute(ATTR_EXT, this.faxExt);
                }
                currElm.appendChild(currVal);
                root.appendChild(currElm);
            }
            if (this.email != null) {
                EPPUtil.encodeString(aDocument, root, this.email, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_EMAIL);
            }
            if (this.authInfo != null) {
                EPPUtil.encodeComp(aDocument, root, this.authInfo);
            }
            EPPUtil.encodeComp(aDocument, root, this.disclose);
        } else {
            if (this.statuses == null) {
                throw new EPPEncodeException("statuses required attribute is not set");
            }
            EPPUtil.encodeCompVector(aDocument, root, this.statuses);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element currElm = null;
        if (aElement.getLocalName().equals(EPPUtil.getLocalName(ELM_ADD))) {
            this.mode = 1;
        } else if (aElement.getLocalName().equals(EPPUtil.getLocalName(ELM_REMOVE))) {
            this.mode = (short)2;
        } else if (aElement.getLocalName().equals(EPPUtil.getLocalName(ELM_CHANGE))) {
            this.mode = (short)3;
        } else {
            throw new EPPDecodeException("Invalid EPPContactAddRemove mode of " + aElement.getLocalName());
        }
        if (this.mode == 3) {
            this.postalContacts = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_POSTAL_INFO, EPPContactPostalDefinition.class);
            this.voice = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_VOICE);
            if (this.voice != null) {
                currElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_VOICE);
                this.voiceExt = currElm.getAttribute(ATTR_EXT);
                if (this.voiceExt.length() == 0) {
                    this.voiceExt = null;
                }
            } else {
                this.voiceExt = null;
            }
            this.fax = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_FAX);
            if (this.fax != null) {
                currElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_FAX);
                this.faxExt = currElm.getAttribute(ATTR_EXT);
                if (this.faxExt.length() == 0) {
                    this.faxExt = null;
                }
            } else {
                this.faxExt = null;
            }
            this.email = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_EMAIL);
            this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_AUTHINFO, EPPAuthInfo.class);
            this.disclose = (EPPContactDisclose)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_DISCLOSE, EPPContactDisclose.class);
        } else {
            this.statuses = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:contact-1.0", "contact:status", EPPContactStatus.class);
        }
    }

    public boolean equals(Object aObject) {
        cat.debug("equals(Object): enter");
        if (!(aObject instanceof EPPContactAddChange)) {
            cat.error("equals(Object): aObject not EPPContactAddChange");
            return false;
        }
        EPPContactAddChange theComp = (EPPContactAddChange)aObject;
        if (this.mode != theComp.mode) {
            cat.error("equals(Object): mode not equal");
            return false;
        }
        if (!EPPUtil.equalVectors(this.statuses, theComp.statuses)) {
            cat.error("equals(Object): statuses not equal");
            return false;
        }
        if (!EPPUtil.equalVectors(this.postalContacts, theComp.postalContacts)) {
            cat.error("equals(Object): postalContacts not equal");
            return false;
        }
        if (!(this.voice != null ? this.voice.equals(theComp.voice) : theComp.voice == null)) {
            cat.error("equals(Object): voice not equal");
            return false;
        }
        if (!(this.voiceExt != null ? this.voiceExt.equals(theComp.voiceExt) : theComp.voiceExt == null)) {
            cat.error("equals(Object): voiceExt not equal");
            return false;
        }
        if (!(this.fax != null ? this.fax.equals(theComp.fax) : theComp.fax == null)) {
            cat.error("equals(Object): fax not equal");
            return false;
        }
        if (!(this.faxExt != null ? this.faxExt.equals(theComp.faxExt) : theComp.faxExt == null)) {
            cat.error("equals(Object): faxExt not equal");
            return false;
        }
        if (!(this.email != null ? this.email.equals(theComp.email) : theComp.email == null)) {
            cat.error("equals(Object): email not equal");
            return false;
        }
        if (!(this.authInfo != null ? this.authInfo.equals(theComp.authInfo) : theComp.authInfo == null)) {
            cat.error("equals(Object): authInfo not equal");
            return false;
        }
        if (!(this.disclose != null ? this.disclose.equals(theComp.disclose) : theComp.disclose == null)) {
            cat.error("equals(Object): disclose not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        int i;
        EPPContactAddChange clone = null;
        clone = (EPPContactAddChange)super.clone();
        if (this.statuses != null) {
            clone.statuses = (Vector)this.statuses.clone();
            for (i = 0; i < this.statuses.size(); ++i) {
                clone.statuses.setElementAt(((EPPContactStatus)this.statuses.elementAt(i)).clone(), i);
            }
        }
        if (this.postalContacts != null) {
            clone.postalContacts = (Vector)this.postalContacts.clone();
            for (i = 0; i < this.postalContacts.size(); ++i) {
                clone.postalContacts.setElementAt(((EPPContactPostalDefinition)this.postalContacts.elementAt(i)).clone(), i);
            }
        }
        if (this.authInfo != null) {
            clone.authInfo = (EPPAuthInfo)this.authInfo.clone();
        }
        if (this.disclose != null) {
            clone.disclose = (EPPContactDisclose)this.disclose.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    short getMode() {
        return this.mode;
    }

    void setMode(short aMode) {
        this.mode = aMode;
    }

    public Vector getPostalInfo() {
        return this.postalContacts;
    }

    public void setPostalInfo(Vector aPostalContacts) {
        this.postalContacts = new Vector();
        if (aPostalContacts != null) {
            for (int i = 0; i < aPostalContacts.size(); ++i) {
                if (aPostalContacts.elementAt(i) == null) continue;
                this.addPostalInfo((EPPContactPostalDefinition)aPostalContacts.elementAt(i));
            }
        }
    }

    public void addPostalInfo(EPPContactPostalDefinition aPostalInfo) {
        EPPContactPostalDefinition thePostalInfo = null;
        if (aPostalInfo != null) {
            try {
                thePostalInfo = (EPPContactPostalDefinition)aPostalInfo.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            aPostalInfo.setValidatedFlag(false);
            this.postalContacts.add(aPostalInfo);
        }
    }

    public boolean hasAuthInfo() {
        return this.authInfo != null;
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public void setAuthInfo(EPPAuthInfo aAuthInfo) {
        this.authInfo = aAuthInfo;
        if (aAuthInfo != null) {
            this.authInfo.setRootName("urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_AUTHINFO);
        }
    }

    public boolean hasDisclose() {
        return this.disclose != null;
    }

    public EPPContactDisclose getDisclose() {
        return this.disclose;
    }

    public void setDisclose(EPPContactDisclose aDisclose) {
        this.disclose = aDisclose;
        if (aDisclose != null) {
            this.disclose.setRootName(ELM_CONTACT_DISCLOSE);
        }
    }

    public boolean hasEmail() {
        return this.email != null;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String aEmail) {
        this.email = aEmail;
    }

    public boolean hasFax() {
        return this.fax != null;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String aFax) {
        this.fax = aFax;
    }

    public boolean hasFaxExt() {
        return this.faxExt != null;
    }

    public String getFaxExt() {
        return this.faxExt;
    }

    public void setFaxExt(String aFaxExt) {
        this.faxExt = aFaxExt;
    }

    public boolean hasStatuses() {
        return this.statuses != null;
    }

    public Vector getStatuses() {
        return this.statuses;
    }

    public void setStatuses(Vector aStatuses) {
        this.statuses = aStatuses;
    }

    public boolean hasVoice() {
        return this.voice != null;
    }

    public String getVoice() {
        return this.voice;
    }

    public void setVoice(String aVoice) {
        this.voice = aVoice;
    }

    public boolean hasVoiceExt() {
        return this.voiceExt != null;
    }

    public String getVoiceExt() {
        return this.voiceExt;
    }

    public void setVoiceExt(String aVoiceExt) {
        this.voiceExt = aVoiceExt;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:contact-1.0";
    }
}

