/***********************************************************
Copyright (C) 2021 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
***********************************************************/
package com.verisign.epp.codec.unhandlednamespaces.v1_0;

import java.util.Set;

import com.verisign.epp.codec.gen.EPPResponse;

/**
 * Interface that can be passed into the filter classes
 * ({@link EPPUnhandledNamespacesResponseFilter} and
 * {@link EPPUnhandledNamespacesPollMessageFilter}) to implement a customized
 * form of monitoring for returning unhandled namespace information to clients
 * and to report it to the clients out of band to EPP. The concrete
 * {@code EPPUnhandledNamespaces} should only be called if there is at least one
 * unhandled namespace identified in the filter classes.
 */
public interface EPPUnhandledNamespacesMonitor {

	/**
	 * Method called to monitor for returning unhandled namespace information to
	 * clients and to report it to the clients out of band to EPP. A form of
	 * monitoring could include logging, aggregating the logging, and reporting
	 * the returning of unhandled namespace information.
	 * 
	 * @param aOrigResponse
	 *           The original EPP response that was created without consideration
	 *           of the namespaces supported by the client.
	 * @param aFilteredResponse
	 *           The filtered EPP response that includes the filtered the
	 *           unhandled namespace XML into &lt;extValue&gt; elements.
	 * @param aNoOp
	 *           If set to {@code true}, the filter classes
	 *           ({@code EPPUnhandledNamespacesResponseFilter} and
	 *           {@code EPPUnhandledNamespacesPollMessageFilter}) are used only
	 *           to identify for the use of unhandled namespaces and
	 * @param aUnhandledNamespaces
	 *           The list of unhandled namespace URIs that were filtered into
	 *           &lt;extValue&gt; elements.
	 * @param aData
	 *           Data object passed to the filter classes
	 *           ({@code EPPUnhandledNamespacesResponseFilter} and
	 *           {@code EPPUnhandledNamespacesPollMessageFilter}).
	 */
	void monitorUnhandledNamespaces(EPPResponse aOrigResponse, EPPResponse aFilteredResponse, boolean aNoOp,
	      Set<String> aUnhandledNamespaces, Object aData);
}
