/***********************************************************
Copyright (C) 2004 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
***********************************************************/
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.exception.EPPException;

/**
 * Exception thrown when an error is recognized by one of the
 * {@code interfaces} classes. A server error response can be associated
 * with the exception. {@code hasResponse} is used to determine if there is
 * an associated error response, and {@code getResponse} is used to get the
 * error response from the exception. 
 *
 * @see com.verisign.epp.codec.gen.EPPResponse
 */
public class EPPCommandException extends EPPException {
	// Server response associated with exception

	/** EPP response associated with the {@code EPPCommandException} */
	private EPPResponse response = null;

	/**
	 * Constructs an Exception with the specified detailed message. This message
	 * should provide information about the source, reasons and any other useful
	 * facts that could justifies the reason the exception is thrown.
	 *
	 * @param aDescription
	 *           String containing a detailed message.
	 */
	public EPPCommandException(String aDescription) {
		super(aDescription);
	}

	/**
	 * Constructs an Exception with the specified detailed message. This message
	 * should provide information about the source, reasons and any other useful
	 * facts that could justifies the reason the exception is thrown.
	 *
	 * @param aDescription
	 *           String containing a detailed message.
	 * @param aCause
	 *           Cause of the {@code EPPCommandException}
	 */
	public EPPCommandException(String aDescription, Throwable aCause) {
		super(aDescription, aCause);
	}

	/**
	 * Constructs an Exception with the specified detailed message and an
	 * associated server error response. This message should provide information
	 * about the source, reasons and any other useful facts that could justifies
	 * the reason the exception is thrown.
	 *
	 * @param aDescription
	 *           String containing a detailed message.
	 * @param aCause
	 *           Cause of the {@code EPPCommandException}
	 * @param aResponse
	 *           Server error response associated with the exception
	 */
	public EPPCommandException(String aDescription, Throwable aCause, EPPResponse aResponse) {
		super(aDescription, aCause);
		response = aResponse;
	}

	/**
	 * Constructs an Exception with the specified detailed message and an
	 * associated server error response. This message should provide information
	 * about the source, reasons and any other useful facts that could justifies
	 * the reason the exception is thrown.
	 *
	 * @param aDescription
	 *           String containing a detailed message.
	 * @param aResponse
	 *           Server error response associated with the exception
	 */
	public EPPCommandException(String aDescription, EPPResponse aResponse) {
		super(aDescription);
		response = aResponse;
	}

	/**
	 * Is there a server error response associated with the exception? If
	 * {@code true}, {@code getResponse} can be used to retrieve the
	 * response.
	 *
	 * @return {@code true} if there is a response; {@code false}
	 *         otherwise.
	 */
	public boolean hasResponse() {
		if (response != null) {
			return true;
		}
		else {
			return false;
		}
	}

	/**
	 * Gets the server error response associated with the exception. If there is
	 * no associated error response, {@code null} will be returned.
	 * {@code hasResponse} can be used to determine if there is a response
	 * before calling {@code getResponse}.
	 *
	 * @return EPPResponse Server error response if defined; {@code null}
	 *         otherwise.
	 */
	public EPPResponse getResponse() {
		return response;
	}
}
