/***********************************************************
Copyright (C) 2004 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
***********************************************************/
package com.verisign.epp.codec.gen;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * Represents an EPP hello request that is sent by an EPP Client and received by
 * an EPP Server. EPP MAY be carried over both connection-oriented and
 * connection-less transport protocols. An EPP client MAY request a
 * &lt;greeting&gt; from an EPP server at any time by sending a &lt;hello&gt; to
 * a server. Use of this element is essential in a connection-less environment
 * where a server can not return a &lt;greeting&gt; in response to a
 * client-initiated connection. An EPP &lt;hello&gt; SHALL be an empty element
 * with no child elements. <br>
 * <br>
 * An {@code EPPHello} can be encoded and decoded by {@code EPPCodec}. <br>
 * <br>
 * An {@code EPPHello} request should result in the EPP Server sending back an
 * {@code EPPGreeting}.
 *
 * @see com.verisign.epp.codec.gen.EPPGreeting
 */
public class EPPHello implements EPPMessage {

	/** XML root tag name for {@code EPPHello}. */
	final static String ELM_NAME = "hello";

	/**
	 * Allocates a new {@code EPPHello}. {@code EPPHello} contains no attributes.
	 */
	public EPPHello() {
	}

	/**
	 * Gets the associated EPP namespace. The general EPP namespace is returned,
	 * which is defined as {@code EPPCodec.NS}.
	 *
	 * @return namespace URI
	 */
	public String getNamespace() {
		return EPPCodec.NS;
	}

	/**
	 * encode {@code EPPHello} into a DOM element tree. The &lt;hello&gt; element
	 * is created and returned.
	 *
	 * @param aDocument
	 *           DOM Document to create elements
	 *
	 * @return &lt;hello&gt; root element tree.
	 *
	 * @exception EPPEncodeException
	 *               Error encoding the DOM element tree.
	 */
	public Element encode(Document aDocument) throws EPPEncodeException {
		// <command>
		Element root = aDocument.createElementNS(EPPCodec.NS, ELM_NAME);

		return root;
	}

	/**
	 * decode {@code EPPHello} from a DOM element tree. The "hello" element needs
	 * to be the value of the {@code aElement} argument. Since {@code EPPHello}
	 * contains no attribute, no attributes need to be set the {@code decode}.
	 *
	 * @param aElement
	 *           &lt;hello&gt; root element tree.
	 *
	 * @exception EPPDecodeException
	 *               Error decoding the DOM element tree.
	 */
	public void decode(Element aElement) throws EPPDecodeException {
		// Do nothing since there are no attributes.
	}

	/**
	 * implements a deep {@code EPPHello} compare.
	 *
	 * @param aObject
	 *           {@code EPPHello} instance to compare with
	 *
	 * @return {@code true} if equal; {@code false} otherwise.
	 */
	public boolean equals(Object aObject) {
		if (!(aObject instanceof EPPHello)) {
			return false;
		}

		return true;
	}

	/**
	 * Clone {@code EPPHello}.
	 *
	 * @return clone of {@code EPPHello}
	 *
	 * @exception CloneNotSupportedException
	 *               standard Object.clone exception
	 */
	public Object clone() throws CloneNotSupportedException {
		EPPHello clone = null;

		clone = (EPPHello) super.clone();

		return clone;
	}

	/**
	 * Implementation of {@code Object.toString}, which will result in an
	 * indented XML {@code String} representation of the concrete
	 * {@code EPPCodecComponent}.
	 *
	 * @return Indented XML {@code String} if successful; {@code ERROR}
	 *         otherwise.
	 */
	public String toString() {
		return EPPUtil.toString(this);
	}

}
