/***********************************************************
Copyright (C) 2018 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
 ***********************************************************/

package com.verisign.epp.codec.launchpolicy.v01;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Launch Policy Create Extension that enables a client to pass the launch
 * policy information with a registry info response.
 */
public class EPPLaunchPolicyInfData extends EPPLaunchPolicyZoneContainer {

	/**
	 * Category for logging
	 */
	private static Logger cat = LoggerFactory.getLogger(EPPLaunchPolicyInfData.class);

	/**
	 * XML local name for {@code EPPLaunchPolicyInfData}.
	 */
	public static final String ELM_LOCALNAME = "infData";

	/**
	 * XML root tag for {@code EPPLaunchPolicyInfData}.
	 */
	public static final String ELM_NAME = EPPLaunchPolicyExtFactory.NS_PREFIX + ":" + ELM_LOCALNAME;

	/**
	 * Returns the local name &quot;infData&quot; for the info response
	 * extension.
	 *
	 * @return Local name &quot;infData&quot; for the info response extension.
	 */
	@Override
	protected String getLocalName() {
		return ELM_LOCALNAME;
	}

	/**
	 * Returns the {@link Logger} to use in {@link EPPLaunchPolicyZoneContainer}.
	 *
	 * @return {@link Logger} to use
	 */
	@Override
	protected Logger getLogger() {
		return cat;
	}

	/**
	 * Creates an empty {@code EPPLaunchPolicyInfData} object. {@code zone} is
	 * set to {@code null}. Use {@code setZone} to set {@code zone} attribute
	 * before sending the info response.
	 */
	public EPPLaunchPolicyInfData() {
	}

	/**
	 * Creates a new {@code EPPLaunchPolicyInfData} object that will set the
	 * launch policy for a zone.
	 *
	 * @param aZone
	 *           Instance of {@link EPPLaunchPolicyZone} to create
	 */
	public EPPLaunchPolicyInfData(EPPLaunchPolicyZone aZone) {
		super(aZone);
	}

}
