/***********************************************************
Copyright (C) 2018 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
 ***********************************************************/
package com.verisign.epp.util;

import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.verisign.epp.codec.gen.EPPFactory;

/**
 * XML parser that pre-caches the XML schemas registered in the
 * {@link EPPFactory}, but overriding the contact XML schema to use the strict
 * EPP Contact RFC 5733 XML schema "contact-1.0.xsd".
 */
public class EPPStrictContactParser extends EPPSchemaCachingParser {
	/**
	 * Name of the EPP XML Parser Pool managed by {@code GenericPoolManager}
	 */
	public static final String POOL = "EPP_STRICT_CONTACT_XML_PARSER_POOL";

	/**
	 * Category for logging
	 */
	    private static Logger cat = LoggerFactory.getLogger(EPPStrictContactParser.class);
	      

	/**
	 * Gets the XML schemas to load into the XML parser by loading the XML
	 * schemas from the {@link EPPFactory} and overriding the contact XML schema
	 * to use the strict EPP Contact RFC 5733 XML schema "contact-1.0.xsd".
	 * 
	 * @return {@link Set} of XML names to pre-load.
	 */
	@Override
	protected Set<String> getXmlSchemas() {
		cat.debug("getXmlSchemas() enter");

		Set<String> theSchemas = EPPFactory.getInstance().getXmlSchemas();
		
		if (theSchemas.contains("contact-1.0-relaxed.xsd")) {
			theSchemas.remove("contact-1.0-relaxed.xsd");
		}
		
		if (!theSchemas.contains("contact-1.0.xsd")) {
			theSchemas.add("contact-1.0.xsd");
		}

		cat.debug("getXmlSchemas() exit");

		return theSchemas;
	}

}
