/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.util;

import com.verisign.epp.exception.EPPException;
import com.verisign.epp.framework.EPPAssemblerException;
import com.verisign.epp.pool.transformer.EPPTransformerPool;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPSchemaCachingParser;
import com.verisign.epp.util.EPPSendReceiveLogger;
import com.verisign.epp.util.EPPXMLErrorHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.pool2.BaseObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EPPXMLByteArray {
    private static Logger LOG = LoggerFactory.getLogger(EPPXMLByteArray.class);
    private static Logger PACKET_LOG = LoggerFactory.getLogger((String)(EPPXMLByteArray.class.getName() + ".packet"));
    private BaseObjectPool<DocumentBuilder> parserPool = null;
    private BaseObjectPool<Transformer> transformerPool = null;
    private static EPPSendReceiveLogger sendReceiveLogger = EPPEnv.getSendReceiveLogger();

    public EPPXMLByteArray() {
    }

    public EPPXMLByteArray(BaseObjectPool<? extends DocumentBuilder> aParserPool) {
        this.parserPool = aParserPool;
        this.transformerPool = EPPTransformerPool.getInstance().getPool();
    }

    public EPPXMLByteArray(BaseObjectPool<? extends DocumentBuilder> aParserPool, BaseObjectPool<? extends Transformer> aTransformerPool) {
        this.parserPool = aParserPool;
        this.transformerPool = aTransformerPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document decode(byte[] aPacket) throws EPPAssemblerException, EPPException, IOException {
        LOG.debug("decode(): enter");
        if (aPacket == null) {
            throw new EPPException("decode(): BAD ARGUMENT (aPacket)");
        }
        DocumentBuilder theBuilder = null;
        Document theDoc = null;
        try {
            if (this.parserPool != null) {
                try {
                    theBuilder = (DocumentBuilder)this.parserPool.borrowObject();
                    theBuilder.setErrorHandler(new EPPXMLErrorHandler());
                    LOG.debug("decode(): Parser " + theBuilder + " checked out from pool");
                }
                catch (Exception ex) {
                    LOG.error("decode(): Exception borrowing parser: ", (Throwable)ex);
                    throw new EPPAssemblerException(ex.getMessage(), EPPAssemblerException.XML);
                }
            } else {
                theBuilder = new EPPSchemaCachingParser();
                theBuilder.setErrorHandler(new EPPXMLErrorHandler());
                LOG.debug("decode(): Created new EPPSchemaCachingParser");
            }
            try {
                theDoc = theBuilder.parse(new ByteArrayInputStream(aPacket));
            }
            catch (SAXParseException ex) {
                LOG.debug("decode(): [SAXParseException]", (Throwable)ex);
                throw new EPPAssemblerException(ex.getMessage(), EPPAssemblerException.XML);
            }
            catch (SAXException ex) {
                LOG.debug("decode(): [SAXException]", (Throwable)ex);
                throw new EPPAssemblerException(ex.getMessage(), EPPAssemblerException.XML);
            }
        }
        finally {
            if (this.parserPool != null) {
                try {
                    this.parserPool.returnObject((Object)theBuilder);
                    LOG.debug("decode(): Parser " + theBuilder + " returned to pool");
                }
                catch (Exception ex) {
                    LOG.error("decode(): Exception returning Parser " + theBuilder + " to pool: " + ex);
                }
            }
        }
        LOG.debug("decode(): exit");
        return theDoc;
    }

    public byte[] encode(Document aDoc) throws EPPException {
        LOG.debug("encode(): enter");
        if (aDoc == null) {
            LOG.debug("encode(): aDoc == null");
            throw new EPPException("encode(): BAD ARGUMENT (aDoc)");
        }
        ByteArrayOutputStream theBuffer = new ByteArrayOutputStream();
        Transformer trans = null;
        try {
            if (this.transformerPool != null) {
                try {
                    trans = (Transformer)this.transformerPool.borrowObject();
                    LOG.debug("encode(): Transformer " + trans + " checked out from pool");
                }
                catch (Exception ex) {
                    LOG.error("decode(): Exception borrowing transformer: ", (Throwable)ex);
                    throw new EPPException("Exception borrowing transformer: " + ex.getMessage());
                }
            } else {
                TransformerFactory transFac = TransformerFactory.newInstance();
                trans = transFac.newTransformer();
                LOG.debug("encode(): Created new Transformer");
            }
            trans.transform(new DOMSource(aDoc.getDocumentElement()), new StreamResult(theBuffer));
            theBuffer.close();
        }
        catch (Exception ex) {
            LOG.debug("encode() : serialize() :" + ex.getMessage(), (Throwable)ex);
            throw new EPPException("encode: serialize() " + ex.getMessage());
        }
        finally {
            if (this.transformerPool != null) {
                try {
                    this.transformerPool.returnObject((Object)trans);
                    LOG.debug("encode(): Transformer " + trans + " returned to pool");
                }
                catch (Exception ex) {
                    LOG.error("decode(): Exception returning Transformer " + trans + " to pool: " + ex);
                }
            }
        }
        byte[] thePacket = theBuffer.toByteArray();
        LOG.debug("encode(): exit");
        return thePacket;
    }
}

