/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.util;

import com.verisign.epp.codec.gen.EPPCodec;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.pool.parser.EPPSchemaCachingParserPool;
import com.verisign.epp.pool.transformer.EPPTransformerPool;
import com.verisign.epp.util.EPPSendReceiveLogger;
import com.verisign.epp.util.EPPXMLByteArray;
import com.verisign.epp.util.EPPXMLStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class EPPRawSendReceiveLogger
implements EPPSendReceiveLogger {
    private static Logger cat = LoggerFactory.getLogger(EPPRawSendReceiveLogger.class);
    private static Logger packetCat = LoggerFactory.getLogger((String)(EPPXMLStream.class.getName() + ".packet"));

    @Override
    public void logSend(byte[] aPacket, EPPMessage aMessage) {
        cat.debug("logSend(byte[], EPPMessage): enter");
        this.log("writePacket() : Sending [", aPacket, aMessage);
        cat.debug("logSend(byte[], EPPMessage): exit");
    }

    @Override
    public void logReceive(byte[] aPacket, EPPMessage aMessage) {
        cat.debug("logReceive(byte[], EPPMessage): enter");
        this.log("decodePacket() : Received [", aPacket, aMessage);
        cat.debug("logReceive(byte[], EPPMessage): exit");
    }

    private void log(String logPrefix, byte[] aPacket, EPPMessage aMessage) {
        cat.debug("log(byte[], EPPMessage): enter");
        if (!packetCat.isDebugEnabled()) {
            return;
        }
        if (aPacket != null) {
            packetCat.debug(logPrefix + new String(aPacket) + "]");
        } else if (aMessage != null) {
            try {
                Document theDoc = EPPCodec.getInstance().encode(aMessage);
                EPPXMLByteArray theByteArray = new EPPXMLByteArray(EPPSchemaCachingParserPool.getInstance().getPool(), EPPTransformerPool.getInstance().getPool());
                byte[] thePacket = theByteArray.encode(theDoc);
                packetCat.debug(logPrefix + new String(thePacket) + "]");
            }
            catch (EPPException ex) {
                cat.error("log(byte[], EPPMessage); Error encoding message: " + ex);
                return;
            }
        } else {
            cat.error("log(byte[], EPPMessage); Both aPacket and aMessage are null");
        }
        cat.debug("log(byte[], EPPMessage): exit");
    }

    @Override
    public EPPCodecComponent maskMessage(EPPCodecComponent aMessage) {
        return aMessage;
    }

    @Override
    public String maskString(String aString) {
        return aString;
    }
}

