/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.transport.client;

import com.verisign.epp.transport.EPPConException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPProxyServer {
    private static Logger cat = LoggerFactory.getLogger(EPPProxyServer.class);
    public static int DEFAULT_PORT = 80;
    private String serverName;
    private int serverPort = DEFAULT_PORT;

    public EPPProxyServer() {
    }

    public EPPProxyServer(String aServerName, int aServerPort) {
        this.serverName = aServerName;
        this.serverPort = aServerPort;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String aServerName) {
        this.serverName = aServerName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int aServerPort) {
        this.serverPort = aServerPort;
    }

    public void decodeConfigItem(String aConfigItem) throws EPPConException {
        cat.debug("Starting decodeConfigItem");
        Pattern pattern = Pattern.compile("^\\[?((\\p{Alnum}|:|-|\\.)+)\\]?:(\\d+)$");
        Matcher matcher = pattern.matcher(aConfigItem);
        if (!matcher.matches() || matcher.groupCount() != 3) {
            cat.error("Proxy server config item \"" + aConfigItem + "\" format is invalid");
            throw new EPPConException("Proxy server config item \"" + aConfigItem + "\" format is invalid");
        }
        this.serverName = matcher.group(1);
        this.serverPort = Integer.parseInt(matcher.group(3));
        cat.debug("Decoding proxy server, name = " + this.serverName + ", port = " + this.serverPort);
        cat.debug("Ending decodeConfigItem");
    }

    static List decodeConfig(String aConfigValue) throws EPPConException {
        cat.debug("Starting decodeConfig");
        if (aConfigValue == null) {
            cat.error("aConfigValue parameter is null");
            throw new EPPConException("ProxyServer.decodeConfig() aConfigValue parameter is null");
        }
        ArrayList<EPPProxyServer> theServers = new ArrayList<EPPProxyServer>();
        cat.debug("decodeConfig aConfigValue = " + aConfigValue);
        StringTokenizer theTokenizer = new StringTokenizer(aConfigValue, ",");
        while (theTokenizer.hasMoreTokens()) {
            String theConfigItem = theTokenizer.nextToken();
            cat.debug("Found proxy server \"" + theConfigItem + "\"");
            EPPProxyServer theServer = new EPPProxyServer();
            theServer.decodeConfigItem(theConfigItem);
            theServers.add(theServer);
        }
        cat.debug("Number of proxy servers = " + theServers.size());
        cat.debug("Ending decodeConfig");
        return theServers;
    }

    public String toString() {
        if (this.serverName != null && this.serverName.indexOf(58) != -1) {
            return "[" + this.serverName + "]:" + this.serverPort;
        }
        return this.serverName + ":" + this.serverPort;
    }
}

