/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPExtValue;
import com.verisign.epp.codec.gen.EPPGreeting;
import com.verisign.epp.codec.gen.EPPLoginCmd;
import com.verisign.epp.codec.gen.EPPPollCmd;
import com.verisign.epp.codec.gen.EPPPollMessageFilter;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPGenHandler;
import com.verisign.epp.framework.EPPPollQueueException;
import com.verisign.epp.framework.EPPPollQueueMgr;
import com.verisign.epp.serverstub.SessionData;
import com.verisign.epp.util.EPPEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenHandler
extends EPPGenHandler {
    private static final String svrTransId = "54322-XYZ";
    private static Logger cat = LoggerFactory.getLogger(GenHandler.class);
    private EPPPollMessageFilter pollMessageFilter = EPPEnv.getPollMessageFilter();

    @Override
    protected EPPEventResponse doLogin(EPPEvent aEvent, Object aData) {
        cat.debug("<<< Received Login >>>");
        SessionData sessionData = (SessionData)aData;
        EPPLoginCmd theMessage = (EPPLoginCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        if (sessionData.isLoggedIn()) {
            cat.error("Cleint already has a session established.");
            cat.error("Sending COMMAND USE ERROR for response...");
            EPPResult result = new EPPResult(2002);
            result.addExtValueReason("login command received within the bounds of an existing session");
            return new EPPEventResponse(new EPPResponse(transId, result));
        }
        EPPResponse theResponse = new EPPResponse(transId);
        cat.debug("User has logged in. Setting session data login flag to true");
        sessionData.setLoggedIn(true);
        sessionData.setLoginCmd(theMessage);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doLogout(EPPEvent aEvent, Object aData) {
        cat.debug("<<< Received Logout Command >>>");
        SessionData sessionData = (SessionData)aData;
        EPPCommand theMessage = (EPPCommand)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPResponse theResponse = new EPPResponse(transId);
        EPPEventResponse returnEventResponse = null;
        if (sessionData.isLoggedIn()) {
            cat.debug("User is invoked in logout while logged in - Good. Logging them out");
            theResponse.setResult(1500);
        } else {
            cat.debug("User is invoked in logout while NOT logged in!!!!.Sending COMMAND FAILED error...");
            theResponse.setResult(2500);
        }
        returnEventResponse = new EPPEventResponse(theResponse);
        sessionData.setLogoutOccured(true);
        return returnEventResponse;
    }

    @Override
    protected EPPEventResponse doPoll(EPPEvent aEvent, Object aData) {
        SessionData sessionData = (SessionData)aData;
        EPPPollCmd theMessage = (EPPPollCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPResponse theResponse = null;
        EPPPollQueueMgr theMgr = EPPPollQueueMgr.getInstance();
        if (theMessage.getOp().equals("req")) {
            cat.debug("doPoll: Poll request received");
            try {
                theResponse = theMgr.get(null, aData);
                cat.debug("doPoll: Got poll message [" + theResponse + "]");
                if (this.pollMessageFilter != null && theResponse.getResult().getCode() == 1301) {
                    this.pollMessageFilter.filter(theResponse, sessionData.getLoginCmd().getServices(), sessionData.getLoginCmd().getExtensionServices(), true, aData);
                    theResponse = this.pollMessageFilter.filter(theResponse, sessionData.getLoginCmd().getServices(), sessionData.getLoginCmd().getExtensionServices(), aData);
                }
            }
            catch (EPPPollQueueException ex) {
                EPPResult theResult;
                if (ex.getType() == 1) {
                    cat.debug("doPoll: Queue is empty");
                    theResult = new EPPResult(1300);
                } else {
                    cat.error("doPoll: Unexpected queue exception: " + ex);
                    theResult = new EPPResult(2400);
                }
                theResponse = new EPPResponse(transId, theResult);
            }
            catch (EPPException ex) {
                cat.error("doPoll: Unexpected queue exception: " + ex);
                EPPResult theResult = new EPPResult(2400);
                theResponse = new EPPResponse(transId, theResult);
            }
        } else if (theMessage.getOp().equals("ack")) {
            String msgId = theMessage.getMsgID();
            cat.debug("doPoll: Poll ack received for message " + msgId);
            if (msgId.equals("CLOSE-SESSION-TEST")) {
                sessionData.setLogoutOccured(true);
                return null;
            }
            try {
                theResponse = theMgr.delete(null, msgId, null);
            }
            catch (EPPPollQueueException ex) {
                cat.error("doPoll: Error deleting message " + msgId);
                EPPResult theResult = new EPPResult(2303);
                theResult.addExtValue(new EPPExtValue("Message could not be found", "<epp:poll msgID=\"" + msgId + "\" op=\"ack\"/>"));
                theResponse = new EPPResponse(transId, theResult);
            }
        } else {
            cat.error("doPoll: Invalid operation " + theMessage.getOp());
            EPPResult theResult = new EPPResult(2001);
            theResult.addExtValueReason("op=" + theMessage.getOp());
            theResponse = new EPPResponse(transId, theResult);
        }
        theResponse.setTransId(transId);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doHello(EPPEvent aEvent, Object aData) {
        SessionData sessionData = (SessionData)aData;
        EPPGreeting greeting = sessionData.getGreeting();
        return new EPPEventResponse(greeting);
    }
}

