/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.pool.parser;

import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPXMLSignatureSchemaCachingParser;
import org.apache.commons.pool2.BaseObjectPool;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.SoftReferenceObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPXMLSignatureParserPool {
    private static Logger cat = LoggerFactory.getLogger(EPPXMLSignatureParserPool.class);
    private static EPPXMLSignatureParserPool instance = new EPPXMLSignatureParserPool();
    private SoftReferenceObjectPool<EPPXMLSignatureSchemaCachingParser> pool = null;

    public static EPPXMLSignatureParserPool getInstance() {
        return instance;
    }

    private EPPXMLSignatureParserPool() {
        cat.info("EPPXMLSignatureParserPool: initializing pool with " + EPPEnv.getXMLSignatureParserPoolSize() + " parsers");
        this.pool = new SoftReferenceObjectPool((PooledObjectFactory)new EPPXMLSignatureParserPoolFactory());
        try {
            this.pool.addObjects(EPPEnv.getXMLSignatureParserPoolSize());
        }
        catch (Exception ex) {
            cat.error("EPPXMLSignatureParserPool: Exception initializing the EPPXMLSignatureParserPool: " + ex);
        }
        cat.info("EPPXMLSignatureParserPool: pool initialized");
    }

    public BaseObjectPool<EPPXMLSignatureSchemaCachingParser> getPool() {
        return this.pool;
    }

    private static class EPPXMLSignatureParserPoolFactory
    extends BasePooledObjectFactory<EPPXMLSignatureSchemaCachingParser> {
        private static Logger cat = LoggerFactory.getLogger(EPPXMLSignatureParserPoolFactory.class);

        private EPPXMLSignatureParserPoolFactory() {
        }

        public void activateObject(PooledObject<EPPXMLSignatureSchemaCachingParser> aParser) throws Exception {
            cat.debug("Parser activating from the pool: " + aParser);
            super.activateObject(aParser);
        }

        public void destroyObject(PooledObject<EPPXMLSignatureSchemaCachingParser> aParser) throws Exception {
            cat.debug("Parser being deleted from the pool: " + aParser);
            super.destroyObject(aParser);
        }

        public void passivateObject(PooledObject<EPPXMLSignatureSchemaCachingParser> aParser) throws Exception {
            cat.debug("Parser being passivated in the pool: " + aParser);
            super.passivateObject(aParser);
        }

        public EPPXMLSignatureSchemaCachingParser create() throws Exception {
            EPPXMLSignatureSchemaCachingParser theParser = new EPPXMLSignatureSchemaCachingParser();
            cat.debug("Parser created for the pool: " + theParser);
            return theParser;
        }

        public PooledObject<EPPXMLSignatureSchemaCachingParser> wrap(EPPXMLSignatureSchemaCachingParser aParser) {
            return new DefaultPooledObject((Object)aParser);
        }
    }
}

