/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces.launchpolicy.v01;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyCreate;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyInfData;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyInfoPhase;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyPhase;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyPhaseStatus;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyPollPolicy;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyUpdate;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyZone;
import com.verisign.epp.codec.registry.v02.EPPRegistryBatchJob;
import com.verisign.epp.codec.registry.v02.EPPRegistryCheckResp;
import com.verisign.epp.codec.registry.v02.EPPRegistryCheckResult;
import com.verisign.epp.codec.registry.v02.EPPRegistryContact;
import com.verisign.epp.codec.registry.v02.EPPRegistryCreateResp;
import com.verisign.epp.codec.registry.v02.EPPRegistryDomain;
import com.verisign.epp.codec.registry.v02.EPPRegistryHost;
import com.verisign.epp.codec.registry.v02.EPPRegistryInfoCmd;
import com.verisign.epp.codec.registry.v02.EPPRegistryInfoResp;
import com.verisign.epp.codec.registry.v02.EPPRegistryServices;
import com.verisign.epp.codec.registry.v02.EPPRegistryServicesExt;
import com.verisign.epp.codec.registry.v02.EPPRegistryZone;
import com.verisign.epp.codec.registry.v02.EPPRegistryZoneName;
import com.verisign.epp.codec.registry.v02.EPPRegistryZoneSummary;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.interfaces.registry.v02.EPPRegistry;
import com.verisign.epp.interfaces.registry.v02.EPPRegistryTst;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.security.SecureRandom;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPLaunchPolicyRegistryTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static Logger cat = LoggerFactory.getLogger(EPPLaunchPolicyRegistryTst.class);
    private EPPRegistry registry = null;
    private EPPSession session = null;
    private int iteration = 0;
    private Random rd = new SecureRandom();

    public EPPLaunchPolicyRegistryTst(String name) {
        super(name);
    }

    public void testRegistry() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            try {
                numIterations = Integer.parseInt(iterationsStr);
                numIterations = numIterations < 1 ? 1 : numIterations;
            }
            catch (Exception e) {
                numIterations = 1;
            }
        }
        this.printStart("Test Suite");
        this.registryCreate("launchpolicytst", true);
        this.registryUpdate("launchpolicytst", true);
        this.registryInfo(EPPRegistryInfoCmd.Mode.name, "launchpolicytst", null);
        this.registryDelete("launchpolicytst", true);
        this.printEnd("Test Suite");
    }

    public void registryCheck(Map aZoneNames) {
        this.printStart("registryCheck");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.print("registryCheck:");
            this.registry.setTransId("ABC-12345-XYZ");
            Iterator it = aZoneNames.entrySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next().getKey();
                System.out.print(" " + name + " ");
                this.registry.addZone(name);
            }
            System.out.println("");
            EPPRegistryCheckResp response = this.registry.sendCheck();
            System.out.println("registryCheck: Response = [" + response + "]\n\n");
            block3: for (Map.Entry entry : aZoneNames.entrySet()) {
                String name = (String)entry.getKey();
                Boolean available = (Boolean)entry.getValue();
                for (EPPRegistryCheckResult element : response.getCheckResults()) {
                    EPPRegistryCheckResult result = element;
                    if (!result.getName().equals(name)) continue;
                    if (result.isAvailable().booleanValue() == available.booleanValue()) continue block3;
                    EPPLaunchPolicyRegistryTst.fail((String)("Expected availability for tld \"" + name + "\": " + available + ", but got: " + result.isAvailable()));
                }
            }
            EPPLaunchPolicyRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("registryCheck");
    }

    public void registryCreate(String aZoneName, boolean aShouldSucceed) {
        block4: {
            this.printStart("registryCreate");
            EPPRegistryCreateResp response = null;
            try {
                System.out.println("\n----------------------------------------------------------------");
                System.out.println("registryCreate: " + aZoneName);
                this.registry.setTransId("ABC-12345-XYZ");
                this.registry.setZone(this.buildZoneInfo(new EPPRegistryZoneName(aZoneName)));
                EPPLaunchPolicyCreate launchPolicyExt = new EPPLaunchPolicyCreate(EPPLaunchPolicyRegistryTst.buildLaunchPolicyZone());
                this.registry.addExtension(launchPolicyExt);
                response = this.registry.sendCreate();
                System.out.println("registryCreate: Response = [" + response + "]\n\n");
                if (aShouldSucceed) {
                    EPPLaunchPolicyRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
                } else {
                    EPPLaunchPolicyRegistryTst.fail((String)"Expecting error in response");
                }
            }
            catch (EPPCommandException e) {
                if (!aShouldSucceed) break block4;
                this.handleException(e);
            }
        }
        this.printEnd("registryCreate");
    }

    public void registryDelete(String aZoneName, boolean aShouldSucceed) {
        block4: {
            this.printStart("registryDelete");
            EPPResponse response = null;
            try {
                System.out.println("\n----------------------------------------------------------------");
                System.out.println("registryDelete: " + aZoneName);
                this.registry.setTransId("ABC-12345-XYZ");
                this.registry.addZone(aZoneName);
                response = this.registry.sendDelete();
                System.out.println("registryDelete: Response = [" + response + "]\n\n");
                if (aShouldSucceed) {
                    EPPLaunchPolicyRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
                } else {
                    EPPLaunchPolicyRegistryTst.fail((String)"Expecting error in response");
                }
            }
            catch (EPPCommandException e) {
                if (!aShouldSucceed) break block4;
                this.handleException(e);
            }
        }
        this.printEnd("registryDelete");
    }

    public void registryUpdate(String aZoneName, boolean aShouldSucceed) {
        block4: {
            this.printStart("registryUpdate");
            EPPResponse response = null;
            try {
                System.out.println("\n----------------------------------------------------------------");
                System.out.println("registryUpdate: " + aZoneName);
                this.registry.setTransId("ABC-12345-XYZ");
                this.registry.setZone(this.buildZoneInfo(new EPPRegistryZoneName(aZoneName)));
                EPPLaunchPolicyUpdate launchPolicyExt = new EPPLaunchPolicyUpdate(EPPLaunchPolicyRegistryTst.buildLaunchPolicyZone());
                this.registry.addExtension(launchPolicyExt);
                response = this.registry.sendUpdate();
                System.out.println("registryUpdate: Response = [" + response + "]\n\n");
                if (aShouldSucceed) {
                    EPPLaunchPolicyRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
                } else {
                    EPPLaunchPolicyRegistryTst.fail((String)"Expecting error in response");
                }
            }
            catch (EPPCommandException e) {
                if (!aShouldSucceed) break block4;
                this.handleException(e);
            }
        }
        this.printEnd("registryUpdate");
    }

    public void registryInfo(EPPRegistryInfoCmd.Mode aMode, String aZoneName, EPPRegistryInfoCmd.Scope aScope) {
        this.printStart("registryInfo");
        EPPRegistryInfoResp response = null;
        try {
            switch (aMode) {
                case name: {
                    if (aZoneName == null) {
                        Assert.fail((String)"aZoneName must not be null with the name info mode");
                    }
                    this.registry.setTransId("ABC-12345-XYZ");
                    this.registry.addZone(aZoneName);
                    response = this.registry.sendInfo();
                    EPPLaunchPolicyRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
                    EPPLaunchPolicyRegistryTst.assertTrue((response.getZoneList() == null && response.getZoneInfo() != null ? 1 : 0) != 0);
                    System.out.println("Zone accessible = " + response.getZoneInfo().isAccessible());
                    EPPRegistryZone info = response.getZoneInfo().getZone();
                    System.out.println("Zone name: " + info.getName());
                    if (info.getServices() != null) {
                        System.out.println("Services:");
                        Iterator<EPPRegistryServices.EPPRegistryObjURI> iterator = info.getServices().getObjURIs().iterator();
                        while (iterator.hasNext()) {
                            EPPRegistryServices.EPPRegistryObjURI element;
                            EPPRegistryServices.EPPRegistryObjURI objUri = element = iterator.next();
                            System.out.println("\tobjURI: " + objUri.getUri() + ", required: " + objUri.getRequired());
                        }
                    }
                    if (info.getServices() != null && info.getServices().getExtension() != null) {
                        System.out.println("Services extension:");
                        for (Object extUri : info.getServices().getExtension().getExtURIs()) {
                            System.out.println("\textURI: " + ((EPPRegistryServices.EPPRegistryURI)extUri).getUri() + ", required: " + ((EPPRegistryServices.EPPRegistryURI)extUri).getRequired());
                        }
                    }
                    System.out.println("crId: " + info.getCreatedBy());
                    System.out.println("crDate: " + info.getCreatedDate());
                    System.out.println("upId: " + info.getLastUpdatedBy());
                    System.out.println("upDate: " + info.getLastUpdatedDate());
                    if (info.hasBatchJobs()) {
                        List<EPPRegistryBatchJob> jobs = info.getBatchJobs();
                        for (EPPRegistryBatchJob currJob : jobs) {
                            System.out.println("batchJob: " + currJob);
                        }
                    }
                    info.getBatchJobs();
                    EPPRegistryDomain domain = info.getDomain();
                    EPPLaunchPolicyRegistryTst.assertTrue((domain != null ? 1 : 0) != 0);
                    System.out.println("Domain: " + domain);
                    EPPRegistryHost host = info.getHost();
                    EPPLaunchPolicyRegistryTst.assertTrue((host != null ? 1 : 0) != 0);
                    EPPRegistryContact contact = info.getContact();
                    EPPLaunchPolicyRegistryTst.assertTrue((contact != null ? 1 : 0) != 0);
                    EPPLaunchPolicyInfData launchPolicyExt = (EPPLaunchPolicyInfData)response.getExtension(EPPLaunchPolicyInfData.class);
                    EPPLaunchPolicyRegistryTst.assertTrue((launchPolicyExt != null ? 1 : 0) != 0);
                    if (launchPolicyExt == null) break;
                    System.out.println("Launch Policy Zone: " + launchPolicyExt.getZone());
                    break;
                }
                case all: {
                    if (aScope == null) {
                        Assert.fail((String)"aScope must not be null with the all info mode");
                    }
                    this.registry.setTransId("ABC-12345-XYZ");
                    this.registry.setAllScope(EPPRegistryInfoCmd.Scope.both);
                    response = this.registry.sendInfo();
                    EPPLaunchPolicyRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
                    EPPLaunchPolicyRegistryTst.assertTrue((response.getZoneList() != null && response.getZoneList().getZoneList() != null && response.getZoneInfo() == null && response.getZoneList().getZoneList().size() > 0 ? 1 : 0) != 0);
                    System.out.println("All TLDs: ");
                    for (EPPRegistryZoneSummary tld : response.getZoneList().getZoneList()) {
                        EPPLaunchPolicyRegistryTst.assertTrue((tld.getName().getName() != null && tld.getName().getName().length() > 0 ? 1 : 0) != 0);
                        EPPLaunchPolicyRegistryTst.assertTrue((tld.getCreateDate() != null ? 1 : 0) != 0);
                        System.out.print(tld.getName() + "\tcreated on " + tld.getCreateDate());
                        if (tld.getUpdateDate() != null) {
                            System.out.println("\tupdated on " + tld.getUpdateDate());
                            continue;
                        }
                        System.out.println();
                    }
                    break;
                }
                case system: {
                    this.registry.setTransId("ABC-12345-XYZ");
                    this.registry.setInfoMode(aMode);
                    response = this.registry.sendInfo();
                    EPPLaunchPolicyRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
                    System.out.println("System Info Response = " + response);
                }
            }
            this.printEnd("registryInfo");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
    }

    public String makeZoneName() {
        int len = this.rd.nextInt(15);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            sb.append(97 + this.rd.nextInt(26));
        }
        return sb.toString();
    }

    public void handleException(Exception aException) {
        EPPResponse theResponse = null;
        if (aException instanceof EPPCommandException) {
            theResponse = ((EPPCommandException)aException).getResponse();
        }
        aException.printStackTrace();
        if (theResponse != null && !theResponse.isSuccess()) {
            Assert.fail((String)("Server Error : " + theResponse));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPLaunchPolicyRegistryTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.registry = new EPPRegistry(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start");
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private EPPRegistryZone buildZoneInfo(EPPRegistryZoneName aZone) {
        EPPRegistryZone theZoneInfo = new EPPRegistryZone(aZone);
        theZoneInfo.setDomain(EPPRegistryTst.buildDomain(false, false));
        theZoneInfo.setHost(EPPRegistryTst.buildHost(true));
        theZoneInfo.setContact(EPPRegistryTst.buildContact());
        EPPRegistryServices services = new EPPRegistryServices();
        services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:registry-1.2", Boolean.TRUE));
        services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:registry-1.1", Boolean.FALSE));
        EPPRegistryServicesExt svcExt = new EPPRegistryServicesExt();
        services.setExtension(svcExt);
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("urn:ietf:params:xml:ns:registry-1.2", Boolean.TRUE));
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("urn:ietf:params:xml:ns:registry-1.1", Boolean.FALSE));
        theZoneInfo.setServices(services);
        theZoneInfo.setCreatedBy("crId");
        theZoneInfo.setCreatedDate(new Date());
        return theZoneInfo;
    }

    public static EPPLaunchPolicyZone buildLaunchPolicyZone() {
        EPPLaunchPolicyZone zone = new EPPLaunchPolicyZone();
        EPPLaunchPolicyPhase sunrise = new EPPLaunchPolicyPhase(EPPLaunchPolicyPhase.Phase.sunrise, new GregorianCalendar(2017, 11, 1, 0, 0).getTime());
        sunrise.setMode(EPPLaunchPolicyPhase.Mode.pendingApplication);
        sunrise.setEndDate(new GregorianCalendar(2017, 12, 1, 0, 0).getTime());
        sunrise.setValidatePhase(true);
        sunrise.addValidatorId("tmch");
        sunrise.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.pendingAllocation));
        sunrise.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.allocated));
        sunrise.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.rejected));
        sunrise.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.custom, "test", null, "test status"));
        sunrise.addMarkValidation(EPPLaunchPolicyPhase.MarkValidation.signedMark);
        sunrise.setMaxMarks(1);
        sunrise.addSignedMarkSupported("urn:ietf:params:xml:ns:signedMark-1.0");
        sunrise.addEncodedSignedMarkSupported("urn:ietf:params:xml:ns:signedMark-1.0");
        sunrise.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.sunrise));
        sunrise.addCreateForm(EPPLaunchPolicyPhase.CreateForm.sunrise);
        sunrise.setCreateValidateType(true);
        zone.addPhase(sunrise);
        EPPLaunchPolicyPhase lrp1 = new EPPLaunchPolicyPhase(EPPLaunchPolicyPhase.Phase.claims, new GregorianCalendar(2017, 12, 1, 0, 0).getTime());
        lrp1.setName("lrp1");
        lrp1.setMode(EPPLaunchPolicyPhase.Mode.pendingRegistration);
        lrp1.setEndDate(new GregorianCalendar(2017, 12, 8, 0, 0).getTime());
        lrp1.setValidatePhase(true);
        lrp1.addValidatorId("tmch");
        lrp1.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.pendingValidation));
        lrp1.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.allocated));
        lrp1.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.rejected));
        lrp1.setPendingCreate(true);
        lrp1.addCheckForm(EPPLaunchPolicyPhase.CheckForm.claims);
        lrp1.addCheckForm(EPPLaunchPolicyPhase.CheckForm.availability);
        lrp1.addCheckForm(EPPLaunchPolicyPhase.CheckForm.trademark);
        lrp1.addMarkValidation(EPPLaunchPolicyPhase.MarkValidation.signedMark);
        lrp1.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.sunrise));
        lrp1.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.claims, "lrp1"));
        lrp1.addCreateForm(EPPLaunchPolicyPhase.CreateForm.claims);
        lrp1.setCreateValidateType(true);
        zone.addPhase(lrp1);
        EPPLaunchPolicyPhase landrush = new EPPLaunchPolicyPhase(EPPLaunchPolicyPhase.Phase.claims, new GregorianCalendar(2017, 12, 8, 0, 0).getTime());
        landrush.setName("landrush");
        landrush.setMode(EPPLaunchPolicyPhase.Mode.pendingApplication);
        landrush.setEndDate(new GregorianCalendar(2017, 12, 15, 0, 0).getTime());
        landrush.setValidatePhase(true);
        landrush.addValidatorId("tmch");
        landrush.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.pendingAllocation));
        landrush.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.allocated));
        landrush.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.rejected));
        landrush.setPendingCreate(true);
        landrush.setPollPolicy(new EPPLaunchPolicyPollPolicy(false, false, false));
        landrush.addCheckForm(EPPLaunchPolicyPhase.CheckForm.claims);
        landrush.addCheckForm(EPPLaunchPolicyPhase.CheckForm.availability);
        landrush.addCheckForm(EPPLaunchPolicyPhase.CheckForm.trademark);
        landrush.addMarkValidation(EPPLaunchPolicyPhase.MarkValidation.signedMark);
        landrush.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.sunrise));
        landrush.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.claims, "lrp1"));
        landrush.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.claims, "landrush"));
        landrush.addCreateForm(EPPLaunchPolicyPhase.CreateForm.claims);
        landrush.setCreateValidateType(true);
        zone.addPhase(landrush);
        EPPLaunchPolicyPhase claims = new EPPLaunchPolicyPhase(EPPLaunchPolicyPhase.Phase.claims, new GregorianCalendar(2017, 12, 15, 0, 0).getTime());
        claims.setName("open");
        claims.setMode(EPPLaunchPolicyPhase.Mode.fcfs);
        claims.setEndDate(new GregorianCalendar(2018, 2, 15, 0, 0).getTime());
        claims.setValidatePhase(true);
        claims.addValidatorId("tmch");
        claims.addCheckForm(EPPLaunchPolicyPhase.CheckForm.claims);
        claims.addCheckForm(EPPLaunchPolicyPhase.CheckForm.availability);
        claims.addCheckForm(EPPLaunchPolicyPhase.CheckForm.trademark);
        claims.addMarkValidation(EPPLaunchPolicyPhase.MarkValidation.signedMark);
        claims.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.claims, "landrush"));
        claims.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.claims, "open"));
        claims.addCreateForm(EPPLaunchPolicyPhase.CreateForm.claims);
        claims.addCreateForm(EPPLaunchPolicyPhase.CreateForm.general);
        claims.setCreateValidateType(true);
        zone.addPhase(claims);
        EPPLaunchPolicyPhase lrp2 = new EPPLaunchPolicyPhase(EPPLaunchPolicyPhase.Phase.custom, new GregorianCalendar(2018, 2, 15, 0, 0).getTime());
        lrp2.setName("lrp2");
        lrp2.setMode(EPPLaunchPolicyPhase.Mode.pendingRegistration);
        lrp2.setEndDate(new GregorianCalendar(2018, 3, 15, 0, 0).getTime());
        lrp2.setValidatePhase(true);
        lrp2.addValidatorId("lrp2-custom");
        lrp2.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.custom, "pendingInternalValidation"));
        lrp2.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.allocated));
        lrp2.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.rejected));
        lrp2.setPendingCreate(true);
        lrp2.setPollPolicy(new EPPLaunchPolicyPollPolicy(true, false, false));
        lrp2.addCheckForm(EPPLaunchPolicyPhase.CheckForm.claims);
        lrp2.addCheckForm(EPPLaunchPolicyPhase.CheckForm.availability);
        lrp2.addCheckForm(EPPLaunchPolicyPhase.CheckForm.trademark);
        lrp2.addMarkValidation(EPPLaunchPolicyPhase.MarkValidation.signedMark);
        sunrise.setMaxMarks(1);
        sunrise.addSignedMarkSupported("http://www.example.com/epp/lrp2-custom-1.0");
        sunrise.addEncodedSignedMarkSupported("http://www.example.com/epp/lrp2-custom-1.0");
        lrp2.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.claims, "open"));
        lrp2.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.custom, "lrp2"));
        lrp2.addCreateForm(EPPLaunchPolicyPhase.CreateForm.sunrise);
        lrp2.addCreateForm(EPPLaunchPolicyPhase.CreateForm.general);
        lrp2.addCreateForm(EPPLaunchPolicyPhase.CreateForm.claims);
        lrp2.addCreateForm(EPPLaunchPolicyPhase.CreateForm.mixed);
        lrp2.setCreateValidateType(true);
        zone.addPhase(lrp2);
        EPPLaunchPolicyPhase open = new EPPLaunchPolicyPhase(EPPLaunchPolicyPhase.Phase.open, new GregorianCalendar(2018, 3, 15, 0, 0).getTime());
        open.setValidatePhase(false);
        zone.addPhase(open);
        return zone;
    }
}

