/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.verificationcode.EPPEncodedSignedCode;
import com.verisign.epp.codec.verificationcode.EPPEncodedSignedCodeValue;
import com.verisign.epp.codec.verificationcode.EPPSignedCode;
import com.verisign.epp.codec.verificationcode.EPPVerificationCode;
import com.verisign.epp.codec.verificationcode.EPPVerificationCodeInfData;
import com.verisign.epp.codec.verificationcode.EPPVerificationCodeInfo;
import com.verisign.epp.codec.verificationcode.EPPVerificationCodeProfile;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPDomain;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.transport.EPPClientCon;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPVerificationCodeDomainTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static Logger cat = LoggerFactory.getLogger(EPPVerificationCodeDomainTst.class);
    private EPPDomain domain = null;
    private EPPSession session = null;
    private EPPClientCon connection = null;
    private int iteration = 0;
    private static PrivateKey privateKey;
    private static Certificate[] certChain;
    private static final String KEYSTORE_FILENAME = "verificationCode.jks";
    private static final String KEYSTORE_PASSWORD = "changeit";
    private static final String KEYSTORE_KEY_ALIAS = "verificationcode";
    private Random rd = new Random(System.currentTimeMillis());

    public EPPVerificationCodeDomainTst(String name) {
        super(name);
    }

    public void testDomain() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.domainCreate();
            this.domainInfo();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    public void domainCreate() {
        this.printStart("domainCreate");
        EPPSignedCode signedCode = null;
        EPPEncodedSignedCodeValue encodedSignedCodeValue = null;
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainCreate: Create domain with single verification code");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(this.makeDomainName());
            this.domain.setAuthString("ABC-12345");
            signedCode = new EPPSignedCode("0-abc000", "domain");
            signedCode.sign(privateKey, certChain);
            encodedSignedCodeValue = new EPPEncodedSignedCodeValue(signedCode);
            this.domain.addExtension(new EPPEncodedSignedCode(encodedSignedCodeValue));
            EPPDomainCreateResp response = this.domain.sendCreate();
            System.out.println("domainCreate: Response = [" + response + "]\n\n");
            System.out.println("domainCreate: name = " + response.getName());
            System.out.println("domainCreate: expiration date = " + response.getExpirationDate());
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainCreate: Create domain with multiple verification codes");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(this.makeDomainName());
            this.domain.setAuthString("ABC-12345");
            EPPEncodedSignedCode encodedSignedCode = new EPPEncodedSignedCode();
            signedCode = new EPPSignedCode("0-abc111", "domain");
            signedCode.sign(privateKey, certChain);
            encodedSignedCodeValue = new EPPEncodedSignedCodeValue(signedCode);
            encodedSignedCode.addCode(encodedSignedCodeValue);
            signedCode = new EPPSignedCode("0-abc222", "real-name");
            signedCode.sign(privateKey, certChain);
            encodedSignedCodeValue = new EPPEncodedSignedCodeValue(signedCode);
            encodedSignedCode.addCode(encodedSignedCodeValue);
            this.domain.addExtension(encodedSignedCode);
            response = this.domain.sendCreate();
            System.out.println("domainCreate: Response = [" + response + "]\n\n");
            System.out.println("domainCreate: name = " + response.getName());
            System.out.println("domainCreate: expiration date = " + response.getExpirationDate());
        }
        catch (EPPException e) {
            this.handleException(e);
        }
        this.printEnd("domainCreate");
    }

    private static void printVerificationInfo(String aTest, EPPVerificationCodeInfData aExt) {
        System.out.println(aTest + ": status = " + aExt.getStatus());
        if (aExt.hasProfiles()) {
            for (EPPVerificationCodeProfile profile : aExt.getProfiles()) {
                System.out.println(aTest + ": profile = " + profile.getProfileName());
                System.out.println(aTest + ": profile status = " + profile.getStatus());
                if (profile.hasMissingCodes()) {
                    for (EPPVerificationCode code : profile.getMissingCodes()) {
                        System.out.println(aTest + ": missing code type = " + code.getType() + ", due date = " + code.getDueDate());
                    }
                }
                if (!profile.hasSetCodes()) continue;
                for (EPPVerificationCode code : profile.getSetCodes()) {
                    System.out.println(aTest + ": set code type = " + code.getType() + ", date = " + code.getSetDate() + ", value = " + code.getCode());
                }
            }
        }
    }

    public void domainInfo() {
        this.printStart("domainInfo");
        try {
            for (int infoCase = 1; infoCase <= 8; ++infoCase) {
                System.out.println("\n----------------------------------------------------------------");
                System.out.println("domainInfo: Case " + infoCase + " : Status");
                this.domain.setTransId("ABC-12345-XYZ");
                this.domain.addDomainName("domain" + infoCase + ".example");
                if (infoCase % 2 == 0) {
                    this.domain.addExtension(new EPPVerificationCodeInfo());
                } else {
                    this.domain.addExtension(new EPPVerificationCodeInfo("sample"));
                }
                EPPDomainInfoResp response = this.domain.sendInfo();
                System.out.println("domainInfo: Response = [" + response + "]\n\n");
                if (!response.hasExtension(EPPVerificationCodeInfData.class)) continue;
                EPPVerificationCodeInfData theRespExt = (EPPVerificationCodeInfData)response.getExtension(EPPVerificationCodeInfData.class);
                EPPVerificationCodeDomainTst.printVerificationInfo("domainInfo - Case " + infoCase, theRespExt);
            }
        }
        catch (EPPException e) {
            this.handleException(e);
        }
        this.printEnd("domainInfo");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
        this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.domain = new EPPDomain(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPVerificationCodeDomainTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            KeyStore.PrivateKeyEntry keyEntry = EPPVerificationCodeDomainTst.loadPrivateKeyEntry(KEYSTORE_FILENAME, KEYSTORE_KEY_ALIAS, KEYSTORE_PASSWORD);
            privateKey = keyEntry.getPrivateKey();
            certChain = keyEntry.getCertificateChain();
        }
        catch (Exception ex) {
            Assert.fail((String)("Error loading keys for signing and validating: " + ex));
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public void handleException(Exception aException) {
        EPPResponse response = this.session.getResponse();
        aException.printStackTrace();
        if (response != null && !response.isSuccess()) {
            Assert.fail((String)("Server Error : " + response));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPVerificationCodeDomainTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPVerificationCodeDomainTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public String makeDomainName() {
        long tm = System.currentTimeMillis();
        return new String(Thread.currentThread() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(10) + ".com");
    }

    public String makeIP() {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10));
    }

    public String makeHostName(String newDomainName) {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(10)).substring(10) + "." + newDomainName);
    }

    public String makeContactName() {
        long tm = System.currentTimeMillis();
        return new String("Con" + String.valueOf(tm + (long)this.rd.nextInt(5)).substring(7));
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start");
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.out.println(aMsg);
            cat.info(aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.err.println(aMsg);
            cat.error(aMsg);
        }
    }

    private static KeyStore.PrivateKeyEntry loadPrivateKeyEntry(String aKeyStoreName, String aKeyAliasName, String aPassword) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream keyStoreFile = new FileInputStream(aKeyStoreName);
        keyStore.load(keyStoreFile, aPassword.toCharArray());
        assert (keyStore.isKeyEntry(aKeyAliasName));
        KeyStore.PrivateKeyEntry keyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(aKeyAliasName, new KeyStore.PasswordProtection(aPassword.toCharArray()));
        return keyEntry;
    }
}

