/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.org.EPPOrgCheckCmd;
import com.verisign.epp.codec.org.EPPOrgCheckResp;
import com.verisign.epp.codec.org.EPPOrgContact;
import com.verisign.epp.codec.org.EPPOrgCreateCmd;
import com.verisign.epp.codec.org.EPPOrgCreateResp;
import com.verisign.epp.codec.org.EPPOrgDeleteCmd;
import com.verisign.epp.codec.org.EPPOrgInfoCmd;
import com.verisign.epp.codec.org.EPPOrgInfoResp;
import com.verisign.epp.codec.org.EPPOrgPostalDefinition;
import com.verisign.epp.codec.org.EPPOrgRole;
import com.verisign.epp.codec.org.EPPOrgStatus;
import com.verisign.epp.codec.org.EPPOrgUpdateCmd;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class EPPOrg {
    private EPPSession session = null;
    private String transId = null;
    private Vector extensions = null;
    private List<String> orgIds = null;
    private String parentId = null;
    private List<EPPOrgPostalDefinition> postalInfo = null;
    private String voice = null;
    private String voiceExt = null;
    private String fax = null;
    private String faxExt = null;
    private String email = null;
    private String url = null;
    private List<EPPOrgContact> contacts = null;
    private List<EPPOrgContact> addContacts = null;
    private List<EPPOrgContact> remContacts = null;
    private List<EPPOrgRole> roles = null;
    private List<EPPOrgRole> addRoles = null;
    private List<EPPOrgRole> remRoles = null;
    private List<EPPOrgStatus> statuses = null;
    private List<EPPOrgStatus> addStatuses = null;
    private List<EPPOrgStatus> remStatuses = null;

    public EPPOrg(EPPSession aSession) {
        this.session = aSession;
    }

    public void addExtension(EPPCodecComponent aExtension) {
        if (this.extensions == null) {
            this.extensions = new Vector();
        }
        this.extensions.addElement(aExtension);
    }

    public void setExtensions(Vector aExtensions) {
        this.extensions = aExtensions;
    }

    public Vector getExtensions() {
        return this.extensions;
    }

    public void setTransId(String aTransId) {
        this.transId = aTransId;
    }

    public List<String> getOrgIds() {
        return this.orgIds;
    }

    public void addOrgId(String aOrgId) {
        if (this.orgIds == null) {
            this.orgIds = new ArrayList<String>();
        }
        this.orgIds.add(aOrgId);
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String aParentId) {
        this.parentId = aParentId;
    }

    public boolean hasPostalInfo() {
        return this.postalInfo != null && !this.postalInfo.isEmpty();
    }

    public void addPostalInfo(EPPOrgPostalDefinition aPostalInfo) {
        if (this.postalInfo == null) {
            this.postalInfo = new ArrayList<EPPOrgPostalDefinition>();
        }
        this.postalInfo.add(aPostalInfo);
    }

    public List<EPPOrgPostalDefinition> getPostalInfo() {
        return this.postalInfo;
    }

    public void setPostalInfo(List<EPPOrgPostalDefinition> aPostalInfo) {
        this.postalInfo = aPostalInfo;
    }

    public String getVoice() {
        return this.voice;
    }

    public void setVoice(String aVoice) {
        this.voice = aVoice;
    }

    public String getVoiceExt() {
        return this.voiceExt;
    }

    public void setVoiceExt(String aVoiceExt) {
        this.voiceExt = aVoiceExt;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String aFax) {
        this.fax = aFax;
    }

    public String getFaxExt() {
        return this.faxExt;
    }

    public void setFaxExt(String aFaxExt) {
        this.faxExt = aFaxExt;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String aEmail) {
        this.email = aEmail;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String aUrl) {
        this.url = aUrl;
    }

    public boolean hasContacts() {
        return this.contacts != null && !this.contacts.isEmpty();
    }

    public void addContact(EPPOrgContact aContact) {
        if (this.contacts == null) {
            this.contacts = new ArrayList<EPPOrgContact>();
        }
        this.contacts.add(aContact);
    }

    public List<EPPOrgContact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<EPPOrgContact> aContacts) {
        this.contacts = aContacts;
    }

    public void addAddContact(EPPOrgContact aContact) {
        if (this.addContacts == null) {
            this.addContacts = new ArrayList<EPPOrgContact>();
        }
        this.addContacts.add(aContact);
    }

    public List<EPPOrgContact> getAddContacts() {
        return this.addContacts;
    }

    public void setAddContacts(List<EPPOrgContact> aContacts) {
        this.addContacts = aContacts;
    }

    public boolean hasRemContacts() {
        return this.remContacts != null && !this.remContacts.isEmpty();
    }

    public void addRemContact(EPPOrgContact aContact) {
        if (this.remContacts == null) {
            this.remContacts = new ArrayList<EPPOrgContact>();
        }
        this.remContacts.add(aContact);
    }

    public List<EPPOrgContact> getRemContacts() {
        return this.remContacts;
    }

    public void setRemContacts(List<EPPOrgContact> aContacts) {
        this.remContacts = aContacts;
    }

    public void addRole(EPPOrgRole aRole) {
        if (this.roles == null) {
            this.roles = new ArrayList<EPPOrgRole>();
        }
        this.roles.add(aRole);
    }

    public List<EPPOrgRole> getRoles() {
        return this.roles;
    }

    public void setRoles(List<EPPOrgRole> aRoles) {
        this.roles = aRoles;
    }

    public boolean hasAddRoles() {
        return this.addRoles != null && !this.addRoles.isEmpty();
    }

    public void addAddRole(EPPOrgRole aRole) {
        if (this.addRoles == null) {
            this.addRoles = new ArrayList<EPPOrgRole>();
        }
        this.addRoles.add(aRole);
    }

    public List<EPPOrgRole> getAddRoles() {
        return this.addRoles;
    }

    public void setAddRoles(List<EPPOrgRole> aRoles) {
        this.addRoles = aRoles;
    }

    public boolean hasRemRoles() {
        return this.remRoles != null && !this.remRoles.isEmpty();
    }

    public void addRemRole(EPPOrgRole aRole) {
        if (this.remRoles == null) {
            this.remRoles = new ArrayList<EPPOrgRole>();
        }
        this.remRoles.add(aRole);
    }

    public List<EPPOrgRole> getRemRoles() {
        return this.remRoles;
    }

    public void setRemRoles(List<EPPOrgRole> aRoles) {
        this.remRoles = aRoles;
    }

    public void addStatus(EPPOrgStatus aStatus) {
        if (this.statuses == null) {
            this.statuses = new ArrayList<EPPOrgStatus>();
        }
        this.statuses.add(aStatus);
    }

    public List<EPPOrgStatus> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<EPPOrgStatus> aStatus) {
        this.statuses = aStatus;
    }

    public boolean hasAddStatuses() {
        return this.addStatuses != null && !this.addStatuses.isEmpty();
    }

    public void addAddStatus(EPPOrgStatus aStatus) {
        if (this.addStatuses == null) {
            this.addStatuses = new ArrayList<EPPOrgStatus>();
        }
        this.addStatuses.add(aStatus);
    }

    public List<EPPOrgStatus> getAddStatuses() {
        return this.addStatuses;
    }

    public void setAddStatuses(List<EPPOrgStatus> aStatuses) {
        this.addStatuses = aStatuses;
    }

    public boolean hasRemStatuses() {
        return this.remStatuses != null && !this.remStatuses.isEmpty();
    }

    public void addRemStatus(EPPOrgStatus aStatus) {
        if (this.remStatuses == null) {
            this.remStatuses = new ArrayList<EPPOrgStatus>();
        }
        this.remStatuses.add(aStatus);
    }

    public List<EPPOrgStatus> getRemStatuses() {
        return this.remStatuses;
    }

    public void setRemStatuses(List<EPPOrgStatus> aStatuses) {
        this.remStatuses = aStatuses;
    }

    public EPPOrgCheckResp sendCheck() throws EPPCommandException {
        if (this.orgIds == null || this.orgIds.isEmpty()) {
            throw new EPPCommandException("At least one org identifier is required for sendCheck()");
        }
        EPPOrgCheckCmd theCommand = new EPPOrgCheckCmd(this.transId);
        theCommand.setOrgIds(this.orgIds);
        theCommand.setExtensions(this.extensions);
        this.resetOrg();
        return (EPPOrgCheckResp)this.session.processDocument(theCommand, EPPOrgCheckResp.class);
    }

    public EPPOrgInfoResp sendInfo() throws EPPCommandException {
        if (this.orgIds == null || this.orgIds.size() != 1) {
            throw new EPPCommandException("One org identifier is required for sendInfo()");
        }
        EPPOrgInfoCmd theCommand = new EPPOrgInfoCmd(this.transId);
        theCommand.setOrgId(this.orgIds.get(0));
        theCommand.setExtensions(this.extensions);
        this.resetOrg();
        return (EPPOrgInfoResp)this.session.processDocument(theCommand, EPPOrgInfoResp.class);
    }

    public EPPOrgCreateResp sendCreate() throws EPPCommandException {
        if (this.orgIds == null || this.orgIds.isEmpty() || this.orgIds.size() != 1) {
            throw new EPPCommandException("A org identifier is required for sendCreate()");
        }
        if (this.roles == null || this.postalInfo.isEmpty()) {
            throw new EPPCommandException("A org role must be set");
        }
        EPPOrgCreateCmd theCommand = new EPPOrgCreateCmd(this.transId);
        theCommand.setOrgId(this.orgIds.get(0));
        theCommand.setRoles(this.roles);
        theCommand.setStatuses(this.statuses);
        theCommand.setParentId(this.parentId);
        theCommand.setPostalInfo(this.postalInfo);
        theCommand.setVoice(this.voice);
        if (this.voice != null) {
            theCommand.setVoiceExt(this.voiceExt);
        }
        theCommand.setFax(this.fax);
        if (this.fax != null) {
            theCommand.setFaxExt(this.faxExt);
        }
        theCommand.setEmail(this.email);
        theCommand.setUrl(this.url);
        theCommand.setContacts(this.contacts);
        theCommand.setExtensions(this.extensions);
        this.resetOrg();
        return (EPPOrgCreateResp)this.session.processDocument(theCommand, EPPOrgCreateResp.class);
    }

    public EPPResponse sendDelete() throws EPPCommandException {
        if (this.orgIds == null || this.orgIds.size() != 1) {
            throw new EPPCommandException("One org identifier is required for sendDelete()");
        }
        EPPOrgDeleteCmd theCommand = new EPPOrgDeleteCmd(this.transId);
        theCommand.setOrgId(this.orgIds.get(0));
        theCommand.setExtensions(this.extensions);
        this.resetOrg();
        return this.session.processDocument(theCommand, EPPResponse.class);
    }

    public EPPResponse sendUpdate() throws EPPCommandException {
        if (this.orgIds == null || this.orgIds.isEmpty() || this.orgIds.size() != 1) {
            throw new EPPCommandException("A org identifier is required for sendCreate()");
        }
        EPPOrgUpdateCmd theCommand = new EPPOrgUpdateCmd(this.transId);
        theCommand.setOrgId(this.orgIds.get(0));
        theCommand.setParentId(this.parentId);
        theCommand.setPostalInfo(this.postalInfo);
        theCommand.setVoice(this.voice);
        if (this.voice != null) {
            theCommand.setVoiceExt(this.voiceExt);
        }
        theCommand.setFax(this.fax);
        if (this.fax != null) {
            theCommand.setFaxExt(this.faxExt);
        }
        theCommand.setEmail(this.email);
        theCommand.setUrl(this.url);
        theCommand.setAddContacts(this.addContacts);
        theCommand.setRemContacts(this.remContacts);
        theCommand.setAddRoles(this.addRoles);
        theCommand.setRemRoles(this.remRoles);
        theCommand.setAddStatuses(this.addStatuses);
        theCommand.setRemStatuses(this.remStatuses);
        theCommand.setExtensions(this.extensions);
        this.resetOrg();
        return this.session.processDocument(theCommand, EPPResponse.class);
    }

    protected void resetOrg() {
        this.transId = null;
        this.extensions = null;
        this.orgIds = null;
        this.parentId = null;
        this.postalInfo = null;
        this.voice = null;
        this.voiceExt = null;
        this.fax = null;
        this.faxExt = null;
        this.email = null;
        this.url = null;
        this.contacts = null;
        this.addContacts = null;
        this.remContacts = null;
        this.roles = null;
        this.addRoles = null;
        this.remRoles = null;
        this.statuses = null;
        this.addStatuses = null;
        this.remStatuses = null;
    }

    public EPPResponse getResponse() {
        return this.session.getResponse();
    }
}

