/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPCodec;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.pool.parser.EPPSchemaCachingParserPool;
import com.verisign.epp.pool.transformer.EPPTransformerPool;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPEnvException;
import com.verisign.epp.util.EPPEnvSingle;
import com.verisign.epp.util.EnvException;
import com.verisign.epp.util.Environment;
import java.util.Properties;
import java.util.Vector;

public class EPPApplication {
    private static boolean poolsInitialized = false;
    private EPPEnvSingle env = EPPEnvSingle.getInstance();

    public void initialize(String aConfigFile, ClassLoader aClassLoader) throws EPPCommandException {
        try {
            this.env.envInitialize(aConfigFile, aClassLoader);
        }
        catch (EnvException e) {
            throw new EPPCommandException("EnvException caught :" + e.getMessage());
        }
        this.initialize();
    }

    public void initialize(Properties aProperties) throws EPPCommandException {
        Environment.setProperties(aProperties);
        this.initialize();
    }

    public void initialize(String aConfigFile) throws EPPCommandException {
        try {
            this.env.envInitialize(aConfigFile);
        }
        catch (EnvException e) {
            throw new EPPCommandException("EnvException caught :" + e.getMessage());
        }
        this.initialize();
    }

    public void initialize() throws EPPCommandException {
        try {
            Vector protocolExts = null;
            Vector commandExts = null;
            try {
                protocolExts = EPPEnv.getProtocolExtensions();
            }
            catch (EPPEnvException ex) {
                protocolExts = null;
            }
            try {
                commandExts = EPPEnv.getCmdResponseExtensions();
            }
            catch (EPPEnvException ex) {
                commandExts = null;
            }
            Vector extensionsVector = new Vector();
            if (protocolExts != null && protocolExts.elements().hasMoreElements()) {
                for (int i = 0; i < protocolExts.size(); ++i) {
                    extensionsVector.addElement(protocolExts.elementAt(i));
                }
            }
            if (commandExts != null && commandExts.elements().hasMoreElements()) {
                for (int j = 0; j < commandExts.size(); ++j) {
                    extensionsVector.addElement(commandExts.elementAt(j));
                }
            }
            EPPCodec.getInstance().init(EPPEnv.getMapFactories(), extensionsVector);
        }
        catch (EPPEnvException e) {
            throw new EPPCommandException("EPPApplication.initialze():  when initializing EPPCodec: " + e);
        }
        catch (EPPCodecException e) {
            throw new EPPCommandException("EPPApplication.initialze():  when initializing EPPCodec: " + e);
        }
        this.initXmlPools();
    }

    private void initXmlPools() {
        if (!poolsInitialized) {
            EPPSchemaCachingParserPool.getInstance();
            EPPTransformerPool.getInstance();
            poolsInitialized = true;
        }
    }

    public void endApplication() throws EPPCommandException {
    }
}

