/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework.v1_0;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceInfoCmd;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceMapFactory;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventException;
import com.verisign.epp.framework.EPPEventHandler;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EPPMaintenanceHandler
implements EPPEventHandler {
    private static Logger cat = LoggerFactory.getLogger(EPPMaintenanceHandler.class);

    public EPPMaintenanceHandler() {
        try {
            EPPFactory.getInstance().addMapFactory(EPPMaintenanceMapFactory.class.getName());
        }
        catch (EPPCodecException e) {
            cat.error("Couldn't load the Map Factory associated with the Maintenance Mapping", (Throwable)e);
            System.exit(1);
        }
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:maintenance-1.0";
    }

    @Override
    public EPPEventResponse handleEvent(EPPEvent aEvent, Object aData) throws EPPEventException {
        try {
            this.preHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        EPPMessage message = aEvent.getMessage();
        EPPEventResponse response = null;
        if (message instanceof EPPMaintenanceInfoCmd) {
            response = this.doMaintenanceInfo(aEvent, aData);
        }
        try {
            this.postHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        return response;
    }

    protected abstract EPPEventResponse doMaintenanceInfo(EPPEvent var1, Object var2);

    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }
}

