/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.codec.host.EPPHostCheckCmd;
import com.verisign.epp.codec.host.EPPHostCreateCmd;
import com.verisign.epp.codec.host.EPPHostDeleteCmd;
import com.verisign.epp.codec.host.EPPHostInfoCmd;
import com.verisign.epp.codec.host.EPPHostMapFactory;
import com.verisign.epp.codec.host.EPPHostUpdateCmd;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventException;
import com.verisign.epp.framework.EPPEventHandler;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EPPHostHandler
implements EPPEventHandler {
    private static final String NS = "urn:ietf:params:xml:ns:host-1.0";
    private static Logger cat = LoggerFactory.getLogger(EPPHostHandler.class);

    public EPPHostHandler() {
        try {
            EPPFactory.getInstance().addMapFactory(EPPHostMapFactory.class.getName());
        }
        catch (EPPCodecException e) {
            cat.error("Couldn't load the Map Factory associated with the Host Mapping", (Throwable)e);
            System.exit(1);
        }
    }

    @Override
    public final String getNamespace() {
        return NS;
    }

    @Override
    public final EPPEventResponse handleEvent(EPPEvent aEvent, Object aData) throws EPPEventException {
        EPPEventResponse response;
        try {
            this.preHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        EPPMessage message = aEvent.getMessage();
        if (message instanceof EPPHostCreateCmd) {
            response = this.doHostCreate(aEvent, aData);
        } else if (message instanceof EPPHostDeleteCmd) {
            response = this.doHostDelete(aEvent, aData);
        } else if (message instanceof EPPHostInfoCmd) {
            response = this.doHostInfo(aEvent, aData);
        } else if (message instanceof EPPHostCheckCmd) {
            response = this.doHostCheck(aEvent, aData);
        } else if (message instanceof EPPHostUpdateCmd) {
            response = this.doHostUpdate(aEvent, aData);
        } else {
            throw new EPPEventException("In EPPHostHandler an event was sent that is not supported");
        }
        try {
            this.postHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        return response;
    }

    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected abstract EPPEventResponse doHostCreate(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doHostDelete(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doHostInfo(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doHostCheck(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doHostUpdate(EPPEvent var1, Object var2);
}

