/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework;

import com.verisign.epp.codec.emailFwd.EPPEmailFwdCheckCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCreateCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdDeleteCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdInfoCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdMapFactory;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdRenewCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdTransferCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdUpdateCmd;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventException;
import com.verisign.epp.framework.EPPEventHandler;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EPPEmailFwdHandler
implements EPPEventHandler {
    private static final String NS = "http://www.nic.name/epp/emailFwd-1.0";
    private static Logger cat = LoggerFactory.getLogger(EPPEmailFwdHandler.class);

    public EPPEmailFwdHandler() {
        try {
            EPPFactory.getInstance().addMapFactory(EPPEmailFwdMapFactory.class.getName());
        }
        catch (EPPCodecException e) {
            cat.error("Couldn't load the Map Factory associated with the EmailFwd Mapping", (Throwable)e);
            System.exit(1);
        }
    }

    @Override
    public final String getNamespace() {
        return NS;
    }

    @Override
    public final EPPEventResponse handleEvent(EPPEvent aEvent, Object aData) throws EPPEventException {
        EPPEventResponse response;
        try {
            this.preHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        EPPMessage message = aEvent.getMessage();
        if (message instanceof EPPEmailFwdCreateCmd) {
            response = this.doEmailFwdCreate(aEvent, aData);
        } else if (message instanceof EPPEmailFwdCreateCmd) {
            response = this.doEmailFwdCreate(aEvent, aData);
        } else if (message instanceof EPPEmailFwdDeleteCmd) {
            response = this.doEmailFwdDelete(aEvent, aData);
        } else if (message instanceof EPPEmailFwdInfoCmd) {
            response = this.doEmailFwdInfo(aEvent, aData);
        } else if (message instanceof EPPEmailFwdCheckCmd) {
            response = this.doEmailFwdCheck(aEvent, aData);
        } else if (message instanceof EPPEmailFwdRenewCmd) {
            response = this.doEmailFwdRenew(aEvent, aData);
        } else if (message instanceof EPPEmailFwdTransferCmd) {
            response = this.doEmailFwdTransfer(aEvent, aData);
        } else if (message instanceof EPPEmailFwdUpdateCmd) {
            response = this.doEmailFwdUpdate(aEvent, aData);
        } else {
            throw new EPPEventException("In EPPEmailFwdHandler an event was sent that is not supported");
        }
        try {
            this.postHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        return response;
    }

    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected abstract EPPEventResponse doEmailFwdCreate(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doEmailFwdDelete(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doEmailFwdInfo(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doEmailFwdCheck(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doEmailFwdRenew(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doEmailFwdTransfer(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doEmailFwdUpdate(EPPEvent var1, Object var2);
}

