/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.unhandlednamespaces.v1_0;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPExtValue;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.gen.EPPValue;
import com.verisign.epp.codec.unhandlednamespaces.v1_0.EPPUnhandledNamespacesMonitor;
import com.verisign.epp.codec.unhandlednamespaces.v1_0.EPPUnhandledNamespacesMonitorLogger;
import com.verisign.epp.exception.EPPException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPUnhandledNamespacesResponseFilter {
    private static Logger cat = LoggerFactory.getLogger(EPPUnhandledNamespacesResponseFilter.class);
    private EPPUnhandledNamespacesMonitor monitor = new EPPUnhandledNamespacesMonitorLogger(cat, true);

    public EPPUnhandledNamespacesResponseFilter() {
    }

    public EPPUnhandledNamespacesResponseFilter(EPPUnhandledNamespacesMonitor aMonitor) {
        this.monitor = aMonitor;
    }

    public EPPUnhandledNamespacesMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(EPPUnhandledNamespacesMonitor monitor) {
        this.monitor = monitor;
    }

    public EPPResponse filter(EPPResponse aResponse, List<EPPService> aExtServices, Object aData) throws EPPException {
        return this.filter(aResponse, aExtServices, false, aData);
    }

    public EPPResponse filter(EPPResponse aResponse, List<EPPService> aExtServices, boolean aNoOp, Object aData) throws EPPException {
        cat.debug("filter(EPPResponse, List, boolean, Object): enter - NoOp = " + aNoOp);
        HashSet<String> theUnhandledNamespaces = new HashSet<String>();
        EPPResponse theResponse = null;
        if (aResponse == null) {
            throw new EPPException("EPPUnhandledNamespacesResponseFilter.filter(): null EPPResponse passed");
        }
        try {
            theResponse = (EPPResponse)aResponse.clone();
            Vector theExtensions = theResponse.getExtensions();
            if (theExtensions != null) {
                Iterator iterator = theExtensions.iterator();
                while (iterator.hasNext()) {
                    EPPCodecComponent theExtension = (EPPCodecComponent)iterator.next();
                    if (this.supportsNamespace(theExtension.getNamespace(), aExtServices)) continue;
                    theUnhandledNamespaces.add(theExtension.getNamespace());
                    if (!aNoOp) {
                        theResponse.getResult().addExtValue(this.createExtensionExtValue(theExtension));
                        iterator.remove();
                    }
                    cat.debug("filter(EPPResponse, List, boolean, Object): extension service [" + theExtension.getNamespace() + "] not supported");
                }
            }
        }
        catch (Exception ex) {
            cat.error("Unexpected exception: " + ex + " filtering response: " + aResponse);
            throw new EPPException("Exception filtering the response", ex);
        }
        if (this.monitor != null && !theUnhandledNamespaces.isEmpty()) {
            cat.debug("filter(EPPResponse, List, boolean, Object): At least one unhandled namespace found, calling monitor");
            this.monitor.monitorUnhandledNamespaces(aResponse, theResponse, aNoOp, theUnhandledNamespaces, aData);
        }
        cat.debug("filter(EPPResponse, List, boolean, Object): exit");
        return theResponse;
    }

    private boolean supportsNamespace(String aNamespace, List<EPPService> aServices) {
        cat.debug("supportsNamespace(String, List); Looking for namespace " + aNamespace + " support");
        if (aServices != null) {
            for (EPPService theService : aServices) {
                if (!theService.getNamespaceURI().equals(aNamespace)) continue;
                cat.debug("supportsNamespace(String, List); namespace " + aNamespace + " supported");
                return true;
            }
        }
        cat.debug("supportsNamespace(String, List); namespace " + aNamespace + " not supported");
        return false;
    }

    private EPPExtValue createExtensionExtValue(EPPCodecComponent aExtension) throws EPPException {
        EPPExtValue theExtValue = new EPPExtValue();
        DocumentImpl theDoc = new DocumentImpl();
        Element theRootElm = aExtension.encode((Document)theDoc);
        theExtValue.setValue(new EPPValue(EPPUtil.toStringNoIndent(theRootElm), theRootElm.getPrefix(), theRootElm.getNamespaceURI()));
        theExtValue.setReason(theRootElm.getNamespaceURI() + " not in login services");
        return theExtValue;
    }
}

