/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.unhandlednamespaces.v1_0;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPExtValue;
import com.verisign.epp.codec.gen.EPPPollMessageFilter;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.gen.EPPValue;
import com.verisign.epp.codec.unhandlednamespaces.v1_0.EPPUnhandledNamespacesMonitor;
import com.verisign.epp.codec.unhandlednamespaces.v1_0.EPPUnhandledNamespacesMonitorLogger;
import com.verisign.epp.exception.EPPException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EPPUnhandledNamespacesPollMessageFilter
implements EPPPollMessageFilter {
    private static Logger cat = LoggerFactory.getLogger(EPPUnhandledNamespacesPollMessageFilter.class);
    private EPPUnhandledNamespacesMonitor monitor;

    public EPPUnhandledNamespacesPollMessageFilter() {
        this.monitor = new EPPUnhandledNamespacesMonitorLogger(cat, false);
    }

    public EPPUnhandledNamespacesPollMessageFilter(EPPUnhandledNamespacesMonitor aMonitor) {
        this.monitor = aMonitor;
    }

    public EPPUnhandledNamespacesMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(EPPUnhandledNamespacesMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public EPPResponse filter(EPPResponse aResponse, List<EPPService> aServices, List<EPPService> aExtServices, Object aData) throws EPPException {
        return this.filter(aResponse, aServices, aExtServices, false, aData);
    }

    @Override
    public EPPResponse filter(EPPResponse aResponse, List<EPPService> aServices, List<EPPService> aExtServices, boolean aNoOp, Object aData) throws EPPException {
        cat.debug("filter(EPPResponse, List, List, boolean, Object): enter - NoOp = " + aNoOp);
        EPPResponse theResponse = null;
        boolean theResponseFiltered = false;
        if (aResponse == null) {
            throw new EPPException("EPPUnhandledNamespacesPollMessageFilter.filter(): null poll message EPPResponse passed");
        }
        if (!aResponse.hasMsgQueue()) {
            cat.debug("filter(EPPResponse, List, List, boolean, Object): exit - the response does not contain a poll message.");
            return aResponse;
        }
        HashSet<String> theUnhandledNamespaces = new HashSet<String>();
        try {
            aResponse.getMsgQueueMsg();
            if (!aResponse.getClass().getName().equals(EPPResponse.class.getName())) {
                if (!this.supportsNamespace(aResponse.getNamespace(), aServices)) {
                    theUnhandledNamespaces.add(aResponse.getNamespace());
                    if (!aNoOp) {
                        theResponseFiltered = true;
                        EPPExtValue theExtValue = this.createObjectExtValue(aResponse);
                        EPPResult theResult = (EPPResult)aResponse.getResult().clone();
                        theResult.addExtValue(theExtValue);
                        theResponse = new EPPResponse(aResponse.getTransId(), theResult);
                        theResponse.setMsgQueue(aResponse.getMsgQueue());
                        theResponse.setExtensions(aResponse.getExtensions());
                    } else {
                        theResponse = (EPPResponse)aResponse.clone();
                    }
                    cat.debug("filter(EPPResponse, List, List, boolean): object service [" + aResponse.getNamespace() + "] not supported");
                } else {
                    theResponse = (EPPResponse)aResponse.clone();
                }
            } else {
                theResponse = (EPPResponse)aResponse.clone();
            }
            Vector theExtensions = theResponse.getExtensions();
            if (theExtensions != null) {
                Iterator iterator = theExtensions.iterator();
                while (iterator.hasNext()) {
                    EPPCodecComponent theExtension = (EPPCodecComponent)iterator.next();
                    if (this.supportsNamespace(theExtension.getNamespace(), aExtServices)) continue;
                    theUnhandledNamespaces.add(theExtension.getNamespace());
                    if (!aNoOp) {
                        theResponseFiltered = true;
                        theResponse.getResult().addExtValue(this.createExtensionExtValue(theExtension));
                        iterator.remove();
                    }
                    cat.debug("filter(EPPResponse, List, List, boolean): extension service [" + theExtension.getNamespace() + "] not supported");
                }
            }
        }
        catch (Exception ex) {
            cat.error("Unexpected exception: " + ex + " filtering the poll message: " + aResponse);
            throw new EPPException("Exception filtering poll message", ex);
        }
        if (this.monitor != null && !theUnhandledNamespaces.isEmpty()) {
            cat.debug("filter(EPPResponse, List, boolean, Object): At least one unhandled namespace found, calling monitor");
            this.monitor.monitorUnhandledNamespaces(aResponse, theResponse, aNoOp, theUnhandledNamespaces, aData);
        }
        cat.debug("filter(EPPResponse, List, List, Object): exit");
        return theResponse;
    }

    private boolean supportsNamespace(String aNamespace, List<EPPService> aServices) {
        cat.debug("supportsNamespace(String, List); Looking for namespace " + aNamespace + " support");
        if (aServices != null) {
            for (EPPService theService : aServices) {
                if (!theService.getNamespaceURI().equals(aNamespace)) continue;
                cat.debug("supportsNamespace(String, List); namespace " + aNamespace + " supported");
                return true;
            }
        }
        cat.debug("supportsNamespace(String, List); namespace " + aNamespace + " not supported");
        return false;
    }

    private EPPExtValue createExtensionExtValue(EPPCodecComponent aExtension) throws EPPException {
        EPPExtValue theExtValue = new EPPExtValue();
        DocumentImpl theDoc = new DocumentImpl();
        Element theRootElm = aExtension.encode((Document)theDoc);
        theExtValue.setValue(new EPPValue(EPPUtil.toStringNoIndent(theRootElm), theRootElm.getPrefix(), theRootElm.getNamespaceURI()));
        theExtValue.setReason(theRootElm.getNamespaceURI() + " not in login services");
        return theExtValue;
    }

    private EPPExtValue createObjectExtValue(EPPResponse aResponse) throws EPPException {
        EPPExtValue theExtValue = new EPPExtValue();
        DocumentImpl theDoc = new DocumentImpl();
        Element theRootElm = aResponse.encode((Document)theDoc);
        NodeList theResDataElm = theRootElm.getElementsByTagNameNS("urn:ietf:params:xml:ns:epp-1.0", EPPUtil.getLocalName("resData"));
        if (theResDataElm.getLength() != 1) {
            throw new EPPException("Response does not include a <resData> element");
        }
        Element theObjectElm = EPPUtil.getFirstElementChild((Element)theResDataElm.item(0));
        if (theObjectElm == null) {
            throw new EPPException("Response object data element not found");
        }
        String theObjectXml = EPPUtil.toStringNoIndent(theObjectElm);
        theExtValue.setValue(new EPPValue(theObjectXml, theObjectElm.getPrefix(), theObjectElm.getNamespaceURI()));
        theExtValue.setReason(aResponse.getNamespace() + " not in login services");
        return theExtValue;
    }
}

