/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v02.EPPRegistrySystemInfo;
import com.verisign.epp.codec.registry.v02.EPPRegistryZoneData;
import com.verisign.epp.codec.registry.v02.EPPRegistryZoneList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryInfoResp
extends EPPResponse {
    public static final String ELM_LOCALNAME = "infData";
    public static final String ELM_NAME = "registry:infData";
    private EPPRegistryZoneList zoneList = null;
    private EPPRegistryZoneData zoneInfo = null;
    private EPPRegistrySystemInfo systemInfo = null;
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryInfoResp.class);

    public EPPRegistryInfoResp() {
    }

    public EPPRegistryInfoResp(EPPTransId aTransId, EPPRegistryZoneList aZoneList) {
        super(aTransId);
        this.zoneList = aZoneList;
        this.zoneInfo = null;
        this.systemInfo = null;
    }

    public EPPRegistryInfoResp(EPPTransId aTransId, EPPRegistryZoneData aZoneInfo) {
        super(aTransId);
        this.zoneInfo = aZoneInfo;
        this.zoneList = null;
        this.systemInfo = null;
    }

    public EPPRegistryInfoResp(EPPTransId aTransId, EPPRegistrySystemInfo aSystemInfo) {
        super(aTransId);
        this.systemInfo = aSystemInfo;
        this.zoneInfo = null;
        this.zoneList = null;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error("EPPRegistryInfoResp.doEncode(): Invalid state on encode: " + e);
            throw new EPPEncodeException("Invalid state on EPPRegistryInfoResp.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME);
        if (this.zoneList != null) {
            EPPUtil.encodeComp(aDocument, root, this.zoneList);
        }
        if (this.zoneInfo != null) {
            EPPUtil.encodeComp(aDocument, root, this.zoneInfo);
        }
        if (this.systemInfo != null) {
            EPPUtil.encodeComp(aDocument, root, this.systemInfo);
        }
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.zoneList = (EPPRegistryZoneList)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:zoneList", EPPRegistryZoneList.class);
        this.zoneInfo = (EPPRegistryZoneData)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:zone", EPPRegistryZoneData.class);
        this.systemInfo = (EPPRegistrySystemInfo)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:system", EPPRegistrySystemInfo.class);
    }

    void validateState() throws EPPCodecException {
        if (this.zoneList == null && this.zoneInfo == null && this.systemInfo == null || this.zoneList != null && this.zoneInfo != null || this.zoneList != null && this.systemInfo != null || this.zoneInfo != null && this.systemInfo != null) {
            throw new EPPCodecException("One and only one zoneList, zoneInfo, and systemInfo can exist");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryInfoResp clone = (EPPRegistryInfoResp)super.clone();
        if (this.zoneList != null) {
            clone.zoneList = (EPPRegistryZoneList)this.zoneList.clone();
        }
        if (this.zoneInfo != null) {
            clone.zoneInfo = (EPPRegistryZoneData)this.zoneInfo.clone();
        }
        if (this.systemInfo != null) {
            clone.systemInfo = (EPPRegistrySystemInfo)this.systemInfo.clone();
        }
        return clone;
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryInfoResp)) {
            return false;
        }
        EPPRegistryInfoResp theComp = (EPPRegistryInfoResp)aObject;
        if (!(this.zoneList != null ? this.zoneList.equals(theComp.zoneList) : theComp.zoneList == null)) {
            cat.error("EPPRegistryInfoResp.equals(): zoneList not equal");
            return false;
        }
        if (!(this.zoneInfo != null ? this.zoneInfo.equals(theComp.zoneInfo) : theComp.zoneInfo == null)) {
            cat.error("EPPRegistryInfoResp.equals(): zoneInfo not equal");
            return false;
        }
        if (!(this.systemInfo != null ? this.systemInfo.equals(theComp.systemInfo) : theComp.systemInfo == null)) {
            cat.error("EPPRegistryInfoResp.equals(): systemInfo not equal");
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean hasZoneList() {
        return this.zoneList != null;
    }

    public EPPRegistryZoneList getZoneList() {
        return this.zoneList;
    }

    public void setZoneList(EPPRegistryZoneList aZoneList) {
        this.zoneList = aZoneList;
    }

    public boolean hasZoneInfo() {
        return this.zoneInfo != null;
    }

    public EPPRegistryZoneData getZoneInfo() {
        return this.zoneInfo;
    }

    public void setZoneInfo(EPPRegistryZoneData aZoneInfo) {
        this.zoneInfo = aZoneInfo;
    }

    public boolean hasSystemInfo() {
        return this.systemInfo != null;
    }

    public EPPRegistrySystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    public void setSystemInfo(EPPRegistrySystemInfo aSystemInfo) {
        this.systemInfo = aSystemInfo;
    }
}

