/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v02.EPPRegistryExternalHost;
import com.verisign.epp.codec.registry.v02.EPPRegistryInternalHost;
import com.verisign.epp.codec.registry.v02.EPPRegistryRegex;
import com.verisign.epp.codec.registry.v02.EPPRegistrySupportedStatus;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryHost
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryHost.class);
    public static final String ELM_LOCALNAME = "host";
    public static final String ELM_NAME = "registry:host";
    public static final String ELM_NAME_REGEX = "nameRegex";
    public static final String ELM_MAX_CHECK = "maxCheckHost";
    public static final String ELM_AUTH_INFO_REGEX = "authInfoRegex";
    public static final String ELM_INVALID_IP = "invalidIP";
    private EPPRegistryInternalHost internal = null;
    private EPPRegistryExternalHost external = null;
    private EPPRegistryRegex nameRegex = null;
    private Integer maxCheckHost = null;
    private EPPRegistrySupportedStatus supportedStatus = null;
    private List<String> invalidIPs = new ArrayList<String>();

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryHost.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.internal);
        EPPUtil.encodeComp(aDocument, root, this.external);
        EPPUtil.encodeComp(aDocument, root, this.nameRegex);
        if (this.hasMaxCheckHost()) {
            EPPUtil.encodeString(aDocument, root, this.maxCheckHost.toString(), "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:maxCheckHost");
        }
        if (this.supportedStatus != null) {
            EPPUtil.encodeComp(aDocument, root, this.supportedStatus);
        }
        EPPUtil.encodeList(aDocument, root, this.invalidIPs, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:invalidIP");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.internal = (EPPRegistryInternalHost)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:internal", EPPRegistryInternalHost.class);
        this.external = (EPPRegistryExternalHost)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:external", EPPRegistryExternalHost.class);
        this.setNameRegex((EPPRegistryRegex)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME_REGEX, EPPRegistryRegex.class));
        this.maxCheckHost = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_MAX_CHECK);
        this.supportedStatus = (EPPRegistrySupportedStatus)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:supportedStatus", EPPRegistrySupportedStatus.class);
        this.invalidIPs = EPPUtil.decodeList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_INVALID_IP);
    }

    void validateState() throws EPPCodecException {
        if (this.internal == null) {
            throw new EPPCodecException("internal required element is not set");
        }
        if (this.external == null) {
            throw new EPPCodecException("external required element is not set");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryHost clone = (EPPRegistryHost)super.clone();
        if (this.internal != null) {
            clone.internal = (EPPRegistryInternalHost)this.internal.clone();
        }
        if (this.external != null) {
            clone.external = (EPPRegistryExternalHost)this.external.clone();
        }
        if (this.supportedStatus != null) {
            clone.supportedStatus = (EPPRegistrySupportedStatus)this.supportedStatus.clone();
        }
        if (this.invalidIPs != null) {
            clone.invalidIPs = (List)((ArrayList)this.invalidIPs).clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryHost)) {
            return false;
        }
        EPPRegistryHost theComp = (EPPRegistryHost)aObject;
        if (!EqualityUtil.equals(this.internal, theComp.internal)) {
            cat.error("EPPRegistryHost.equals(): internal not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.external, theComp.external)) {
            cat.error("EPPRegistryHost.equals(): external not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.nameRegex, theComp.nameRegex)) {
            cat.error("EPPRegistryHost.equals(): nameRegex not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.maxCheckHost, theComp.maxCheckHost)) {
            cat.error("EPPRegistryHost.equals(): maxCheckHost not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.supportedStatus, theComp.supportedStatus)) {
            cat.error("EPPRegistryHost.equals(): supportedStatus not equal");
            return false;
        }
        if (!(this.invalidIPs != null ? EPPUtil.equalLists(this.invalidIPs, theComp.invalidIPs) : theComp.invalidIPs == null)) {
            cat.error("EPPRegistryHost.equals(): invalidIPs not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPRegistryInternalHost getInternal() {
        return this.internal;
    }

    public void setInternal(EPPRegistryInternalHost aInternal) {
        this.internal = aInternal;
    }

    public EPPRegistryExternalHost getExternal() {
        return this.external;
    }

    public void setExternal(EPPRegistryExternalHost aExternal) {
        this.external = aExternal;
    }

    public boolean hasNameRegex() {
        return this.nameRegex != null;
    }

    public EPPRegistryRegex getNameRegex() {
        return this.nameRegex;
    }

    public void setNameRegex(EPPRegistryRegex aNameRegex) {
        if (aNameRegex != null) {
            aNameRegex.setRootName(ELM_NAME_REGEX);
        }
        this.nameRegex = aNameRegex;
    }

    public boolean hasMaxCheckHost() {
        return this.maxCheckHost != null;
    }

    public Integer getMaxCheckHost() {
        return this.maxCheckHost;
    }

    public void setMaxCheckHost(Integer aMaxCheckHost) {
        this.maxCheckHost = aMaxCheckHost;
    }

    public EPPRegistrySupportedStatus getSupportedStatus() {
        return this.supportedStatus;
    }

    public void setSupportedStatus(EPPRegistrySupportedStatus aSupportedStatus) {
        this.supportedStatus = aSupportedStatus;
    }

    public boolean hasInvalidIPs() {
        return this.invalidIPs != null && !this.invalidIPs.isEmpty();
    }

    public List<String> getInvalidIPs() {
        return this.invalidIPs;
    }

    public void setInvalidIPs(List<String> aInvalidIPs) {
        this.invalidIPs = aInvalidIPs == null ? new ArrayList<String>() : aInvalidIPs;
    }

    public void addInvalidIP(String aInvalidIP) {
        if (this.invalidIPs == null) {
            this.invalidIPs = new ArrayList<String>();
        }
        this.invalidIPs.add(aInvalidIP);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }
}

