/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v02.EPPRegistryCheckResult;
import com.verisign.epp.codec.registry.v02.EPPRegistryZoneName;
import com.verisign.epp.util.EqualityUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryCreateResp
extends EPPResponse {
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryCheckResult.class);
    public static final String ELM_LOCALNAME = "creData";
    public static final String ELM_NAME = "registry:creData";
    private static final String ELM_CREATION_DATE = "crDate";
    private EPPRegistryZoneName name = null;
    private Date createDate = null;

    public EPPRegistryCreateResp() {
    }

    public EPPRegistryCreateResp(EPPTransId aTransId, String aName) {
        super(aTransId);
        this.setName(aName);
    }

    public EPPRegistryCreateResp(EPPTransId aTransId, EPPRegistryZoneName aName) {
        super(aTransId);
        this.setName(aName);
    }

    public EPPRegistryCreateResp(EPPTransId aTransId, String aName, Date aCreateDate) {
        this(aTransId, aName);
        this.createDate = aCreateDate;
    }

    public EPPRegistryCreateResp(EPPTransId aTransId, EPPRegistryZoneName aName, Date aCreateDate) {
        this(aTransId, aName);
        this.createDate = aCreateDate;
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryCreateResp)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPRegistryCreateResp theComp = (EPPRegistryCreateResp)aObject;
        if (!EqualityUtil.equals(this.name, theComp.name)) {
            cat.error("EPPRegistryCreateResp.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.createDate, theComp.createDate)) {
            cat.error("EPPRegistryCreateResp.equals(): createDate not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryCreateResp clone = (EPPRegistryCreateResp)super.clone();
        if (this.name != null) {
            clone.name = (EPPRegistryZoneName)this.name.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            throw new EPPCodecException("name required attribute is not set");
        }
        if (this.createDate == null) {
            throw new EPPCodecException("required attribute createDate is not set");
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryCreateResp.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME);
        root.setAttribute("xmlns:registry", "urn:ietf:params:xml:ns:epp:registry-0.2");
        EPPUtil.encodeComp(aDocument, root, this.name);
        EPPUtil.encodeTimeInstant(aDocument, root, this.createDate, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_CREATION_DATE);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.name = (EPPRegistryZoneName)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "name", EPPRegistryZoneName.class);
        this.createDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_CREATION_DATE);
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPDecodeException("Invalid state on EPPRegistryCreateResp.decode: " + e);
        }
    }

    public EPPRegistryZoneName getName() {
        return this.name;
    }

    public void setName(EPPRegistryZoneName aName) {
        this.name = aName;
    }

    public void setName(String aName) {
        this.name = new EPPRegistryZoneName(aName, EPPRegistryZoneName.Form.aLabel);
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
}

