/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.org;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.org.EPPOrgRoleStatus;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPOrgRole
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPOrgRole.class);
    public static final String ELM_LOCALNAME = "role";
    public static final String ELM_NAME = "org:role";
    private static final String ATTR_ROLE_STATUS = "roleStatus";
    private static final String ELM_TYPE = "type";
    private static final String ELM_STATUS = "status";
    private static final String ELM_ROLE_ID = "roleID";
    private String type;
    private List<EPPOrgRoleStatus> statuses = new ArrayList<EPPOrgRoleStatus>();
    private String roleId;

    public EPPOrgRole() {
    }

    public EPPOrgRole(String aType) {
        this.setType(aType);
    }

    public EPPOrgRole(String aRole, List<EPPOrgRoleStatus> aStatuses) {
        this.setType(aRole);
        this.setStatuses(aStatuses);
    }

    public EPPOrgRole(String aRole, EPPOrgRoleStatus aStatus, String aRoleId) {
        this.setType(aRole);
        this.addStatus(aStatus);
        this.setRoleId(aRoleId);
    }

    public EPPOrgRole(String aRole, List<EPPOrgRoleStatus> aStatuses, String aRoleId) {
        this.setType(aRole);
        this.setStatuses(aStatuses);
        this.setRoleId(aRoleId);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String aType) {
        this.type = aType;
    }

    public boolean hasStatus() {
        return !this.statuses.isEmpty();
    }

    public List<EPPOrgRoleStatus> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<EPPOrgRoleStatus> aStatuses) {
        this.statuses = aStatuses == null ? new ArrayList<EPPOrgRoleStatus>() : aStatuses;
    }

    public void addStatus(EPPOrgRoleStatus aStatus) {
        this.statuses.add(aStatus);
    }

    public boolean hasRoleId() {
        return this.roleId != null;
    }

    public String gerRoleId() {
        return this.roleId;
    }

    public void setRoleId(String aRoleId) {
        this.roleId = aRoleId;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.type == null) {
            throw new EPPEncodeException("Undefined type in EPPOrgRole");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:org-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.type, "urn:ietf:params:xml:ns:epp:org-1.0", "org:type");
        EPPUtil.encodeList(aDocument, root, this.statuses, "urn:ietf:params:xml:ns:epp:org-1.0", "org:status");
        EPPUtil.encodeString(aDocument, root, this.roleId, "urn:ietf:params:xml:ns:epp:org-1.0", "org:roleID");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.type = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_TYPE);
        this.statuses = EPPUtil.decodeEnumList(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_STATUS, EPPOrgRoleStatus.class);
        this.roleId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_ROLE_ID);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPOrgRole clone = (EPPOrgRole)super.clone();
        clone.statuses = (List)((ArrayList)this.statuses).clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPOrgRole)) {
            return false;
        }
        EPPOrgRole other = (EPPOrgRole)aObject;
        if (!EqualityUtil.equals(this.type, other.type)) {
            cat.error("EPPOrgRole.equals(): type not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.statuses, other.statuses)) {
            cat.error("EPPOrgRole.equals(): statuses not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.roleId, other.roleId)) {
            cat.error("EPPOrgRole.equals(): roleId not equal");
            return false;
        }
        return true;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:org-1.0";
    }
}

