/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.org;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPDeleteCmd;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPOrgDeleteCmd
extends EPPDeleteCmd {
    private static Logger cat = LoggerFactory.getLogger(EPPOrgDeleteCmd.class);
    public static final String ELM_LOCALNAME = "delete";
    public static final String ELM_NAME = "org:delete";
    private static final String ELM_RESELLER_ID = "id";
    private String orgId;

    public EPPOrgDeleteCmd() {
    }

    public EPPOrgDeleteCmd(String aTransId) {
        super(aTransId);
    }

    public EPPOrgDeleteCmd(String aTransId, String aOrgId) {
        super(aTransId);
        this.orgId = aOrgId;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:org-1.0";
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String aOrgId) {
        this.orgId = aOrgId;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.orgId == null) {
            throw new EPPEncodeException("Undefined orgId in EPPOrgDeleteCmd");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:org-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.orgId, "urn:ietf:params:xml:ns:epp:org-1.0", "org:id");
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.orgId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_RESELLER_ID);
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPOrgDeleteCmd)) {
            return false;
        }
        EPPOrgDeleteCmd other = (EPPOrgDeleteCmd)aObject;
        if (!EqualityUtil.equals(this.orgId, other.orgId)) {
            cat.error("EPPOrgDeleteCmd.equals(): orgId not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPOrgDeleteCmd clone = (EPPOrgDeleteCmd)super.clone();
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }
}

