/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.org;

import com.verisign.epp.codec.gen.EPPCheckCmd;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPOrgCheckCmd
extends EPPCheckCmd {
    private static Logger cat = LoggerFactory.getLogger(EPPOrgCheckCmd.class);
    public static final String ELM_LOCALNAME = "check";
    public static final String ELM_NAME = "org:check";
    private static final String ELM_ORG_ID = "id";
    private List<String> orgIds = new ArrayList<String>();

    public EPPOrgCheckCmd() {
    }

    public EPPOrgCheckCmd(String aTransId) {
        super(aTransId);
    }

    public EPPOrgCheckCmd(String aTransId, String aOrgId) {
        super(aTransId);
        this.addOrgId(aOrgId);
    }

    public EPPOrgCheckCmd(String aTransId, List<String> aOrgIds) {
        super(aTransId);
        this.setOrgIds(aOrgIds);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:org-1.0";
    }

    public boolean hasOrgIds() {
        return this.orgIds != null && !this.orgIds.isEmpty();
    }

    public List<String> getOrgIds() {
        return this.orgIds;
    }

    public void setOrgIds(List<String> aOrgIds) {
        this.orgIds = aOrgIds == null ? new ArrayList<String>() : aOrgIds;
    }

    public void setOrgId(String aOrgId) {
        this.orgIds = new ArrayList<String>();
        this.orgIds.add(aOrgId);
    }

    public void addOrgId(String aOrgId) {
        this.orgIds.add(aOrgId);
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (!this.hasOrgIds()) {
            throw new EPPEncodeException("At least one org identifier is needed with EPPOrgCheckCmd");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:org-1.0", ELM_NAME);
        EPPUtil.encodeList(aDocument, root, this.orgIds, "urn:ietf:params:xml:ns:epp:org-1.0", "org:id");
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.orgIds = EPPUtil.decodeList(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_ORG_ID);
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPOrgCheckCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPOrgCheckCmd theMap = (EPPOrgCheckCmd)aObject;
        if (!EPPUtil.equalLists(this.orgIds, theMap.orgIds)) {
            cat.error("EPPOrgCheckCmd.equals(): orgIds not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPOrgCheckCmd clone = (EPPOrgCheckCmd)super.clone();
        clone.orgIds = (List)((ArrayList)this.orgIds).clone();
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }
}

