/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nv;

import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPInfoCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import java.security.InvalidParameterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPNameVerificationInfoCmd
extends EPPInfoCmd {
    private static Logger cat = LoggerFactory.getLogger(EPPNameVerificationInfoCmd.class);
    public static final String ELM_LOCALNAME = "info";
    public static final String ELM_NAME = "nv:info";
    private static final String ELM_CODE = "code";
    private static final String ATTR_TYPE = "type";
    private String code;
    private Type type = Type.SIGNED_CODE;
    private EPPAuthInfo authInfo;

    public EPPNameVerificationInfoCmd() {
    }

    public EPPNameVerificationInfoCmd(String aTransId) {
        super(aTransId);
    }

    public EPPNameVerificationInfoCmd(String aTransId, String aCode) {
        super(aTransId);
        this.code = aCode;
    }

    public EPPNameVerificationInfoCmd(String aTransId, String aCode, Type aType) {
        super(aTransId);
        this.code = aCode;
        this.type = aType;
    }

    public EPPNameVerificationInfoCmd(String aTransId, String aCode, Type aType, EPPAuthInfo aAuthInfo) {
        super(aTransId);
        this.code = aCode;
        this.type = aType;
        this.setAuthInfo(aAuthInfo);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:nv-1.0";
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String aCode) {
        this.code = aCode;
    }

    public Type getInfoType() {
        return this.type;
    }

    public void setInfoType(Type aType) {
        this.type = aType;
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public void setAuthInfo(EPPAuthInfo aAuthInfo) {
        if (aAuthInfo != null) {
            this.authInfo = aAuthInfo;
            this.authInfo.setRootName("urn:ietf:params:xml:ns:nv-1.0", "nv:authInfo");
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.code == null) {
            throw new EPPEncodeException("Undefined code in EPPNameVerificationInfoCmd");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", ELM_NAME);
        root.setAttribute(ATTR_TYPE, this.type.toString());
        EPPUtil.encodeString(aDocument, root, this.code, "urn:ietf:params:xml:ns:nv-1.0", "nv:code");
        if (this.authInfo != null) {
            EPPUtil.encodeComp(aDocument, root, this.authInfo);
        }
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.type = Type.getType(aElement.getAttribute(ATTR_TYPE));
        this.code = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_CODE);
        this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:nv-1.0", "nv:authInfo", EPPAuthInfo.class);
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPNameVerificationInfoCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPNameVerificationInfoCmd other = (EPPNameVerificationInfoCmd)aObject;
        if (!EqualityUtil.equals((Object)this.type, (Object)other.type)) {
            cat.error("EPPNameVerificationInfoCmd.equals(): type not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.code, other.code)) {
            cat.error("EPPNameVerificationInfoCmd.equals(): code not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.authInfo, other.authInfo)) {
            cat.error("EPPNameVerificationInfoCmd.equals(): authInfo not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPNameVerificationInfoCmd clone = (EPPNameVerificationInfoCmd)super.clone();
        clone.type = this.type;
        clone.code = this.code;
        clone.authInfo = this.authInfo != null ? (EPPAuthInfo)this.authInfo.clone() : null;
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public static enum Type {
        INPUT("input"),
        SIGNED_CODE("signedCode");

        private final String typeStr;

        private Type(String aTypeStr) {
            this.typeStr = aTypeStr;
        }

        public static Type getType(String aType) {
            if (aType == null || aType.isEmpty()) {
                return SIGNED_CODE;
            }
            if (aType.equals(Type.INPUT.typeStr)) {
                return INPUT;
            }
            if (aType.equals(Type.SIGNED_CODE.typeStr)) {
                return SIGNED_CODE;
            }
            throw new InvalidParameterException("Type enum value of " + aType + " is not valid.");
        }

        public String toString() {
            return this.typeStr;
        }
    }
}

