/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nv;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.nv.EPPNameVerificationCreateResult;
import com.verisign.epp.codec.nv.EPPNameVerificationStatus;
import com.verisign.epp.util.EqualityUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPNameVerificationCreatePending
implements EPPNameVerificationCreateResult {
    private static Logger cat = LoggerFactory.getLogger(EPPNameVerificationCreatePending.class);
    public static final String ELM_LOCALNAME = "pending";
    public static final String ELM_NAME = "nv:pending";
    private static final String ELM_CODE = "code";
    private static final String ATTR_TYPE = "type";
    private static final String ELM_STATUS = "status";
    private static final String ATTR_STATUS = "s";
    private static final String ELM_CREATION_DATE = "crDate";
    private String code;
    private String type;
    private EPPNameVerificationStatus status;
    private Date creationDate;

    public EPPNameVerificationCreatePending() {
    }

    public EPPNameVerificationCreatePending(String aCode, String aType, EPPNameVerificationStatus aStatus, Date aCrDate) {
        this.code = aCode;
        this.type = aType;
        this.status = aStatus;
        this.creationDate = aCrDate;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String aCode) {
        this.code = aCode;
    }

    public EPPNameVerificationStatus getStatus() {
        return this.status;
    }

    public void setStatus(EPPNameVerificationStatus aStatus) {
        this.status = aStatus;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date aCreationDate) {
        this.creationDate = aCreationDate;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.code == null) {
            throw new EPPEncodeException("Undefined code in EPPNameVerificationCreatePending");
        }
        if (this.status == null) {
            throw new EPPEncodeException("Undefined status in EPPNameVerificationCreatePending");
        }
        if (this.creationDate == null) {
            throw new EPPEncodeException("Undefined creationDate in EPPNameVerificationCreatePending");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", ELM_NAME);
        Element code = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", "nv:code");
        Text codeVal = aDocument.createTextNode(this.code);
        code.appendChild(codeVal);
        root.appendChild(code);
        code.setAttribute(ATTR_TYPE, this.type);
        Element theStatusElm = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", "nv:status");
        root.appendChild(theStatusElm);
        theStatusElm.setAttribute(ATTR_STATUS, this.status.toString());
        EPPUtil.encodeTimeInstant(aDocument, root, this.creationDate, "urn:ietf:params:xml:ns:nv-1.0", "nv:crDate");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.code = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_CODE);
        Element theElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_CODE);
        this.type = theElm.getAttribute(ATTR_TYPE);
        theElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_STATUS);
        String theStatusStr = theElm.getAttribute(ATTR_STATUS);
        this.status = EPPNameVerificationStatus.getStatus(theStatusStr);
        this.creationDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_CREATION_DATE);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPNameVerificationCreatePending clone = (EPPNameVerificationCreatePending)super.clone();
        clone.code = this.code;
        clone.type = this.type;
        clone.status = this.status;
        clone.creationDate = this.creationDate;
        return clone;
    }

    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:nv-1.0";
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPNameVerificationCreatePending)) {
            return false;
        }
        EPPNameVerificationCreatePending other = (EPPNameVerificationCreatePending)aObject;
        if (!EqualityUtil.equals(this.code, other.code)) {
            cat.error("EPPNameVerificationCreatePending.equals(): code not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.type, other.type)) {
            cat.error("EPPNameVerificationCreatePending.equals(): type not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.status, (Object)other.status)) {
            cat.error("EPPNameVerificationCreatePending.equals(): status not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.creationDate, other.creationDate)) {
            cat.error("EPPNameVerificationCreatePending.equals(): creationDate not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

