/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.mark;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.mark.EPPMarkContact;
import com.verisign.epp.util.EqualityUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.dom.DocumentImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPCourt
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPCourt.class);
    public static final String ELM_LOCALNAME = "court";
    public static final String ELM_NAME = "mark:court";
    private static final String ELM_ID = "id";
    private static final String ELM_MARK_NAME = "markName";
    private static final String ELM_LABEL = "label";
    private static final String ELM_GOODS_AND_SERVICES = "goodsAndServices";
    private static final String ELM_REF_NUM = "refNum";
    private static final String ELM_PRO_DATE = "proDate";
    private static final String ELM_CC = "cc";
    private static final String ELM_REGION = "region";
    private static final String ELM_COURT_NAME = "courtName";
    private String id;
    private String name;
    private List<EPPMarkContact> holders = new ArrayList<EPPMarkContact>();
    private List<EPPMarkContact> contacts = new ArrayList<EPPMarkContact>();
    private List<String> labels = new ArrayList<String>();
    private String goodsAndServices;
    private String refNum;
    private Date proDate;
    private String cc;
    private List<String> regions = new ArrayList<String>();
    private String courtName;

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPCourt clone = (EPPCourt)super.clone();
        return clone;
    }

    public byte[] encode() throws EPPEncodeException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            DocumentImpl doc = new DocumentImpl();
            Element root = this.encode((Document)doc);
            doc.appendChild(root);
            TransformerFactory transFac = TransformerFactory.newInstance();
            Transformer trans = transFac.newTransformer();
            trans.transform(new DOMSource(root), new StreamResult(os));
        }
        catch (EPPEncodeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            cat.error("Error encoding court to byte[]: " + ex);
            throw new EPPEncodeException("Error encoding court to byte[]");
        }
        return os.toByteArray();
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPCourt.encode(Document)");
        }
        if (this.id == null) {
            throw new EPPEncodeException("id is required for court");
        }
        if (this.name == null) {
            throw new EPPEncodeException("name is required for court");
        }
        if (this.holders == null || this.holders.isEmpty()) {
            throw new EPPEncodeException("one holder is required for court");
        }
        if (this.goodsAndServices == null) {
            throw new EPPEncodeException("goodsAndServices is required for court");
        }
        if (this.refNum == null) {
            throw new EPPEncodeException("refNum is required for court");
        }
        if (this.proDate == null) {
            throw new EPPEncodeException("proDate is required for court");
        }
        if (this.proDate == null) {
            throw new EPPEncodeException("proDate is required for court");
        }
        if (this.cc == null) {
            throw new EPPEncodeException("cc is required for court");
        }
        if (this.courtName == null) {
            throw new EPPEncodeException("courtName is required for court");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:mark-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.id, "urn:ietf:params:xml:ns:mark-1.0", "mark:id");
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:mark-1.0", "mark:markName");
        EPPUtil.encodeCompList(aDocument, root, this.holders);
        EPPUtil.encodeCompList(aDocument, root, this.contacts);
        EPPUtil.encodeList(aDocument, root, this.labels, "urn:ietf:params:xml:ns:mark-1.0", "mark:label");
        EPPUtil.encodeString(aDocument, root, this.goodsAndServices, "urn:ietf:params:xml:ns:mark-1.0", "mark:goodsAndServices");
        EPPUtil.encodeString(aDocument, root, this.refNum, "urn:ietf:params:xml:ns:mark-1.0", "mark:refNum");
        EPPUtil.encodeTimeInstant(aDocument, root, this.proDate, "urn:ietf:params:xml:ns:mark-1.0", "mark:proDate");
        EPPUtil.encodeString(aDocument, root, this.cc, "urn:ietf:params:xml:ns:mark-1.0", "mark:cc");
        EPPUtil.encodeList(aDocument, root, this.regions, "urn:ietf:params:xml:ns:mark-1.0", "mark:region");
        EPPUtil.encodeString(aDocument, root, this.courtName, "urn:ietf:params:xml:ns:mark-1.0", "mark:courtName");
        return root;
    }

    public void decode(byte[] aMarkArray) throws EPPDecodeException {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(aMarkArray);
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(is);
            this.decode(doc.getDocumentElement());
        }
        catch (Exception ex) {
            throw new EPPDecodeException("Error decoding court array: " + ex);
        }
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.id = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_ID);
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_MARK_NAME);
        this.holders = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:mark-1.0", "holder", EPPMarkContact.class);
        this.contacts = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:mark-1.0", "contact", EPPMarkContact.class);
        this.labels = EPPUtil.decodeList(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_LABEL);
        this.goodsAndServices = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_GOODS_AND_SERVICES);
        this.refNum = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_REF_NUM);
        this.proDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_PRO_DATE);
        this.cc = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_CC);
        this.regions = EPPUtil.decodeList(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_REGION);
        this.courtName = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_COURT_NAME);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPCourt)) {
            cat.error("EPPCourt.equals(): aObject is not an EPPCourt");
            return false;
        }
        EPPCourt other = (EPPCourt)aObject;
        if (!EqualityUtil.equals(this.id, other.id)) {
            cat.error("EPPCourt.equals(): id not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.name, other.name)) {
            cat.error("EPPCourt.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.holders, other.holders)) {
            cat.error("EPPCourt.equals(): holders not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.contacts, other.contacts)) {
            cat.error("EPPCourt.equals(): contacts not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.labels, other.labels)) {
            cat.error("EPPCourt.equals(): labels not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.goodsAndServices, other.goodsAndServices)) {
            cat.error("EPPCourt.equals(): goodsAndServices not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.refNum, other.refNum)) {
            cat.error("EPPCourt.equals(): refNum not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.proDate, other.proDate)) {
            cat.error("EPPCourt.equals(): proDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.cc, other.cc)) {
            cat.error("EPPCourt.equals(): cc not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.regions, other.regions)) {
            cat.error("EPPCourt.equals(): regions not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.courtName, other.courtName)) {
            cat.error("EPPCourt.equals(): courtName not equal");
            return false;
        }
        return true;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String aId) {
        this.id = aId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public List<EPPMarkContact> getHolders() {
        return this.holders;
    }

    public void setHolders(List<EPPMarkContact> aHolders) {
        this.holders = aHolders;
        if (this.holders == null) {
            this.holders = new ArrayList<EPPMarkContact>();
        }
        for (EPPMarkContact holder : this.holders) {
            holder.setLocalName("holder");
        }
    }

    public void addHolder(EPPMarkContact aHolder) {
        if (aHolder == null) {
            return;
        }
        aHolder.setLocalName("holder");
        if (this.holders == null) {
            this.holders = new ArrayList<EPPMarkContact>();
        }
        this.holders.add(aHolder);
    }

    public List<EPPMarkContact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<EPPMarkContact> aContacts) {
        this.contacts = aContacts;
        if (this.contacts == null) {
            this.contacts = new ArrayList<EPPMarkContact>();
        }
        for (EPPMarkContact contact : this.contacts) {
            contact.setLocalName("contact");
        }
    }

    public void addContact(EPPMarkContact aContact) {
        if (aContact == null) {
            return;
        }
        aContact.setLocalName("contact");
        if (this.contacts == null) {
            this.contacts = new ArrayList<EPPMarkContact>();
        }
        this.contacts.add(aContact);
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> aLabels) {
        this.labels = aLabels;
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
    }

    public void addLabel(String aLabel) {
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
        this.labels.add(aLabel);
    }

    public String getGoodsAndServices() {
        return this.goodsAndServices;
    }

    public void setGoodsAndServices(String aGoodsAndServices) {
        this.goodsAndServices = aGoodsAndServices;
    }

    public String getRefNum() {
        return this.refNum;
    }

    public void setRefNum(String aRefNum) {
        this.refNum = aRefNum;
    }

    public Date getProDate() {
        return this.proDate;
    }

    public void setProDate(Date aProDate) {
        this.proDate = aProDate;
    }

    public String getCc() {
        return this.cc;
    }

    public void setCc(String aCc) {
        this.cc = aCc;
    }

    public List<String> getRegions() {
        return this.regions;
    }

    public void setRegions(List<String> aRegions) {
        this.regions = aRegions;
        if (this.regions == null) {
            this.regions = new ArrayList<String>();
        }
    }

    public void addRegions(String aRegion) {
        if (this.regions == null) {
            this.regions = new ArrayList<String>();
        }
        this.regions.add(aRegion);
    }

    public String getCourtName() {
        return this.courtName;
    }

    public void setCourtName(String aCourtName) {
        this.courtName = aCourtName;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:mark-1.0";
    }
}

