/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.maintenance.v1_0;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPMaintenanceType
implements EPPCodecComponent {
    public static final String DEFAULT_LANG = "en";
    private static Logger cat = LoggerFactory.getLogger(EPPMaintenanceType.class);
    public static final String ELM_LOCALNAME = "type";
    public static final String ELM_NAME = "maint:type";
    private static final String ATTR_LANG = "lang";
    private String lang = "en";
    private String type;

    public EPPMaintenanceType() {
    }

    public EPPMaintenanceType(String aType) {
        this.type = aType;
    }

    public EPPMaintenanceType(String aType, String aLang) {
        this.type = aType;
        this.lang = aLang;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String aType) {
        this.type = aType;
    }

    public boolean hasLang() {
        return !this.lang.equals(DEFAULT_LANG);
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String aLang) {
        this.lang = aLang == null ? DEFAULT_LANG : aLang;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.type == null || this.lang == null) {
            throw new EPPEncodeException("required attribute is not set");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_NAME);
        Text currVal = aDocument.createTextNode(this.type);
        root.appendChild(currVal);
        root.setAttribute(ATTR_LANG, this.lang);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.type = EPPUtil.decodeStringValue(aElement);
        this.setLang(EPPUtil.decodeStringAttr(aElement, ATTR_LANG));
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPMaintenanceType)) {
            return false;
        }
        EPPMaintenanceType other = (EPPMaintenanceType)aObject;
        if (!EqualityUtil.equals(this.type, other.type)) {
            cat.error("EPPMaintenanceType.equals(): type not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.lang, other.lang)) {
            cat.error("EPPMaintenanceType.equals(): lang not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPMaintenanceType clone = null;
        clone = (EPPMaintenanceType)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:maintenance-1.0";
    }
}

