/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.maintenance.v1_0;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPMaintenanceId
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPMaintenanceId.class);
    static final String ELM_LOCALNAME = "id";
    private static final String DEFAULT_LANG = "en";
    public static final String ELM_NAME = "maint:id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_LANG = "lang";
    private String id;
    private String name = null;
    private String nameLang = "en";

    public EPPMaintenanceId() {
    }

    public EPPMaintenanceId(String aId) {
        this.id = aId;
    }

    public EPPMaintenanceId(String aId, String aName, String aNameLang) {
        this.id = aId;
        this.name = aName;
        this.setNameLang(aNameLang);
    }

    public String getId() {
        return this.id;
    }

    public void getId(String aId) {
        this.id = aId;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public boolean hasNameLang() {
        return !this.nameLang.equals(DEFAULT_LANG);
    }

    public String getNameLang() {
        return this.nameLang;
    }

    public void setNameLang(String aNameLang) {
        this.nameLang = aNameLang == null ? DEFAULT_LANG : aNameLang;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.id == null) {
            throw new EPPEncodeException("required attribute id is not set");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_NAME);
        root.appendChild(aDocument.createTextNode(this.id));
        if (this.hasName()) {
            root.setAttribute(ATTR_NAME, this.name);
            if (this.hasNameLang()) {
                root.setAttribute(ATTR_LANG, this.nameLang);
            }
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.id = EPPUtil.decodeStringValue(aElement);
        this.name = EPPUtil.decodeStringAttr(aElement, ATTR_NAME);
        this.setNameLang(EPPUtil.decodeStringAttr(aElement, ATTR_LANG));
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPMaintenanceId)) {
            return false;
        }
        EPPMaintenanceId theComp = (EPPMaintenanceId)aObject;
        if (!EqualityUtil.equals(this.id, theComp.id)) {
            cat.error("EPPMaintenenceId.equals(): id not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.name, theComp.name)) {
            cat.error("EPPMaintenenceId.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.nameLang, theComp.nameLang)) {
            cat.error("EPPMaintenenceId.equals(): nameLang not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPMaintenanceId clone = null;
        clone = (EPPMaintenanceId)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:maintenance-1.0";
    }
}

