/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.loginsecpolicy.v04;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPLoginSecPolicyEvent
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPLoginSecPolicyEvent.class);
    public static final String ELM_LOCALNAME = "event";
    public static final String ELM_NAME = "loginSecPolicy:event";
    private static final String ELM_LEVEL = "level";
    private static final String ELM_EX_DATE = "exDate";
    private static final String ELM_EX_PERIOD = "exPeriod";
    private static final String ELM_WARNING_PERIOD = "warningPeriod";
    private static final String ELM_ERROR_ACTION = "errorAction";
    private static final String ELM_THRESHOLD = "threshold";
    private static final String ELM_PERIOD = "period";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_NAME = "name";
    private EventType type;
    private String name;
    private List<EventLevel> levels = new ArrayList<EventLevel>();
    private Boolean exDate = Boolean.FALSE;
    private String exPeriod;
    private String warningPeriod;
    private EventErrorAction errorAction;
    private Integer threshold;
    private String period;

    public EPPLoginSecPolicyEvent() {
    }

    public EPPLoginSecPolicyEvent(EventType aType, EventLevel aLevel) {
        this.type = aType;
        this.addLevel(aLevel);
    }

    public EPPLoginSecPolicyEvent(EventType aType, List<EventLevel> aLevels) {
        this.type = aType;
        this.setLevels(aLevels);
    }

    public EPPLoginSecPolicyEvent(EventType aType, List<EventLevel> aLevels, String aName, Boolean aExDate, String aExPeriod, String aWarningPeriod, EventErrorAction aErrorAction, Integer aThreshold, String aPeriod) {
        this.type = aType;
        this.setLevels(aLevels);
        this.name = aName;
        this.setExDate(aExDate);
        this.exPeriod = aExPeriod;
        this.warningPeriod = aWarningPeriod;
        this.errorAction = aErrorAction;
        this.threshold = aThreshold;
        this.period = aPeriod;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPLoginSecPolicyEvent clone = null;
        clone = (EPPLoginSecPolicyEvent)super.clone();
        if (this.levels != null) {
            clone.levels = (List)((ArrayList)this.levels).clone();
        }
        return clone;
    }

    public void validateState() throws EPPCodecException {
        if (this.type == null) {
            throw new EPPCodecException("type required attribute is not set");
        }
        if (!this.hasLevels()) {
            throw new EPPCodecException("levels required attribute is not set");
        }
        if (this.levels.size() > 2) {
            throw new EPPCodecException("Maximum of levels " + this.levels.size() + " exceeds maximum of 2");
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null in EPPLoginSecPolicyEvent.encode(Document)");
        }
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error(this.getClass().getName() + ".encode(): Invalid state on encode: " + e);
            throw new EPPEncodeException("Invalid state on " + this.getClass().getName() + ".encode(): " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", ELM_NAME);
        root.setAttribute(ATTR_TYPE, this.type.toString());
        if (this.hasName()) {
            root.setAttribute(ATTR_NAME, this.name);
        }
        EPPUtil.encodeList(aDocument, root, this.levels, "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", "loginSecPolicy:level");
        EPPUtil.encodeBoolean(aDocument, root, this.exDate, "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", "loginSecPolicy:exDate");
        EPPUtil.encodeString(aDocument, root, this.exPeriod, "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", "loginSecPolicy:exPeriod");
        EPPUtil.encodeString(aDocument, root, this.warningPeriod, "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", "loginSecPolicy:warningPeriod");
        if (this.hasErrorAction()) {
            EPPUtil.encodeString(aDocument, root, this.errorAction.toString(), "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", "loginSecPolicy:errorAction");
        }
        EPPUtil.encodeInteger(aDocument, root, this.threshold, "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", "loginSecPolicy:threshold");
        EPPUtil.encodeString(aDocument, root, this.period, "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", "loginSecPolicy:period");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.type = EventType.valueOf(EPPUtil.decodeStringAttr(aElement, ATTR_TYPE));
        this.name = EPPUtil.decodeStringAttr(aElement, ATTR_NAME);
        this.levels = EPPUtil.decodeEnumList(aElement, "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", ELM_LEVEL, EventLevel.class);
        this.setExDate(EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", ELM_EX_DATE));
        this.exPeriod = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", ELM_EX_PERIOD);
        this.warningPeriod = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", ELM_WARNING_PERIOD);
        String theErrorAction = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", ELM_ERROR_ACTION);
        this.errorAction = theErrorAction == null ? null : EventErrorAction.valueOf(theErrorAction);
        this.threshold = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", ELM_THRESHOLD);
        this.period = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", ELM_PERIOD);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLoginSecPolicyEvent)) {
            return false;
        }
        EPPLoginSecPolicyEvent other = (EPPLoginSecPolicyEvent)aObject;
        if (!EqualityUtil.equals(this.type, other.type)) {
            cat.error("EPPLoginSecPolicyEvent.equals(): type not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.name, other.name)) {
            cat.error("EPPLoginSecPolicyEvent.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.exDate, other.exDate)) {
            cat.error("EPPLoginSecPolicyEvent.equals(): exDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.exPeriod, other.exPeriod)) {
            cat.error("EPPLoginSecPolicyEvent.equals(): exPeriod not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.warningPeriod, other.warningPeriod)) {
            cat.error("EPPLoginSecPolicyEvent.equals(): warningPeriod not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.errorAction, other.errorAction)) {
            cat.error("EPPLoginSecPolicyEvent.equals(): errorAction not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.threshold, other.threshold)) {
            cat.error("EPPLoginSecPolicyEvent.equals(): threshold not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.period, other.period)) {
            cat.error("EPPLoginSecPolicyEvent.equals(): period not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4";
    }

    public boolean hasType() {
        return this.type != null;
    }

    public EventType getType() {
        return this.type;
    }

    public void setType(EventType aType) {
        this.type = aType;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public boolean hasLevels() {
        return this.levels != null && !this.levels.isEmpty();
    }

    public List<EventLevel> getLevels() {
        return this.levels;
    }

    public void setLevels(List<EventLevel> aLevels) {
        this.levels = aLevels == null ? new ArrayList<EventLevel>() : aLevels;
    }

    public void addLevel(EventLevel aLevel) {
        if (aLevel == null) {
            this.levels = new ArrayList<EventLevel>();
        }
        this.levels.add(aLevel);
    }

    public Boolean getExDate() {
        return this.exDate;
    }

    public void setExDate(Boolean aExDate) {
        this.exDate = aExDate == null ? Boolean.FALSE : aExDate;
    }

    public boolean hasExPeriod() {
        return this.exPeriod != null;
    }

    public String getExPeriod() {
        return this.exPeriod;
    }

    public void setExPeriod(String aExPeriod) {
        this.exPeriod = aExPeriod;
    }

    public boolean hasWarningPeriod() {
        return this.warningPeriod != null;
    }

    public String getWarningPeriod() {
        return this.warningPeriod;
    }

    public void setWarningPeriod(String aWarningPeriod) {
        this.warningPeriod = aWarningPeriod;
    }

    public boolean hasErrorAction() {
        return this.errorAction != null;
    }

    public EventErrorAction getErrorAction() {
        return this.errorAction;
    }

    public void setErrorAction(EventErrorAction aErrorAction) {
        this.errorAction = aErrorAction;
    }

    public boolean hasThreshold() {
        return this.threshold != null;
    }

    public Integer getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Integer aThreshold) {
        this.threshold = aThreshold;
    }

    public boolean hasPeriod() {
        return this.period != null;
    }

    public String getPeriod() {
        return this.period;
    }

    public void setPeriod(String aPeriod) {
        this.period = aPeriod;
    }

    public static enum EventErrorAction implements Serializable,
    Cloneable
    {
        connect,
        login,
        none;

    }

    public static enum EventLevel implements Serializable,
    Cloneable
    {
        warning,
        error;

    }

    public static enum EventType implements Serializable,
    Cloneable
    {
        password,
        certificate,
        cipher,
        tlsProtocol,
        newPW,
        stat,
        custom;

    }
}

