/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.launchpolicy.v01;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPLaunchPolicyPollPolicy
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPLaunchPolicyPollPolicy.class);
    public static final String ELM_LOCALNAME = "pollPolicy";
    public static final String ELM_NAME = "lp:pollPolicy";
    private static final String ELM_INTERMEDIATE_STATUS = "intermediateStatus";
    private static final String ELM_NON_MANDATORY_INFO = "nonMandatoryInfo";
    private static final String ELM_EXTENSION_INFO = "extensionInfo";
    private Boolean intermediateStatus;
    private Boolean nonMandatoryInfo;
    private Boolean extensionInfo;

    public EPPLaunchPolicyPollPolicy() {
    }

    public EPPLaunchPolicyPollPolicy(Boolean aIntermediateStatus, Boolean aNonMandatoryInfo, Boolean aExtensionInfo) {
        this.intermediateStatus = aIntermediateStatus;
        this.nonMandatoryInfo = aNonMandatoryInfo;
        this.extensionInfo = aExtensionInfo;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.intermediateStatus == null) {
            throw new EPPEncodeException("Undefined intermediateStatus in EPPLaunchPolicyPollPolicy");
        }
        if (this.nonMandatoryInfo == null) {
            throw new EPPEncodeException("Undefined nonMandatoryInfo in EPPLaunchPolicyPollPolicy");
        }
        if (this.extensionInfo == null) {
            throw new EPPEncodeException("Undefined extensionInfo in EPPLaunchPolicyPollPolicy");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:launchPolicy-0.1", ELM_NAME);
        EPPUtil.encodeBoolean(aDocument, root, this.intermediateStatus, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", "lp:intermediateStatus");
        EPPUtil.encodeBoolean(aDocument, root, this.nonMandatoryInfo, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", "lp:nonMandatoryInfo");
        EPPUtil.encodeBoolean(aDocument, root, this.extensionInfo, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", "lp:extensionInfo");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.intermediateStatus = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", ELM_INTERMEDIATE_STATUS);
        this.nonMandatoryInfo = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", ELM_NON_MANDATORY_INFO);
        this.extensionInfo = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:launchPolicy-0.1", ELM_EXTENSION_INFO);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPLaunchPolicyPollPolicy clone = (EPPLaunchPolicyPollPolicy)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLaunchPolicyPollPolicy)) {
            return false;
        }
        EPPLaunchPolicyPollPolicy other = (EPPLaunchPolicyPollPolicy)aObject;
        if (!EqualityUtil.equals(this.intermediateStatus, other.intermediateStatus)) {
            cat.error("EPPLaunchPolicyPollPolicy.equals(): intermediateStatus not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.nonMandatoryInfo, other.nonMandatoryInfo)) {
            cat.error("EPPLaunchPolicyPollPolicy.equals(): nonMandatoryInfo not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.extensionInfo, other.extensionInfo)) {
            cat.error("EPPLaunchPolicyPollPolicy.equals(): extensionInfo not equal");
            return false;
        }
        return true;
    }

    public Boolean getIntermediateStatus() {
        return this.intermediateStatus;
    }

    public void setIntermediateStatus(Boolean aIntermediateStatus) {
        this.intermediateStatus = aIntermediateStatus;
    }

    public Boolean getNonMandatoryInfo() {
        return this.nonMandatoryInfo;
    }

    public void setNonMandatoryInfo(Boolean aNonMandatoryInfo) {
        this.nonMandatoryInfo = aNonMandatoryInfo;
    }

    public Boolean getExtensionInfo() {
        return this.extensionInfo;
    }

    public void setExtensionInfo(Boolean aExtensionInfo) {
        this.extensionInfo = aExtensionInfo;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:launchPolicy-0.1";
    }
}

